/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.authorization.strategies.page;

import java.lang.ref.WeakReference;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.RestartResponseAtInterceptPageException;
import org.apache.wicket.authorization.IUnauthorizedComponentInstantiationListener;
import org.apache.wicket.authorization.UnauthorizedInstantiationException;
import org.apache.wicket.authorization.strategies.page.AbstractPageAuthorizationStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimplePageAuthorizationStrategy
extends AbstractPageAuthorizationStrategy {
    private final WeakReference<Class<?>> securePageSuperTypeRef;

    public <S extends Page> SimplePageAuthorizationStrategy(Class<?> securePageSuperType, final Class<S> signInPageClass) {
        if (securePageSuperType == null) {
            throw new IllegalArgumentException("Secure page super type must not be null");
        }
        this.securePageSuperTypeRef = new WeakReference(securePageSuperType);
        Application.get().getSecuritySettings().setUnauthorizedComponentInstantiationListener(new IUnauthorizedComponentInstantiationListener(){

            public void onUnauthorizedInstantiation(Component component) {
                if (component instanceof Page) {
                    throw new RestartResponseAtInterceptPageException(signInPageClass);
                }
                throw new UnauthorizedInstantiationException(component.getClass());
            }
        });
    }

    @Override
    protected <T extends Page> boolean isPageAuthorized(Class<T> pageClass) {
        if (this.instanceOf(pageClass, (Class)this.securePageSuperTypeRef.get())) {
            return this.isAuthorized();
        }
        return true;
    }

    protected abstract boolean isAuthorized();
}

