/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.ldap;

import java.util.Set;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;
import org.identityconnectors.framework.spi.operations.AuthenticateOp;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.ResolveUsernameOp;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.SyncOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;
import org.identityconnectors.ldap.LdapAuthenticate;
import org.identityconnectors.ldap.LdapConfiguration;
import org.identityconnectors.ldap.LdapConnection;
import org.identityconnectors.ldap.modify.LdapCreate;
import org.identityconnectors.ldap.modify.LdapDelete;
import org.identityconnectors.ldap.modify.LdapUpdate;
import org.identityconnectors.ldap.search.LdapFilter;
import org.identityconnectors.ldap.search.LdapFilterTranslator;
import org.identityconnectors.ldap.search.LdapSearch;
import org.identityconnectors.ldap.sync.sunds.SunDSChangeLogSyncStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ConnectorClass(configurationClass=LdapConfiguration.class, displayNameKey="LdapConnector")
public class LdapConnector
implements TestOp,
PoolableConnector,
SchemaOp,
SearchOp<LdapFilter>,
AuthenticateOp,
ResolveUsernameOp,
CreateOp,
DeleteOp,
UpdateAttributeValuesOp,
SyncOp {
    private LdapConfiguration config;
    private LdapConnection conn;

    public Configuration getConfiguration() {
        return this.config;
    }

    public void init(Configuration cfg) {
        this.config = (LdapConfiguration)cfg;
        this.conn = new LdapConnection(this.config);
    }

    public void dispose() {
        this.conn.close();
    }

    public void test() {
        this.conn.test();
    }

    public void checkAlive() {
        this.conn.checkAlive();
    }

    public Schema schema() {
        return this.conn.getSchemaMapping().schema();
    }

    public Uid authenticate(ObjectClass objectClass, String username, GuardedString password, OperationOptions options) {
        return new LdapAuthenticate(this.conn, objectClass, username, options).authenticate(password);
    }

    public Uid resolveUsername(ObjectClass objectClass, String username, OperationOptions options) {
        return new LdapAuthenticate(this.conn, objectClass, username, options).resolveUsername();
    }

    public FilterTranslator<LdapFilter> createFilterTranslator(ObjectClass oclass, OperationOptions options) {
        return new LdapFilterTranslator(this.conn.getSchemaMapping(), oclass);
    }

    public void executeQuery(ObjectClass oclass, LdapFilter query, ResultsHandler handler, OperationOptions options) {
        new LdapSearch(this.conn, oclass, query, options).execute(handler);
    }

    public Uid create(ObjectClass oclass, Set<Attribute> attrs, OperationOptions options) {
        return new LdapCreate(this.conn, oclass, attrs, options).execute();
    }

    public void delete(ObjectClass oclass, Uid uid, OperationOptions options) {
        new LdapDelete(this.conn, oclass, uid).execute();
    }

    public Uid update(ObjectClass oclass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        return new LdapUpdate(this.conn, oclass, uid).update(replaceAttributes);
    }

    public Uid addAttributeValues(ObjectClass oclass, Uid uid, Set<Attribute> valuesToAdd, OperationOptions options) {
        return new LdapUpdate(this.conn, oclass, uid).addAttributeValues(valuesToAdd);
    }

    public Uid removeAttributeValues(ObjectClass oclass, Uid uid, Set<Attribute> valuesToRemove, OperationOptions options) {
        return new LdapUpdate(this.conn, oclass, uid).removeAttributeValues(valuesToRemove);
    }

    public SyncToken getLatestSyncToken(ObjectClass oclass) {
        return new SunDSChangeLogSyncStrategy(this.conn, oclass).getLatestSyncToken();
    }

    public void sync(ObjectClass oclass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        new SunDSChangeLogSyncStrategy(this.conn, oclass).sync(token, handler, options);
    }
}

