/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.databasetable;

import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.databasetable.DatabaseTableSQLUtil;
import org.identityconnectors.dbcommon.JNDIUtil;
import org.identityconnectors.framework.common.objects.ConnectorMessages;
import org.identityconnectors.framework.spi.AbstractConfiguration;
import org.identityconnectors.framework.spi.ConfigurationProperty;
import org.identityconnectors.framework.spi.operations.SyncOp;

public class DatabaseTableConfiguration
extends AbstractConfiguration {
    static Log log = Log.getLog(DatabaseTableConfiguration.class);
    private String quoting = "";
    private String host = "";
    private String port = "";
    private String user = "";
    private GuardedString password;
    private String database = "";
    private String table = "";
    private String keyColumn = "";
    private String passwordColumn = "";
    private String jdbcDriver = "oracle.jdbc.driver.OracleDriver";
    private String jdbcUrlTemplate = "jdbc:oracle:thin:@%h:%p:%d";
    public boolean enableEmptyString = false;
    public boolean rethrowAllSQLExceptions = true;
    public boolean nativeTimestamps = false;
    public boolean allNative = false;
    private String validConnectionQuery;
    private String changeLogColumn = "";
    private String datasource = "";
    private String[] jndiProperties;

    @ConfigurationProperty(order=1, displayMessageKey="QUOTING_DISPLAY", helpMessageKey="QUOTING_HELP")
    public String getQuoting() {
        return this.quoting;
    }

    public void setQuoting(String value) {
        this.quoting = value;
    }

    @ConfigurationProperty(order=2, displayMessageKey="HOST_DISPLAY", helpMessageKey="HOST_HELP")
    public String getHost() {
        return this.host;
    }

    public void setHost(String value) {
        this.host = value;
    }

    @ConfigurationProperty(order=3, displayMessageKey="PORT_DISPLAY", helpMessageKey="PORT_HELP")
    public String getPort() {
        return this.port;
    }

    public void setPort(String value) {
        this.port = value;
    }

    @ConfigurationProperty(order=4, displayMessageKey="USER_DISPLAY", helpMessageKey="USER_HELP")
    public String getUser() {
        return this.user;
    }

    public void setUser(String value) {
        this.user = value;
    }

    @ConfigurationProperty(order=5, confidential=true, displayMessageKey="PASSWORD_DISPLAY", helpMessageKey="PASSWORD_HELP")
    public GuardedString getPassword() {
        return this.password;
    }

    public void setPassword(GuardedString value) {
        this.password = value;
    }

    @ConfigurationProperty(order=6, displayMessageKey="DATABASE_DISPLAY", helpMessageKey="DATABASE_HELP")
    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String value) {
        this.database = value;
    }

    @ConfigurationProperty(order=7, required=true, displayMessageKey="TABLE_DISPLAY", helpMessageKey="TABLE_HELP")
    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @ConfigurationProperty(order=8, required=true, displayMessageKey="KEY_COLUMN_DISPLAY", helpMessageKey="KEY_COLUMN_HELP")
    public String getKeyColumn() {
        return this.keyColumn;
    }

    public void setKeyColumn(String keyColumn) {
        this.keyColumn = keyColumn;
    }

    @ConfigurationProperty(order=9, displayMessageKey="PASSWORD_COLUMN_DISPLAY", helpMessageKey="PASSWORD_COLUMN_HELP")
    public String getPasswordColumn() {
        return this.passwordColumn;
    }

    public void setPasswordColumn(String value) {
        this.passwordColumn = value;
    }

    @ConfigurationProperty(order=10, displayMessageKey="JDBC_DRIVER_DISPLAY", helpMessageKey="JDBC_DRIVER_HELP")
    public String getJdbcDriver() {
        return this.jdbcDriver;
    }

    public void setJdbcDriver(String value) {
        this.jdbcDriver = value;
    }

    @ConfigurationProperty(order=11, displayMessageKey="URL_TEMPLATE_DISPLAY", helpMessageKey="URL_TEMPLATE_HELP")
    public String getJdbcUrlTemplate() {
        return this.jdbcUrlTemplate;
    }

    public void setJdbcUrlTemplate(String value) {
        this.jdbcUrlTemplate = value;
    }

    @ConfigurationProperty(order=12, displayMessageKey="ENABLE_EMPTY_STRING_DISPLAY", helpMessageKey="ENABLE_EMPTY_STRING_HELP")
    public boolean isEnableEmptyString() {
        return this.enableEmptyString;
    }

    public void setEnableEmptyString(boolean enableEmptyString) {
        this.enableEmptyString = enableEmptyString;
    }

    @ConfigurationProperty(order=14, displayMessageKey="RETHROW_ALL_SQLEXCEPTIONS_DISPLAY", helpMessageKey="RETHROW_ALL_SQLEXCEPTIONS_HELP")
    public boolean isRethrowAllSQLExceptions() {
        return this.rethrowAllSQLExceptions;
    }

    public void setRethrowAllSQLExceptions(boolean rethrowAllSQLExceptions) {
        this.rethrowAllSQLExceptions = rethrowAllSQLExceptions;
    }

    @ConfigurationProperty(order=15, displayMessageKey="NATIVE_TIMESTAMPS_DISPLAY", helpMessageKey="NATIVE_TIMESTAMPS_HELP")
    public boolean isNativeTimestamps() {
        return this.nativeTimestamps;
    }

    public void setNativeTimestamps(boolean nativeTimestamps) {
        this.nativeTimestamps = nativeTimestamps;
    }

    @ConfigurationProperty(order=16, displayMessageKey="ALL_NATIVE_DISPLAY", helpMessageKey="ALL_NATIVE_HELP")
    public boolean isAllNative() {
        return this.allNative;
    }

    public void setAllNative(boolean allNative) {
        this.allNative = allNative;
    }

    @ConfigurationProperty(order=17, displayMessageKey="VALID_CONNECTION_QUERY_DISPLAY", helpMessageKey="VALID_CONNECTION_QUERY_HELP")
    public String getValidConnectionQuery() {
        return this.validConnectionQuery;
    }

    public void setValidConnectionQuery(String value) {
        this.validConnectionQuery = value;
    }

    @ConfigurationProperty(order=19, operations={SyncOp.class}, displayMessageKey="CHANGE_LOG_COLUMN_DISPLAY", helpMessageKey="CHANGE_LOG_COLUMN_HELP")
    public String getChangeLogColumn() {
        return this.changeLogColumn;
    }

    public void setChangeLogColumn(String value) {
        this.changeLogColumn = value;
    }

    @ConfigurationProperty(order=20, displayMessageKey="DATASOURCE_DISPLAY", helpMessageKey="DATASOURCE_HELP")
    public String getDatasource() {
        return this.datasource;
    }

    public void setDatasource(String value) {
        this.datasource = value;
    }

    @ConfigurationProperty(order=21, displayMessageKey="JNDI_PROPERTIES_DISPLAY", helpMessageKey="JNDI_PROPERTIES_HELP")
    public String[] getJndiProperties() {
        return this.jndiProperties;
    }

    public void setJndiProperties(String[] value) {
        this.jndiProperties = value;
    }

    public void validate() {
        log.info("Validate DatabaseTableConfiguration", new Object[0]);
        if (StringUtil.isBlank((String)this.getTable())) {
            throw new IllegalArgumentException(this.getMessage("table.blank"));
        }
        if (StringUtil.isBlank((String)this.getJdbcUrlTemplate())) {
            throw new IllegalArgumentException(this.getMessage("jdbc.template.blank"));
        }
        if (StringUtil.isBlank((String)this.getKeyColumn())) {
            throw new IllegalArgumentException(this.getMessage("key.column.blank"));
        }
        if (this.getKeyColumn().equalsIgnoreCase(this.getChangeLogColumn())) {
            throw new IllegalArgumentException(this.getMessage("key.column.eq.change.log.column"));
        }
        if (StringUtil.isNotBlank((String)this.getPasswordColumn())) {
            if (this.getPasswordColumn().equalsIgnoreCase(this.getKeyColumn())) {
                throw new IllegalArgumentException(this.getMessage("passwd.column.eq.key.column"));
            }
            if (this.getPasswordColumn().equalsIgnoreCase(this.getChangeLogColumn())) {
                throw new IllegalArgumentException(this.getMessage("passwd.column.eq.change.log.column"));
            }
        }
        if (StringUtil.isBlank((String)this.getDatasource())) {
            log.info("Validate driver configuration.", new Object[0]);
            if (this.getUser() == null) {
                throw new IllegalArgumentException(this.getMessage("admin.user.blank"));
            }
            if (this.getPassword() == null) {
                throw new IllegalArgumentException(this.getMessage("admin.password.blank"));
            }
            if (this.getJdbcUrlTemplate().contains("%h") && StringUtil.isBlank((String)this.getHost())) {
                throw new IllegalArgumentException(this.getMessage("host.blank"));
            }
            if (this.getJdbcUrlTemplate().contains("%p") && StringUtil.isBlank((String)this.getPort())) {
                throw new IllegalArgumentException(this.getMessage("port.blank"));
            }
            if (this.getJdbcUrlTemplate().contains("%d") && StringUtil.isBlank((String)this.getDatabase())) {
                throw new IllegalArgumentException(this.getMessage("database.blank"));
            }
            if (StringUtil.isBlank((String)this.getJdbcDriver())) {
                throw new IllegalArgumentException(this.getMessage("jdbc.driver.blank"));
            }
            try {
                Class.forName(this.getJdbcDriver());
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(this.getMessage("jdbc.driver.not.found"));
            }
            log.ok("driver configuration is ok", new Object[0]);
        } else {
            log.info("Validate datasource configuration", new Object[0]);
            JNDIUtil.arrayToHashtable((String[])this.getJndiProperties(), (ConnectorMessages)this.getConnectorMessages());
            log.ok("datasource configuration is ok", new Object[0]);
        }
        try {
            DatabaseTableSQLUtil.quoteName(this.getQuoting(), "test");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(this.getMessage("invalid.quoting", this.getQuoting()));
        }
        log.ok("Configuration is valid", new Object[0]);
    }

    public String formatUrlTemplate() {
        log.info("format UrlTemplate", new Object[0]);
        StringBuffer b = new StringBuffer();
        String url = this.getJdbcUrlTemplate();
        int len = url.length();
        for (int i = 0; i < len; ++i) {
            char ch = url.charAt(i);
            if (ch != '%') {
                b.append(ch);
                continue;
            }
            if (i + 1 >= len) continue;
            if ((ch = url.charAt(++i)) == '%') {
                b.append(ch);
                continue;
            }
            if (ch == 'h') {
                b.append(this.getHost());
                continue;
            }
            if (ch == 'p') {
                b.append(this.getPort());
                continue;
            }
            if (ch != 'd') continue;
            b.append(this.getDatabase());
        }
        String formattedURL = b.toString();
        log.ok("UrlTemplate is formated to {0}", new Object[]{formattedURL});
        return formattedURL;
    }

    public String getMessage(String key) {
        String fmt = this.getConnectorMessages().format(key, key, new Object[0]);
        log.ok("Get for a key {0} connector message {1}", new Object[]{key, fmt});
        return fmt;
    }

    public String getMessage(String key, Object ... objects) {
        String fmt = this.getConnectorMessages().format(key, key, objects);
        log.ok("Get for a key {0} connector message {1}", new Object[]{key, fmt});
        return fmt;
    }
}

