/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.impl;

import com.evolveum.midpoint.common.valueconstruction.ValueConstruction;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.provisioning.consistency.api.ErrorHandler;
import com.evolveum.midpoint.provisioning.consistency.impl.ErrorHandlerFactory;
import com.evolveum.midpoint.provisioning.impl.ShadowConverter;
import com.evolveum.midpoint.provisioning.ucf.api.Change;
import com.evolveum.midpoint.provisioning.ucf.api.ExecuteScriptArgument;
import com.evolveum.midpoint.provisioning.ucf.api.ExecuteScriptOperation;
import com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException;
import com.evolveum.midpoint.provisioning.ucf.api.Operation;
import com.evolveum.midpoint.provisioning.ucf.api.PasswordChangeOperation;
import com.evolveum.midpoint.provisioning.ucf.api.PropertyModificationOperation;
import com.evolveum.midpoint.provisioning.util.ShadowCacheUtil;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.DeltaConvertor;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceObjectShadowUtil;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.FailedOperationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.PasswordType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ProtectedStringType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptArgumentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptHostType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import com.evolveum.prism.xml.ns._public.types_2.ObjectDeltaType;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ShadowCache {
    @Autowired(required=true)
    @Qualifier(value="cacheRepositoryService")
    private RepositoryService repositoryService = null;
    @Autowired(required=true)
    private ShadowConverter shadowConverter;
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private ErrorHandlerFactory errorHandlerFactory;
    private static final Trace LOGGER = TraceManager.getTrace(ShadowCache.class);

    public RepositoryService getRepositoryService() {
        return this.repositoryService;
    }

    public void setRepositoryService(RepositoryService repositoryService) {
        this.repositoryService = repositoryService;
    }

    public <T extends ResourceObjectShadowType> T getShadow(Class<T> type, String oid, T repositoryShadow, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException, SecurityViolationException {
        Validate.notNull((Object)oid, (String)"Object id must not be null.");
        LOGGER.trace("Start getting object with oid {}", (Object)oid);
        if (repositoryShadow == null) {
            PrismObject repositoryPrism = this.getRepositoryService().getObject(type, oid, parentResult);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Found shadow object:\n{}", (Object)repositoryPrism.dump());
            }
            repositoryShadow = (ResourceObjectShadowType)repositoryPrism.asObjectable();
        }
        if (!oid.equals(repositoryShadow.getOid())) {
            parentResult.recordFatalError("Provided OID is not equal to OID of repository shadow");
            throw new IllegalArgumentException("Provided OID is not equal to OID of repository shadow");
        }
        ResourceType resource = this.getResource(ResourceObjectShadowUtil.getResourceOid(repositoryShadow), parentResult);
        LOGGER.trace("Getting fresh object from ucf.");
        T resultShadow = null;
        try {
            resultShadow = this.shadowConverter.getShadow(type, resource, repositoryShadow, parentResult);
        }
        catch (ObjectNotFoundException ex) {
            parentResult.recordFatalError("Object " + ObjectTypeUtil.toShortString(repositoryShadow) + "not found on the " + ObjectTypeUtil.toShortString((ObjectType)resource), (Throwable)ex);
            throw ex;
        }
        catch (CommunicationException communicationException) {
            parentResult.recordWarning("Cannot get " + ObjectTypeUtil.toShortString(repositoryShadow) + " from resource " + resource.getName() + ", because the resource is unreachable. The returned object is one from the repository.");
            repositoryShadow.setFetchResult(parentResult.createOperationResultType());
            return repositoryShadow;
        }
        catch (ConfigurationException ex) {
            parentResult.recordFatalError("Configuration error. Reason: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        parentResult.recordSuccess();
        return resultShadow;
    }

    public String addShadow(ResourceObjectShadowType shadow, boolean isReconciled, ScriptsType scripts, ResourceType resource, OperationResult parentResult) throws CommunicationException, GenericFrameworkException, ObjectAlreadyExistsException, SchemaException, ObjectNotFoundException, ConfigurationException, SecurityViolationException {
        PasswordType password;
        ProtectedStringType protectedString;
        AccountShadowType account;
        Validate.notNull((Object)shadow, (String)"Object to add must not be null.");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Start adding shadow object:\n{}", (Object)shadow.asPrismObject().dump());
            LOGGER.trace("Scripts: {}", (Object)SchemaDebugUtil.dumpJaxbObject((Object)scripts, (String)"scripts", (PrismContext)shadow.asPrismObject().getPrismContext()));
        }
        if (resource == null) {
            String resourceOid = ResourceObjectShadowUtil.getResourceOid((ResourceObjectShadowType)shadow);
            if (StringUtils.isEmpty((String)resourceOid)) {
                throw new SchemaException("Shadow " + shadow + " does not have an resource OID, cannot add it.");
            }
            resource = this.getResource(resourceOid, parentResult);
        }
        HashSet<Operation> additionalOperations = new HashSet<Operation>();
        if (shadow instanceof AccountShadowType && (account = (AccountShadowType)shadow).getCredentials() != null && account.getCredentials().getPassword() != null && (protectedString = (password = account.getCredentials().getPassword()).getProtectedString()) != null) {
            PasswordChangeOperation passOp = new PasswordChangeOperation(protectedString);
            additionalOperations.add(passOp);
        }
        this.addExecuteScriptOperation(additionalOperations, OperationTypeType.ADD, scripts, parentResult);
        OperationResult shadowConverterResult = parentResult.createSubresult(String.valueOf(ShadowConverter.class.getName()) + ".addShadow");
        try {
            shadow = this.shadowConverter.addShadow(resource, shadow, additionalOperations, isReconciled, shadowConverterResult);
        }
        catch (Exception ex) {
            ErrorHandler handler = this.errorHandlerFactory.createErrorHandler(ex);
            shadow.setFailedOperationType(FailedOperationTypeType.ADD);
            shadow.setResult(shadowConverterResult.createOperationResultType());
            shadow.setResource(resource);
            if (handler != null) {
                handler.handleError(shadow, ex);
            }
            parentResult.recordFatalError("Error without a handler. Reason: " + ex.getMessage(), (Throwable)ex);
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
        if (shadow == null) {
            parentResult.recordFatalError("Error while creating account shadow object to save in the reposiotory. AccountShadow is null.");
            throw new IllegalStateException("Error while creating account shadow object to save in the reposiotory. AccountShadow is null.");
        }
        LOGGER.trace("Adding object with identifiers to the repository.");
        LOGGER.trace("Reconciled shadow: {}", (Object)isReconciled);
        this.addOrReplaceShadowToRepository(shadow, isReconciled, shadowConverterResult.isError(), parentResult);
        LOGGER.trace("Object added to the repository successfully.");
        parentResult.recordSuccess();
        return shadow.getOid();
    }

    public void deleteShadow(ObjectType objectType, ScriptsType scripts, ResourceType resource, OperationResult parentResult) throws CommunicationException, GenericFrameworkException, ObjectNotFoundException, SchemaException, ConfigurationException, SecurityViolationException {
        Validate.notNull((Object)objectType, (String)"Object to delete must not be null.");
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        if (objectType instanceof AccountShadowType) {
            AccountShadowType accountShadow = (AccountShadowType)objectType;
            if (resource == null) {
                resource = this.getResource(ResourceObjectShadowUtil.getResourceOid((ResourceObjectShadowType)accountShadow), parentResult);
            }
            LOGGER.trace("Deleting obeject {} from the resource {}.", (Object)ObjectTypeUtil.toShortString((ObjectType)objectType), (Object)ObjectTypeUtil.toShortString((ObjectType)resource));
            HashSet<Operation> additionalOperations = new HashSet<Operation>();
            this.addExecuteScriptOperation(additionalOperations, OperationTypeType.DELETE, scripts, parentResult);
            try {
                this.shadowConverter.deleteShadow(resource, (ResourceObjectShadowType)accountShadow, additionalOperations, parentResult);
            }
            catch (Exception ex) {
                ErrorHandler handler = this.errorHandlerFactory.createErrorHandler(ex);
                accountShadow.setFailedOperationType(FailedOperationTypeType.DELETE);
                accountShadow.setResult(parentResult.createOperationResultType());
                accountShadow.setResource(resource);
                try {
                    handler.handleError((ResourceObjectShadowType)accountShadow, ex);
                }
                catch (ObjectAlreadyExistsException e) {
                    e.printStackTrace();
                }
                return;
            }
            LOGGER.trace("Detele object with oid {} form repository.", (Object)accountShadow.getOid());
            try {
                this.getRepositoryService().deleteObject(AccountShadowType.class, accountShadow.getOid(), parentResult);
            }
            catch (ObjectNotFoundException ex) {
                parentResult.recordFatalError("Can't delete object " + ObjectTypeUtil.toShortString((ObjectType)accountShadow) + ". Reason: " + ex.getMessage(), (Throwable)ex);
                throw new ObjectNotFoundException("An error occured while deleting resource object " + accountShadow + "whith identifiers " + ObjectTypeUtil.toShortString((ObjectType)accountShadow) + ": " + ex.getMessage(), (Throwable)ex);
            }
            LOGGER.trace("Object deleted from repository successfully.");
            parentResult.recordSuccess();
        }
    }

    public void modifyShadow(ObjectType objectType, ResourceType resource, String oid, Collection<? extends ItemDelta> modifications, boolean isReconciled, ScriptsType scripts, OperationResult parentResult) throws CommunicationException, GenericFrameworkException, ObjectNotFoundException, SchemaException, ConfigurationException, SecurityViolationException {
        Validate.notNull((Object)objectType, (String)"Object to modify must not be null.");
        Validate.notNull((Object)oid, (String)"OID must not be null.");
        Validate.notNull(modifications, (String)"Object modification must not be null.");
        if (objectType instanceof ResourceObjectShadowType) {
            ResourceObjectShadowType shadow = (ResourceObjectShadowType)objectType;
            if (resource == null) {
                String resourceOid = ResourceObjectShadowUtil.getResourceOid((ResourceObjectShadowType)shadow);
                if (resourceOid == null) {
                    throw new SchemaException("No resource OID in " + shadow);
                }
                resource = this.getResource(resourceOid, parentResult);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Modifying resource with oid {}, object:\n{}", (Object)resource.getOid(), (Object)shadow.asPrismObject().dump());
            }
            HashSet<Operation> changes = new HashSet<Operation>();
            this.addExecuteScriptOperation(changes, OperationTypeType.MODIFY, scripts, parentResult);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Applying change: {}", (Object)DebugUtil.debugDump(modifications));
            }
            Set<PropertyModificationOperation> sideEffectChanges = null;
            try {
                sideEffectChanges = this.shadowConverter.modifyShadow(resource, shadow, changes, oid, modifications, parentResult);
            }
            catch (Exception ex) {
                ErrorHandler handler = this.errorHandlerFactory.createErrorHandler(ex);
                if (shadow.getFailedOperationType() == null || FailedOperationTypeType.ADD != shadow.getFailedOperationType()) {
                    shadow.setFailedOperationType(FailedOperationTypeType.MODIFY);
                }
                shadow.setResult(parentResult.createOperationResultType());
                shadow.setResource(resource);
                ObjectDelta objectDelta = ObjectDelta.createModifyDelta((String)shadow.getOid(), modifications, objectType.getClass());
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Storing delta to shadow:\n{}", (Object)objectDelta.dump());
                }
                ObjectDeltaType objectDeltaType = DeltaConvertor.toObjectDeltaType((ObjectDelta)objectDelta);
                shadow.setObjectChange(objectDeltaType);
                try {
                    handler.handleError(shadow, ex);
                }
                catch (ObjectAlreadyExistsException objectAlreadyExistsException) {}
                parentResult.recordSuccess();
                return;
            }
            if (isReconciled) {
                try {
                    this.addOrReplaceShadowToRepository(shadow, isReconciled, false, parentResult);
                }
                catch (ObjectAlreadyExistsException objectAlreadyExistsException) {}
            }
            if (!sideEffectChanges.isEmpty()) {
                throw new UnsupportedOperationException("Handling of side-effect changes is not yet supported");
            }
            parentResult.recordSuccess();
        }
    }

    public PrismProperty fetchCurrentToken(ResourceType resourceType, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException {
        Validate.notNull((Object)resourceType, (String)"Resource must not be null.");
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        LOGGER.trace("Getting last token");
        PrismProperty lastToken = null;
        try {
            lastToken = this.shadowConverter.fetchCurrentToken(resourceType, parentResult);
        }
        catch (CommunicationException e) {
            parentResult.recordFatalError(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (ConfigurationException e) {
            parentResult.recordFatalError(e.getMessage(), (Throwable)e);
            throw e;
        }
        LOGGER.trace("Got last token: {}", (Object)SchemaDebugUtil.prettyPrint((Object)lastToken));
        parentResult.recordSuccess();
        return lastToken;
    }

    public List<Change> fetchChanges(ResourceType resourceType, PrismProperty lastToken, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, GenericFrameworkException, SchemaException, ConfigurationException, SecurityViolationException {
        List<Change> changes = null;
        try {
            changes = this.shadowConverter.fetchChanges(resourceType, lastToken, parentResult);
            LOGGER.trace("Found {} change(s). Start processing it (them).", (Object)changes.size());
            for (Change change : changes) {
                ResourceObjectShadowType currentShadowType;
                ResourceObjectShadowType newShadow = this.findOrCreateShadowFromChange(resourceType, change, parentResult);
                LOGGER.trace("Old shadow: {}", (Object)ObjectTypeUtil.toShortString((ObjectType)newShadow));
                if (newShadow == null) {
                    change.setOldShadow(null);
                    continue;
                }
                change.setOldShadow((PrismObject<? extends ResourceObjectShadowType>)newShadow.asPrismObject());
                if (change.getCurrentShadow() != null && (currentShadowType = (ResourceObjectShadowType)change.getCurrentShadow().asObjectable()) != null) {
                    currentShadowType.setOid(newShadow.getOid());
                    currentShadowType.setResourceRef(newShadow.getResourceRef());
                    if (currentShadowType instanceof AccountShadowType && newShadow instanceof AccountShadowType) {
                        ((AccountShadowType)currentShadowType).setAccountType(((AccountShadowType)newShadow).getAccountType());
                    }
                }
                if (change.getObjectDelta() == null || change.getObjectDelta().getOid() != null) continue;
                if (newShadow instanceof AccountShadowType) {
                    ObjectDelta objDelta = new ObjectDelta(AccountShadowType.class, ChangeType.DELETE);
                    change.setObjectDelta((ObjectDelta<? extends ResourceObjectShadowType>)objDelta);
                }
                change.getObjectDelta().setOid(newShadow.getOid());
            }
        }
        catch (SchemaException ex) {
            parentResult.recordFatalError("Schema error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (CommunicationException ex) {
            parentResult.recordFatalError("Communication error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (GenericFrameworkException ex) {
            parentResult.recordFatalError("Generic error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (ConfigurationException ex) {
            parentResult.recordFatalError("Configuration error: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        parentResult.recordSuccess();
        return changes;
    }

    private void addExecuteScriptOperation(Set<Operation> operations, OperationTypeType type, ScriptsType scripts, OperationResult result) throws SchemaException {
        if (scripts == null) {
            LOGGER.trace("Skiping creating script operation to execute. Scripts was not defined.");
            return;
        }
        for (ScriptType script : scripts.getScript()) {
            for (OperationTypeType operationType : script.getOperation()) {
                if (!type.equals((Object)operationType)) continue;
                ExecuteScriptOperation scriptOperation = new ExecuteScriptOperation();
                for (ScriptArgumentType argument : script.getArgument()) {
                    ExecuteScriptArgument arg = new ExecuteScriptArgument(argument.getName(), ValueConstruction.getStaticValueList((ValueConstructionType)argument));
                    scriptOperation.getArgument().add(arg);
                }
                scriptOperation.setLanguage(script.getLanguage());
                scriptOperation.setTextCode(script.getCode());
                scriptOperation.setScriptOrder(script.getOrder());
                if (script.getHost().equals((Object)ScriptHostType.CONNECTOR)) {
                    scriptOperation.setConnectorHost(true);
                    scriptOperation.setResourceHost(false);
                }
                if (script.getHost().equals((Object)ScriptHostType.RESOURCE)) {
                    scriptOperation.setConnectorHost(false);
                    scriptOperation.setResourceHost(true);
                }
                LOGGER.trace("Created script operation: {}", (Object)SchemaDebugUtil.prettyPrint((Object)scriptOperation));
                operations.add(scriptOperation);
            }
        }
    }

    private ResourceObjectShadowType findOrCreateShadowFromChange(ResourceType resource, Change change, OperationResult parentResult) throws SchemaException, ObjectNotFoundException, CommunicationException, GenericFrameworkException, ConfigurationException, SecurityViolationException {
        List<PrismObject<AccountShadowType>> accountList = this.searchAccountByIdenifiers(change, parentResult);
        if (accountList.size() > 1) {
            String message = "Found more than one account with the identifier " + change.getIdentifiers() + ".";
            LOGGER.error(message);
            parentResult.recordFatalError(message);
            throw new IllegalArgumentException(message);
        }
        ResourceObjectShadowType newShadow = null;
        if (accountList.isEmpty()) {
            if (change.getObjectDelta() == null || change.getObjectDelta().getChangeType() != ChangeType.DELETE) {
                newShadow = this.shadowConverter.createNewAccountFromChange(change, resource, parentResult);
                try {
                    this.addOrReplaceShadowToRepository(newShadow, false, false, parentResult);
                }
                catch (ObjectAlreadyExistsException e) {
                    parentResult.recordFatalError("Can't add account " + SchemaDebugUtil.prettyPrint((ObjectType)newShadow) + " to the repository. Reason: " + e.getMessage(), (Throwable)e);
                    throw new IllegalStateException(e.getMessage(), e);
                }
                LOGGER.trace("Created account shadow object: {}", (Object)ObjectTypeUtil.toShortString((ObjectType)newShadow));
            }
        } else {
            newShadow = (ResourceObjectShadowType)accountList.get(0).asObjectable();
        }
        return newShadow;
    }

    private List<PrismObject<AccountShadowType>> searchAccountByIdenifiers(Change change, OperationResult parentResult) throws SchemaException {
        QueryType query = ShadowCacheUtil.createSearchShadowQuery(change.getIdentifiers(), this.prismContext, parentResult);
        List accountList = null;
        try {
            accountList = this.getRepositoryService().searchObjects(AccountShadowType.class, query, new PagingType(), parentResult);
        }
        catch (SchemaException ex) {
            parentResult.recordFatalError("Failed to search account according to the identifiers: " + change.getIdentifiers() + ". Reason: " + ex.getMessage(), (Throwable)ex);
            throw new SchemaException("Failed to search account according to the identifiers: " + change.getIdentifiers() + ". Reason: " + ex.getMessage(), (Throwable)ex);
        }
        return accountList;
    }

    private ResourceType getResource(String oid, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException {
        if (StringUtils.isEmpty((String)oid)) {
            throw new IllegalArgumentException("Cannot get resource with an empty OID");
        }
        PrismObject resource = this.getRepositoryService().getObject(ResourceType.class, oid, parentResult);
        return this.shadowConverter.completeResource((ResourceType)resource.asObjectable(), parentResult);
    }

    private void addOrReplaceShadowToRepository(ResourceObjectShadowType shadow, boolean isReconciled, boolean error, OperationResult parentResult) throws SchemaException, ObjectAlreadyExistsException, ObjectNotFoundException {
        if (isReconciled && !error) {
            PrismObject oldShadow = shadow.asPrismObject().clone();
            ResourceObjectShadowUtil.getAttributesContainer((PrismObject)oldShadow).clear();
            ShadowCacheUtil.normalizeShadow(shadow, parentResult);
            ObjectDelta delta = oldShadow.diff(shadow.asPrismObject());
            LOGGER.trace("normalizing shadow: change description: {}", (Object)delta.dump());
            this.prismContext.adopt((Objectable)shadow);
            this.repositoryService.modifyObject(AccountShadowType.class, shadow.getOid(), delta.getModifications(), parentResult);
        } else if (!isReconciled) {
            String oid = null;
            try {
                oid = this.getRepositoryService().addObject(shadow.asPrismObject(), parentResult);
            }
            catch (ObjectAlreadyExistsException ex) {
                parentResult.recordFatalError("Can't add shadow object to the repository. Shadow object already exist. Reason: " + ex.getMessage(), (Throwable)ex);
                throw new ObjectAlreadyExistsException("Can't add shadow object to the repository. Shadow object already exist. Reason: " + ex.getMessage(), (Throwable)ex);
            }
            shadow.setOid(oid);
        }
    }
}

