/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.impl;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.provisioning.api.ChangeNotificationDispatcher;
import com.evolveum.midpoint.provisioning.api.GenericConnectorException;
import com.evolveum.midpoint.provisioning.api.ProvisioningService;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.provisioning.api.ResultHandler;
import com.evolveum.midpoint.provisioning.impl.ConnectorTypeManager;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure1;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure11;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure13;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure15;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure17;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure19;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure21;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure23;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure25;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure3;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure5;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure7;
import com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl$AjcClosure9;
import com.evolveum.midpoint.provisioning.impl.ResourceTypeManager;
import com.evolveum.midpoint.provisioning.impl.ShadowCache;
import com.evolveum.midpoint.provisioning.impl.ShadowHandler;
import com.evolveum.midpoint.provisioning.ucf.api.Change;
import com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException;
import com.evolveum.midpoint.provisioning.util.ShadowCacheUtil;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.SchemaConstantsGenerated;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.processor.ObjectClassComplexTypeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceAttribute;
import com.evolveum.midpoint.schema.processor.ResourceAttributeDefinition;
import com.evolveum.midpoint.schema.processor.ResourceSchema;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.SchemaDebugUtil;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Holder;
import com.evolveum.midpoint.util.QNameUtil;
import com.evolveum.midpoint.util.aspect.MidpointAspect;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorHostType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.FailedOperationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.OperationResultType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptsType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Service(value="provisioningService")
public class ProvisioningServiceImpl
implements ProvisioningService {
    @Autowired(required=true)
    private ShadowCache shadowCache;
    @Autowired(required=true)
    private ResourceTypeManager resourceTypeManager;
    @Autowired(required=true)
    @Qualifier(value="cacheRepositoryService")
    private RepositoryService cacheRepositoryService;
    @Autowired(required=true)
    private ChangeNotificationDispatcher changeNotificationDispatcher;
    @Autowired(required=true)
    private ConnectorTypeManager connectorTypeManager;
    @Autowired(required=true)
    private PrismContext prismContext;
    private PrismObjectDefinition<ResourceObjectShadowType> resourceObjectShadowDefinition = null;
    private static final Trace LOGGER;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_8;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_9;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_10;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_11;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_12;

    static {
        ProvisioningServiceImpl.ajc$preClinit();
        LOGGER = TraceManager.getTrace(ProvisioningServiceImpl.class);
    }

    public ShadowCache getShadowCache() {
        return this.shadowCache;
    }

    public void setShadowCache(ShadowCache shadowCache) {
        this.shadowCache = shadowCache;
    }

    public ResourceTypeManager getResourceTypeManager() {
        return this.resourceTypeManager;
    }

    public void setResourceTypeManager(ResourceTypeManager resourceTypeManager) {
        this.resourceTypeManager = resourceTypeManager;
    }

    public RepositoryService getCacheRepositoryService() {
        return this.cacheRepositoryService;
    }

    public void setCacheRepositoryService(RepositoryService repositoryService) {
        this.cacheRepositoryService = repositoryService;
    }

    public <T extends ObjectType> PrismObject<T> getObject(Class<T> type, String oid, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException, SecurityViolationException {
        Class<T> clazz = type;
        String string = oid;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, string, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, string, operationResult, joinPoint};
        return (PrismObject)MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private void logFatalError(Trace logger, OperationResult opResult, String message, Exception ex) {
        logger.error(message, (Throwable)ex);
        opResult.recordFatalError(message, (Throwable)ex);
    }

    private void logWarning(Trace logger, OperationResult opResult, String message, Exception ex) {
        logger.error(message, (Throwable)ex);
        opResult.recordWarning(message, (Throwable)ex);
    }

    public <T extends ObjectType> String addObject(PrismObject<T> object, ScriptsType scripts, OperationResult parentResult) throws ObjectAlreadyExistsException, SchemaException, CommunicationException, ObjectNotFoundException, ConfigurationException, SecurityViolationException {
        PrismObject<T> prismObject = object;
        ScriptsType scriptsType = scripts;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{prismObject, scriptsType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, prismObject, scriptsType, operationResult, joinPoint};
        return (String)MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure3(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public int synchronize(String resourceOid, Task task, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException, SecurityViolationException {
        String string = resourceOid;
        Task task2 = task;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{string, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, task2, operationResult, joinPoint};
        return Conversions.intValue((Object)MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure5(objectArray2).linkClosureAndJoinPoint(69648)));
    }

    public <T extends ObjectType> List<PrismObject<T>> listObjects(Class<T> objectType, PagingType paging, OperationResult parentResult) {
        Class<T> clazz = objectType;
        PagingType pagingType = paging;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, pagingType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, pagingType, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure7(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public <T extends ObjectType> List<PrismObject<T>> searchObjects(Class<T> type, QueryType query, PagingType paging, OperationResult parentResult) throws SchemaException, ObjectNotFoundException, CommunicationException, ConfigurationException, SecurityViolationException {
        Class<T> clazz = type;
        QueryType queryType = query;
        PagingType pagingType = paging;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, queryType, pagingType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, queryType, pagingType, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure9(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private <T extends ObjectType> List<PrismObject<T>> searchRepoObjects(Class<T> type, QueryType query, PagingType paging, OperationResult result) throws SchemaException {
        List objListType = null;
        objListType = this.getCacheRepositoryService().searchObjects(type, query, paging, result);
        if (ResourceType.class.equals(type)) {
            ArrayList<PrismObject<T>> newObjListType = new ArrayList<PrismObject<T>>();
            for (PrismObject obj : objListType) {
                OperationResult objResult = new OperationResult(String.valueOf(ProvisioningService.class.getName()) + ".searchObjects.object");
                PrismObject resource = obj;
                try {
                    ResourceType completeResource = this.getResourceTypeManager().completeResource((ResourceType)resource.asObjectable(), null, objResult);
                    newObjListType.add(completeResource.asPrismObject());
                }
                catch (ObjectNotFoundException e) {
                    LOGGER.error("Error while completing {}: {}. Using non-complete resource.", new Object[]{resource, e.getMessage(), e});
                    objResult.recordFatalError((Throwable)e);
                    ((ObjectType)obj.asObjectable()).setFetchResult(objResult.createOperationResultType());
                    newObjListType.add(obj);
                    result.addSubresult(objResult);
                    result.recordPartialError((Throwable)e);
                }
                catch (SchemaException e) {
                    LOGGER.error("Error while completing {}: {}. Using non-complete resource.", new Object[]{resource, e.getMessage(), e});
                    objResult.recordFatalError((Throwable)e);
                    ((ObjectType)obj.asObjectable()).setFetchResult(objResult.createOperationResultType());
                    newObjListType.add(obj);
                    result.addSubresult(objResult);
                    result.recordPartialError((Throwable)e);
                }
                catch (CommunicationException e) {
                    LOGGER.error("Error while completing {}: {}. Using non-complete resource.", new Object[]{resource, e.getMessage(), e});
                    objResult.recordFatalError((Throwable)e);
                    ((ObjectType)obj.asObjectable()).setFetchResult(objResult.createOperationResultType());
                    newObjListType.add(obj);
                    result.addSubresult(objResult);
                    result.recordPartialError((Throwable)e);
                }
                catch (ConfigurationException e) {
                    LOGGER.error("Error while completing {}: {}. Using non-complete resource.", new Object[]{resource, e.getMessage(), e});
                    objResult.recordFatalError((Throwable)e);
                    ((ObjectType)obj.asObjectable()).setFetchResult(objResult.createOperationResultType());
                    newObjListType.add(obj);
                    result.addSubresult(objResult);
                    result.recordPartialError((Throwable)e);
                }
                catch (RuntimeException e) {
                    LOGGER.error("System error while completing {}: {}. Using non-complete resource.", new Object[]{resource, e.getMessage(), e});
                    objResult.recordFatalError((Throwable)e);
                    ((ObjectType)obj.asObjectable()).setFetchResult(objResult.createOperationResultType());
                    newObjListType.add(obj);
                    result.addSubresult(objResult);
                    result.recordPartialError((Throwable)e);
                }
            }
            return newObjListType;
        }
        return objListType;
    }

    public <T extends ObjectType> int countObjects(Class<T> type, QueryType query, OperationResult parentResult) throws SchemaException, ObjectNotFoundException, CommunicationException, ConfigurationException, SecurityViolationException {
        Class<T> clazz = type;
        QueryType queryType = query;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, queryType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, queryType, operationResult, joinPoint};
        return Conversions.intValue((Object)MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure11(objectArray2).linkClosureAndJoinPoint(69648)));
    }

    public <T extends ObjectType> void modifyObject(Class<T> type, String oid, Collection<? extends ItemDelta> modifications, ScriptsType scripts, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException, SecurityViolationException {
        Class<T> clazz = type;
        String string = oid;
        Collection<? extends ItemDelta> collection = modifications;
        ScriptsType scriptsType = scripts;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, string, collection, scriptsType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, string, collection, scriptsType, operationResult, joinPoint};
        MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure13(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public <T extends ObjectType> void deleteObject(Class<T> type, String oid, ScriptsType scripts, OperationResult parentResult) throws ObjectNotFoundException, CommunicationException, SchemaException, ConfigurationException, SecurityViolationException {
        Class<T> clazz = type;
        String string = oid;
        ScriptsType scriptsType = scripts;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, string, scriptsType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, string, scriptsType, operationResult, joinPoint};
        MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure15(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public OperationResult testResource(String resourceOid) throws ObjectNotFoundException {
        String string = resourceOid;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_8, (Object)this, (Object)this, (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (OperationResult)MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure17(objectArray).linkClosureAndJoinPoint(69648));
    }

    public List<PrismObject<? extends ResourceObjectShadowType>> listResourceObjects(String resourceOid, QName objectClass, PagingType paging, OperationResult parentResult) throws SchemaException, ObjectNotFoundException, CommunicationException {
        String string = resourceOid;
        QName qName = objectClass;
        PagingType pagingType = paging;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{string, qName, pagingType, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_9, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, string, qName, pagingType, operationResult, joinPoint};
        return (List)MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure19(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public <T extends ObjectType> void searchObjectsIterative(Class<T> type, QueryType query, PagingType paging, ResultHandler<T> handler, OperationResult parentResult) throws SchemaException, ObjectNotFoundException, CommunicationException, ConfigurationException, SecurityViolationException {
        Class<T> clazz = type;
        QueryType queryType = query;
        PagingType pagingType = paging;
        ResultHandler<T> resultHandler = handler;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{clazz, queryType, pagingType, resultHandler, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_10, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, clazz, queryType, pagingType, resultHandler, operationResult, joinPoint};
        MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure21(objectArray2).linkClosureAndJoinPoint(69648));
    }

    private synchronized void notifyResourceObjectChangeListeners(ResourceObjectShadowChangeDescription change, Task task, OperationResult parentResult) {
        this.changeNotificationDispatcher.notifyChange(change, task, parentResult);
    }

    private ResourceObjectShadowChangeDescription createResourceShadowChangeDescription(Change change, ResourceType resourceType) {
        ResourceObjectShadowChangeDescription shadowChangeDescription = new ResourceObjectShadowChangeDescription();
        shadowChangeDescription.setObjectDelta(change.getObjectDelta());
        shadowChangeDescription.setResource(resourceType.asPrismObject());
        shadowChangeDescription.setOldShadow(change.getOldShadow());
        if (change.getCurrentShadow() != null) {
            ResourceObjectShadowType currentShadowType = (ResourceObjectShadowType)change.getCurrentShadow().asObjectable();
            currentShadowType.setActivation(ShadowCacheUtil.completeActivation(currentShadowType, resourceType, null));
        }
        shadowChangeDescription.setCurrentShadow(change.getCurrentShadow());
        shadowChangeDescription.setSourceChannel(QNameUtil.qNameToUri((QName)SchemaConstants.CHANGE_CHANNEL_SYNC));
        return shadowChangeDescription;
    }

    private PropertyDelta getTokenModification(PrismProperty token) {
        if (token == null) {
            throw new IllegalArgumentException("Cannot create modification from a null live sync token");
        }
        if (token.getDefinition() == null) {
            throw new IllegalArgumentException("Live sync token " + token + " has no definition. Cannot create modification.");
        }
        PropertyDelta tokenDelta = new PropertyDelta(new PropertyPath(new QName[]{ResourceObjectShadowType.F_EXTENSION, token.getName()}), token.getDefinition());
        tokenDelta.setValuesToReplace((Collection)token.getValues());
        return tokenDelta;
    }

    public Set<ConnectorType> discoverConnectors(ConnectorHostType hostType, OperationResult parentResult) throws CommunicationException {
        ConnectorHostType connectorHostType = hostType;
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_11, (Object)this, (Object)this, (Object)connectorHostType, (Object)operationResult);
        Object[] objectArray = new Object[]{this, connectorHostType, operationResult, joinPoint};
        return (Set)MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure23(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void postInit(OperationResult parentResult) {
        OperationResult operationResult = parentResult;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_12, (Object)this, (Object)this, (Object)operationResult);
        Object[] objectArray = new Object[]{this, operationResult, joinPoint};
        MidpointAspect.aspectOf().processProvisioningNdc(new ProvisioningServiceImpl$AjcClosure25(objectArray).linkClosureAndJoinPoint(69648));
    }

    private ObjectDelta<? extends ResourceObjectShadowType> createShadowResultModification(ResourceObjectShadowChangeDescription shadowChangeDescription, Change change, OperationResult shadowResult) {
        String shadowOid = null;
        if (change.getObjectDelta() != null && change.getObjectDelta().getOid() != null) {
            shadowOid = change.getObjectDelta().getOid();
        } else if (change.getCurrentShadow().getOid() != null) {
            shadowOid = change.getCurrentShadow().getOid();
        } else if (change.getOldShadow().getOid() != null) {
            shadowOid = change.getOldShadow().getOid();
        } else {
            throw new IllegalArgumentException("No uid value defined for the object to synchronize.");
        }
        PrismObjectDefinition<ResourceObjectShadowType> shadowDefinition = ShadowCacheUtil.getResourceObjectShadowDefinition(this.prismContext);
        ObjectDelta shadowModification = ObjectDelta.createModificationReplaceProperty(ResourceObjectShadowType.class, (String)shadowOid, (QName)SchemaConstants.C_RESULT, (PrismContext)this.prismContext, (Object[])new OperationResultType[]{shadowResult.createOperationResultType()});
        if (change.getObjectDelta() != null && change.getObjectDelta().getChangeType() == ChangeType.DELETE) {
            PrismPropertyDefinition failedOperationTypePropDef = shadowDefinition.findPropertyDefinition(ResourceObjectShadowType.F_FAILED_OPERATION_TYPE);
            PropertyDelta failedOperationTypeDelta = new PropertyDelta(ResourceObjectShadowType.F_FAILED_OPERATION_TYPE, failedOperationTypePropDef);
            failedOperationTypeDelta.setValueToReplace((PrismValue)new PrismPropertyValue((Object)FailedOperationTypeType.DELETE));
            shadowModification.addModification((ItemDelta)failedOperationTypeDelta);
        }
        return shadowModification;
    }

    private void saveAccountResult(ResourceObjectShadowChangeDescription shadowChangeDescription, Change change, OperationResult notifyChangeResult, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        ObjectDelta<? extends ResourceObjectShadowType> shadowModification = this.createShadowResultModification(shadowChangeDescription, change, notifyChangeResult);
        this.cacheRepositoryService.modifyObject(ResourceObjectShadowType.class, shadowModification.getOid(), shadowModification.getModifications(), parentResult);
    }

    private void deleteShadowFromRepo(Change change, OperationResult parentResult) throws ObjectNotFoundException {
        if (change.getObjectDelta() != null && change.getObjectDelta().getChangeType() == ChangeType.DELETE && change.getOldShadow() != null) {
            LOGGER.debug("Deleting detected shadow object form repository.");
            try {
                this.cacheRepositoryService.deleteObject(AccountShadowType.class, change.getOldShadow().getOid(), parentResult);
            }
            catch (ObjectNotFoundException objectNotFoundException) {
                parentResult.recordFatalError("Can't find object " + change.getOldShadow() + " in repository.");
                throw new ObjectNotFoundException("Can't find object " + change.getOldShadow() + " in repository.");
            }
            LOGGER.debug("Shadow object deleted successfully form repository.");
        }
    }

    private PrismObjectDefinition<ResourceObjectShadowType> getResourceObjectShadowDefinition() {
        if (this.resourceObjectShadowDefinition == null) {
            this.resourceObjectShadowDefinition = this.prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(ResourceObjectShadowType.class);
        }
        return this.resourceObjectShadowDefinition;
    }

    static final /* synthetic */ PrismObject getObject_aroundBody0(ProvisioningServiceImpl ajc$this, Class type, String oid, OperationResult parentResult, JoinPoint joinPoint) {
        Validate.notNull((Object)oid, (String)"Oid of object to get must not be null.");
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".getObject");
        result.addParam("oid", (Object)oid);
        result.addParam("type", (Object)type);
        result.addContext("implementationClass", ProvisioningServiceImpl.class);
        PrismObject repositoryObject = null;
        try {
            repositoryObject = ajc$this.getCacheRepositoryService().getObject(type, oid, result);
        }
        catch (ObjectNotFoundException e) {
            ajc$this.logFatalError(LOGGER, result, "Can't get obejct with oid " + oid + ". Reason " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (SchemaException ex) {
            ajc$this.logFatalError(LOGGER, result, "Can't get obejct with oid " + oid + ". Reason " + ex.getMessage(), (Exception)((Object)ex));
            throw ex;
        }
        if (repositoryObject.canRepresent(ResourceObjectShadowType.class)) {
            ResourceObjectShadowType shadow = null;
            try {
                shadow = ajc$this.getShadowCache().getShadow(type, oid, (ResourceObjectShadowType)repositoryObject.asObjectable(), result);
            }
            catch (ObjectNotFoundException e) {
                ajc$this.logFatalError(LOGGER, result, "Can't get obejct with oid " + oid + ". Reason " + e.getMessage(), (Exception)((Object)e));
                throw e;
            }
            catch (CommunicationException e) {
                ajc$this.logFatalError(LOGGER, result, "Can't get obejct with oid " + oid + ". Reason " + e.getMessage(), (Exception)((Object)e));
                throw e;
            }
            catch (SchemaException e) {
                ajc$this.logFatalError(LOGGER, result, "Can't get obejct with oid " + oid + ". Reason " + e.getMessage(), (Exception)((Object)e));
                throw e;
            }
            catch (ConfigurationException e) {
                ajc$this.logFatalError(LOGGER, result, "Can't get obejct with oid " + oid + ". Reason " + e.getMessage(), (Exception)((Object)e));
                throw e;
            }
            result.recordSuccess();
            return shadow.asPrismObject();
        }
        if (repositoryObject.canRepresent(ResourceType.class)) {
            try {
                ResourceType completeResource = ajc$this.getResourceTypeManager().completeResource((ResourceType)repositoryObject.asObjectable(), null, result);
                result.recordSuccess();
                return completeResource.asPrismObject();
            }
            catch (ObjectNotFoundException ex) {
                ajc$this.logFatalError(LOGGER, result, "Resource object not found", (Exception)((Object)ex));
                throw ex;
            }
            catch (SchemaException ex) {
                ajc$this.logFatalError(LOGGER, result, "Schema violation", (Exception)((Object)ex));
                throw ex;
            }
            catch (CommunicationException ex) {
                ajc$this.logFatalError(LOGGER, result, "Error communicating with resource", (Exception)((Object)ex));
                throw ex;
            }
        }
        result.recordSuccess();
        return repositoryObject;
    }

    static final /* synthetic */ String addObject_aroundBody2(ProvisioningServiceImpl ajc$this, PrismObject object, ScriptsType scripts, OperationResult parentResult, JoinPoint joinPoint) {
        Validate.notNull((Object)object, (String)"Object to add must not be null.");
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        LOGGER.trace("**PROVISIONING: Start to add object {}", (Object)object);
        Object isReconciled = parentResult.getParams().get("reconciled");
        boolean reconciled = isReconciled != null;
        OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".addObject");
        result.addParam("object", (Object)object);
        result.addParam("scripts", (Object)scripts);
        result.addContext("implementationClass", ProvisioningServiceImpl.class);
        String oid = null;
        if (object.canRepresent(ResourceObjectShadowType.class)) {
            try {
                oid = ajc$this.getShadowCache().addShadow((ResourceObjectShadowType)object.asObjectable(), reconciled, scripts, null, result);
                LOGGER.trace("**PROVISIONING: Added shadow object {}", (Object)oid);
                result.recordSuccess();
            }
            catch (GenericFrameworkException ex) {
                ajc$this.logFatalError(LOGGER, result, "Couldn't add object " + object + ". Reason: " + ex.getMessage(), ex);
                throw new CommunicationException(ex.getMessage(), (Throwable)ex);
            }
            catch (SchemaException ex) {
                ajc$this.logFatalError(LOGGER, result, "Couldn't add object. Reason: " + ex.getMessage(), (Exception)((Object)ex));
                throw new SchemaException("Couldn't add object. Reason: " + ex.getMessage(), (Throwable)ex);
            }
            catch (ObjectAlreadyExistsException ex) {
                ajc$this.logFatalError(LOGGER, result, "Couldn't add object. Object already exist, " + ex.getMessage(), (Exception)((Object)ex));
                throw new ObjectAlreadyExistsException("Could't add object. Object already exist, " + ex.getMessage(), (Throwable)ex);
            }
            catch (ConfigurationException ex) {
                ajc$this.logFatalError(LOGGER, result, "Couldn't add object. Configuration error, " + ex.getMessage(), (Exception)((Object)ex));
                throw ex;
            }
            catch (SecurityViolationException ex) {
                ajc$this.logFatalError(LOGGER, result, "Couldn't add object. Security violation: " + ex.getMessage(), (Exception)((Object)ex));
                throw ex;
            }
        } else {
            oid = ajc$this.cacheRepositoryService.addObject(object, result);
        }
        LOGGER.trace("**PROVISIONING: Adding object finished.");
        return oid;
    }

    static final /* synthetic */ int synchronize_aroundBody4(ProvisioningServiceImpl ajc$this, String resourceOid, Task task, OperationResult parentResult, JoinPoint joinPoint) {
        Validate.notNull((Object)resourceOid, (String)"Resource oid must not be null.");
        Validate.notNull((Object)task, (String)"Task must not be null.");
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".synchronize");
        result.addParam("oid", (Object)resourceOid);
        result.addParam("task", (Object)task);
        int processedChanges = 0;
        try {
            PrismObject<ResourceType> resourceObject = ajc$this.getObject(ResourceType.class, resourceOid, result);
            ResourceType resourceType = (ResourceType)resourceObject.asObjectable();
            LOGGER.trace("**PROVISIONING: Start synchronization of resource {} ", (Object)SchemaDebugUtil.prettyPrint((ObjectType)resourceType));
            PrismProperty tokenProperty = null;
            if (task.getExtension() != null) {
                tokenProperty = task.getExtension(SchemaConstants.SYNC_TOKEN);
            }
            if (tokenProperty != null && (tokenProperty.getValue() == null || tokenProperty.getValue().getValue() == null)) {
                LOGGER.warn("Sync token exists, but it is empty (null value). Ignoring it.");
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Empty sync token property:\n{}", (Object)tokenProperty.dump());
                }
                tokenProperty = null;
            }
            if (tokenProperty == null && ((tokenProperty = ajc$this.getShadowCache().fetchCurrentToken(resourceType, parentResult)) == null || tokenProperty.getValue() == null || tokenProperty.getValue().getValue() == null)) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Empty current sync token property:\n{}", (Object)tokenProperty.dump());
                }
                throw new IllegalStateException("Current sync token null or empty: " + tokenProperty);
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("**PROVISIONING: Got token property: {} from the task extension.", (Object)SchemaDebugUtil.prettyPrint((Object)tokenProperty));
            }
            List<Change> changes = null;
            LOGGER.trace("Calling shadow cache to fetch changes.");
            changes = ajc$this.getShadowCache().fetchChanges(resourceType, tokenProperty, result);
            LOGGER.trace("Changes returned to ProvisioningServiceImpl:\n{}", changes);
            for (Change change : changes) {
                if (change.getOldShadow() == null) {
                    PrismProperty newToken = change.getToken();
                    task.setExtensionProperty(newToken);
                    ++processedChanges;
                    LOGGER.debug("Skipping processing change. Can't find appropriate shadow (e.g. the object was deleted on the resource meantime).");
                    continue;
                }
                ResourceObjectShadowChangeDescription shadowChangeDescription = ajc$this.createResourceShadowChangeDescription(change, resourceType);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("**PROVISIONING: Created resource object shadow change description {}", (Object)SchemaDebugUtil.prettyPrint((Object)shadowChangeDescription));
                }
                OperationResult notifyChangeResult = new OperationResult(String.valueOf(ProvisioningService.class.getName()) + "notifyChange");
                notifyChangeResult.addParam("resourceObjectShadowChangeDescription", (Object)shadowChangeDescription);
                try {
                    ajc$this.notifyResourceObjectChangeListeners(shadowChangeDescription, task, notifyChangeResult);
                    notifyChangeResult.recordSuccess();
                }
                catch (RuntimeException ex) {
                    ajc$this.logFatalError(LOGGER, notifyChangeResult, "Synchronization error: " + ex.getMessage(), ex);
                    ajc$this.saveAccountResult(shadowChangeDescription, change, notifyChangeResult, parentResult);
                    throw new SystemException("Synchronization error: " + ex.getMessage(), (Throwable)ex);
                }
                notifyChangeResult.computeStatus("Error by notify change operation.");
                if (notifyChangeResult.isSuccess()) {
                    ajc$this.deleteShadowFromRepo(change, parentResult);
                    PrismProperty newToken = change.getToken();
                    task.setExtensionProperty(newToken);
                    ++processedChanges;
                    continue;
                }
                ajc$this.saveAccountResult(shadowChangeDescription, change, notifyChangeResult, parentResult);
            }
            if (changes.isEmpty()) {
                LOGGER.trace("No changes to synchronize on " + ObjectTypeUtil.toShortString((ObjectType)resourceType));
                task.setExtensionProperty(tokenProperty);
            }
            task.savePendingModifications(result);
        }
        catch (ObjectNotFoundException e) {
            ajc$this.logFatalError(LOGGER, result, "Synchronization error: object not found: " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (CommunicationException e) {
            ajc$this.logFatalError(LOGGER, result, "Synchronization error: communication problem: " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (ObjectAlreadyExistsException e) {
            ajc$this.logFatalError(LOGGER, result, "Synchronization error: object already exists problem: " + e.getMessage(), (Exception)((Object)e));
            throw new SystemException((Throwable)e);
        }
        catch (GenericFrameworkException e) {
            ajc$this.logFatalError(LOGGER, result, "Synchronization error: generic connector framework error: " + e.getMessage(), e);
            throw new GenericConnectorException(e.getMessage(), (Throwable)e);
        }
        catch (SchemaException e) {
            ajc$this.logFatalError(LOGGER, result, "Synchronization error: schema problem: " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (SecurityViolationException e) {
            ajc$this.logFatalError(LOGGER, result, "Synchronization error: security violation: " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (ConfigurationException e) {
            ajc$this.logFatalError(LOGGER, result, "Synchronization error: configuration problem: " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (RuntimeException e) {
            ajc$this.logFatalError(LOGGER, result, "Synchronization error: unexpected problem: " + e.getMessage(), e);
            throw e;
        }
        result.recordSuccess();
        return processedChanges;
    }

    static final /* synthetic */ List listObjects_aroundBody6(ProvisioningServiceImpl ajc$this, Class objectType, PagingType paging, OperationResult parentResult, JoinPoint joinPoint) {
        try {
            return ajc$this.searchObjects(objectType, null, paging, parentResult);
        }
        catch (Exception e) {
            throw new SystemException(e.getMessage(), (Throwable)e);
        }
    }

    static final /* synthetic */ List searchObjects_aroundBody8(ProvisioningServiceImpl ajc$this, Class type, QueryType query, PagingType paging, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".searchObjects");
        result.addParam("objectType", (Object)type);
        result.addParam("paging", (Object)paging);
        result.addParam("query", (Object)query);
        result.addContext("implementationClass", ProvisioningServiceImpl.class);
        if (!ResourceObjectShadowType.class.isAssignableFrom(type)) {
            List objects = ajc$this.searchRepoObjects(type, query, paging, result);
            result.computeStatus();
            result.recordSuccessIfUnknown();
            return objects;
        }
        final ArrayList objListType = new ArrayList();
        ResultHandler handler = new ResultHandler<T>(){

            public boolean handle(PrismObject<T> object, OperationResult parentResult) {
                return objListType.add(object);
            }
        };
        ajc$this.searchObjectsIterative(type, query, paging, handler, result);
        result.computeStatus();
        return objListType;
    }

    static final /* synthetic */ int countObjects_aroundBody10(ProvisioningServiceImpl ajc$this, Class type, QueryType query, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".countObjects");
        result.addParam("objectType", (Object)type);
        result.addParam("query", (Object)query);
        result.addContext("implementationClass", ProvisioningServiceImpl.class);
        if (!ResourceObjectShadowType.class.isAssignableFrom(type)) {
            int count = ajc$this.getCacheRepositoryService().countObjects(type, query, parentResult);
            result.computeStatus();
            result.recordSuccessIfUnknown();
            return count;
        }
        final Holder countHolder = new Holder((Object)0);
        ResultHandler handler = new ResultHandler<T>(){

            public boolean handle(PrismObject<T> object, OperationResult parentResult) {
                int count = (Integer)countHolder.getValue();
                countHolder.setValue((Object)(++count));
                return true;
            }
        };
        ajc$this.searchObjectsIterative(type, query, null, handler, result);
        result.computeStatus();
        return (Integer)countHolder.getValue();
    }

    static final /* synthetic */ void modifyObject_aroundBody12(ProvisioningServiceImpl ajc$this, Class type, String oid, Collection modifications, ScriptsType scripts, OperationResult parentResult, JoinPoint joinPoint) {
        Validate.notNull((Object)oid, (String)"OID must not be null.");
        Validate.notNull((Object)modifications, (String)"Modifications must not be null.");
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        Object isReconciled = parentResult.getParams().get("reconciled");
        boolean reconciled = isReconciled != null;
        OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".modifyObject");
        result.addParam("modifications", (Object)modifications);
        result.addParam("oid", (Object)oid);
        result.addParam("scripts", (Object)scripts);
        result.addContext("implementationClass", ProvisioningServiceImpl.class);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("*PROVISIONING: modifyObject: object modifications:\n{}", (Object)DebugUtil.debugDump((Collection)modifications));
        }
        PrismObject object = ajc$this.getCacheRepositoryService().getObject(type, oid, parentResult);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("**PROVISIONING: modifyObject: object to modify:\n{}.", (Object)object.dump());
        }
        try {
            ajc$this.getShadowCache().modifyShadow((ObjectType)object.asObjectable(), null, oid, modifications, reconciled, scripts, parentResult);
            result.recordSuccess();
        }
        catch (CommunicationException e) {
            ajc$this.logFatalError(LOGGER, result, "Couldn't modify object: communication problem: " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (GenericFrameworkException e) {
            ajc$this.logFatalError(LOGGER, result, "Couldn't modify object: generic error in the connector: " + e.getMessage(), e);
            throw new CommunicationException(e.getMessage(), (Throwable)e);
        }
        catch (SchemaException e) {
            ajc$this.logFatalError(LOGGER, result, "Couldn't modify object: schema problem: " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (ObjectNotFoundException e) {
            ajc$this.logFatalError(LOGGER, result, "Couldn't modify object: object doesn't exist: " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (RuntimeException e) {
            ajc$this.logFatalError(LOGGER, result, "Couldn't modify object: unexpected problem: " + e.getMessage(), e);
            throw new SystemException("Internal error: " + e.getMessage(), (Throwable)e);
        }
        catch (ConfigurationException e) {
            ajc$this.logFatalError(LOGGER, result, "Couldn't modify object: configuration problem: " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        catch (SecurityViolationException e) {
            ajc$this.logFatalError(LOGGER, result, "Couldn't modify object: security violation: " + e.getMessage(), (Exception)((Object)e));
            throw e;
        }
        LOGGER.trace("Finished modifying of object with oid {}", (Object)oid);
    }

    static final /* synthetic */ void deleteObject_aroundBody14(ProvisioningServiceImpl ajc$this, Class type, String oid, ScriptsType scripts, OperationResult parentResult, JoinPoint joinPoint) {
        Validate.notNull((Object)oid, (String)"Oid of object to delete must not be null.");
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        LOGGER.trace("**PROVISIONING: Start to delete object with oid {}", (Object)oid);
        OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".deleteObject");
        result.addParam("oid", (Object)oid);
        result.addParam("scripts", (Object)scripts);
        result.addContext("implementationClass", ProvisioningServiceImpl.class);
        PrismObject object = null;
        try {
            object = ajc$this.getCacheRepositoryService().getObject(type, oid, parentResult);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("**PROVISIONING: Object from repository to delete:\n{}", (Object)object.dump());
            }
        }
        catch (SchemaException e) {
            result.recordFatalError("Can't get object with oid " + oid + " from repository. Reason:  " + e.getMessage() + " " + (Object)((Object)e));
            throw new ObjectNotFoundException(e.getMessage());
        }
        if (object.canRepresent(ResourceObjectShadowType.class)) {
            try {
                ajc$this.getShadowCache().deleteShadow((ObjectType)object.asObjectable(), scripts, null, result);
                result.recordSuccess();
            }
            catch (CommunicationException e) {
                ajc$this.logFatalError(LOGGER, result, "Couldn't delete object: communication problem: " + e.getMessage(), (Exception)((Object)e));
                throw new CommunicationException(e.getMessage(), (Throwable)e);
            }
            catch (GenericFrameworkException e) {
                ajc$this.logFatalError(LOGGER, result, "Couldn't delete object: generic error in the connector: " + e.getMessage(), e);
                throw new CommunicationException(e.getMessage(), (Throwable)e);
            }
            catch (SchemaException e) {
                ajc$this.logFatalError(LOGGER, result, "Couldn't delete object: schema problem: " + e.getMessage(), (Exception)((Object)e));
                throw new SchemaException(e.getMessage(), (Throwable)e);
            }
            catch (ConfigurationException e) {
                ajc$this.logFatalError(LOGGER, result, "Couldn't delete object: configuration problem: " + e.getMessage(), (Exception)((Object)e));
                throw e;
            }
        }
        try {
            ajc$this.getCacheRepositoryService().deleteObject(type, oid, result);
        }
        catch (ObjectNotFoundException ex) {
            result.recordFatalError((Throwable)ex);
            throw ex;
        }
        LOGGER.trace("**PROVISIONING: Finished deleting object.");
        result.recordSuccess();
    }

    static final /* synthetic */ OperationResult testResource_aroundBody16(ProvisioningServiceImpl ajc$this, String resourceOid, JoinPoint joinPoint) {
        Validate.notNull((Object)resourceOid, (String)"Resource OID to test is null.");
        LOGGER.trace("Start testing resource with oid {} ", (Object)resourceOid);
        OperationResult parentResult = new OperationResult(ProvisioningService.TEST_CONNECTION_OPERATION);
        parentResult.addParam("resourceOid", (Object)resourceOid);
        parentResult.addContext("implementationClass", ProvisioningServiceImpl.class);
        ResourceType resourceType = null;
        try {
            PrismObject resource = ajc$this.getCacheRepositoryService().getObject(ResourceType.class, resourceOid, parentResult);
            resourceType = (ResourceType)resource.asObjectable();
            ajc$this.resourceTypeManager.testConnection(resourceType, parentResult);
        }
        catch (ObjectNotFoundException objectNotFoundException) {
            throw new ObjectNotFoundException("Object with OID " + resourceOid + " not found");
        }
        catch (SchemaException ex) {
            throw new IllegalArgumentException(ex.getMessage(), ex);
        }
        parentResult.computeStatus("Test resource has failed");
        LOGGER.trace("Finished testing {}, result: {} ", (Object)ObjectTypeUtil.toShortString((ObjectType)resourceType), (Object)parentResult.getStatus());
        return parentResult;
    }

    static final /* synthetic */ List listResourceObjects_aroundBody18(ProvisioningServiceImpl ajc$this, String resourceOid, QName objectClass, PagingType paging, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".listResourceObjects");
        result.addParam("resourceOid", (Object)resourceOid);
        result.addParam("objectClass", (Object)objectClass);
        result.addParam("paging", (Object)paging);
        result.addContext("implementationClass", ProvisioningServiceImpl.class);
        if (resourceOid == null) {
            throw new IllegalArgumentException("Resource not defined in a search query");
        }
        if (objectClass == null) {
            throw new IllegalArgumentException("Objectclass not defined in a search query");
        }
        PrismObject resource = null;
        try {
            resource = ajc$this.getCacheRepositoryService().getObject(ResourceType.class, resourceOid, result);
        }
        catch (ObjectNotFoundException e) {
            result.recordFatalError("Resource with oid " + resourceOid + "not found. Reason: " + (Object)((Object)e));
            throw new ObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        final ArrayList objectList = new ArrayList();
        ShadowHandler shadowHandler = new ShadowHandler(){

            public boolean handle(ResourceObjectShadowType shadow) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("listResourceObjects: processing shadow: {}", (Object)SchemaDebugUtil.prettyPrint((ObjectType)shadow));
                }
                objectList.add(shadow.asPrismObject());
                return true;
            }
        };
        try {
            ajc$this.resourceTypeManager.listShadows((ResourceType)resource.asObjectable(), objectClass, shadowHandler, false, result);
        }
        catch (ConfigurationException ex) {
            parentResult.recordFatalError(ex.getMessage(), (Throwable)ex);
            throw new CommunicationException("Error in the configuration: " + ex.getMessage(), (Throwable)ex);
        }
        return objectList;
    }

    static final /* synthetic */ void searchObjectsIterative_aroundBody20(ProvisioningServiceImpl ajc$this, Class type, QueryType query, PagingType paging, final ResultHandler handler, OperationResult parentResult, JoinPoint joinPoint) {
        Validate.notNull((Object)parentResult, (String)"Operation result must not be null.");
        Validate.notNull((Object)handler, (String)"Handler must not be null.");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Start to search object. Query {}", (Object)QueryUtil.dump((QueryType)query));
        }
        final OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".searchObjectsIterative");
        result.addParam("query", (Object)query);
        result.addParam("paging", (Object)paging);
        result.addContext("implementationClass", ProvisioningServiceImpl.class);
        Element filter = null;
        if (query != null) {
            filter = query.getFilter();
        }
        NodeList list = null;
        if (filter != null) {
            list = filter.getChildNodes();
        }
        String resourceOid = null;
        QName objectClass = null;
        ArrayList<NodeList> attributeFilter = new ArrayList<NodeList>();
        if (list != null && QNameUtil.compareQName((QName)SchemaConstantsGenerated.Q_AND, (Node)filter)) {
            int i = 0;
            while (i < list.getLength()) {
                if (QNameUtil.compareQName((QName)SchemaConstantsGenerated.Q_TYPE, (Node)list.item(i))) {
                    String filterType = list.item(i).getAttributes().getNamedItem("uri").getNodeValue();
                    if (filterType == null || "".equals(filterType)) {
                        result.recordFatalError("Object type is not defined.");
                        throw new IllegalArgumentException("Object type is not defined.");
                    }
                } else if (QNameUtil.compareQName((QName)SchemaConstantsGenerated.Q_EQUAL, (Node)list.item(i))) {
                    NodeList equealList = list.item(i).getChildNodes();
                    int j = 0;
                    while (j < equealList.getLength()) {
                        if (QNameUtil.compareQName((QName)SchemaConstantsGenerated.Q_VALUE, (Node)equealList.item(j))) {
                            Node value = equealList.item(j).getFirstChild();
                            if (QNameUtil.compareQName((QName)SchemaConstants.I_RESOURCE_REF, (Node)value)) {
                                resourceOid = value.getAttributes().getNamedItem("oid").getNodeValue();
                                LOGGER.trace("**PROVISIONING: Search objects on resource with oid {}", (Object)resourceOid);
                            } else if (QNameUtil.compareQName((QName)SchemaConstants.I_OBJECT_CLASS, (Node)value)) {
                                objectClass = DOMUtil.getQNameValue((Element)((Element)value));
                                LOGGER.trace("**PROVISIONING: Object class to search: {}", (Object)objectClass);
                                if (objectClass == null) {
                                    result.recordFatalError("Object class was not defined.");
                                    throw new IllegalArgumentException("Object class was not defined.");
                                }
                            }
                        } else if (QNameUtil.compareQName((QName)SchemaConstantsGenerated.Q_PATH, (Node)equealList.item(j))) {
                            attributeFilter.add(equealList);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (resourceOid == null) {
            throw new IllegalArgumentException("Resource not defined in a search query");
        }
        if (objectClass == null) {
            throw new IllegalArgumentException("Objectclass not defined in a search query");
        }
        PrismObject<ResourceType> resource = null;
        try {
            resource = ajc$this.getObject(ResourceType.class, resourceOid, result);
        }
        catch (ObjectNotFoundException e) {
            result.recordFatalError("Resource with oid " + resourceOid + "not found. Reason: " + (Object)((Object)e));
            throw new ObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (ConfigurationException e) {
            result.recordFatalError("Configuration error regarding resource with oid " + resourceOid + ". Reason: " + (Object)((Object)e));
            throw e;
        }
        catch (SecurityViolationException e) {
            result.recordFatalError("Security violation: " + (Object)((Object)e));
            throw e;
        }
        ArrayList<ResourceAttribute> resourceAttributesFilter = new ArrayList<ResourceAttribute>();
        if (!attributeFilter.isEmpty()) {
            ResourceSchema schema = RefinedResourceSchema.getResourceSchema(resource, (PrismContext)ajc$this.prismContext);
            ObjectClassComplexTypeDefinition objectClassDef = schema.findObjectClassDefinition(objectClass);
            for (NodeList attribute : attributeFilter) {
                int j = 0;
                while (j < attribute.getLength()) {
                    Node attrFilter = attribute.item(j);
                    if (!QNameUtil.compareQName((QName)SchemaConstantsGenerated.Q_PATH, (Node)attrFilter)) {
                        QName attrName = QNameUtil.getNodeQName((Node)attrFilter.getFirstChild());
                        ResourceAttributeDefinition resourceAttrDef = objectClassDef.findAttributeDefinition(attrName);
                        ResourceAttribute resourceAttr = resourceAttrDef.instantiate();
                        resourceAttr.setRealValue((Object)attrFilter.getFirstChild().getTextContent());
                        resourceAttributesFilter.add(resourceAttr);
                    }
                    ++j;
                }
            }
        }
        ShadowHandler shadowHandler = new ShadowHandler(){

            public boolean handle(ResourceObjectShadowType shadowType) {
                if (shadowType == null) {
                    throw new IllegalArgumentException("Null shadow in call to handler");
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("searchObjectsIterative: processing shadow: {}", (Object)SchemaDebugUtil.prettyPrint((ObjectType)shadowType));
                }
                OperationResult accountResult = result.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".searchObjectsIterative.handle");
                boolean doContinue = handler.handle(shadowType.asPrismObject(), accountResult);
                accountResult.computeStatus();
                if (!accountResult.isSuccess()) {
                    Collection shadowModificationType = PropertyDelta.createModificationReplacePropertyCollection((QName)ResourceObjectShadowType.F_RESULT, (PrismObjectDefinition)ProvisioningServiceImpl.this.getResourceObjectShadowDefinition(), (Object[])new Object[]{accountResult.createOperationResultType()});
                    try {
                        ProvisioningServiceImpl.this.cacheRepositoryService.modifyObject(AccountShadowType.class, shadowType.getOid(), shadowModificationType, result);
                    }
                    catch (ObjectNotFoundException ex) {
                        result.recordFatalError("Saving of result to " + ObjectTypeUtil.toShortString((ObjectType)shadowType) + " shadow failed: Not found: " + ex.getMessage(), (Throwable)ex);
                    }
                    catch (ObjectAlreadyExistsException ex) {
                        result.recordFatalError("Saving of result to " + ObjectTypeUtil.toShortString((ObjectType)shadowType) + " shadow failed: Already exists: " + ex.getMessage(), (Throwable)ex);
                    }
                    catch (SchemaException ex) {
                        result.recordFatalError("Saving of result to " + ObjectTypeUtil.toShortString((ObjectType)shadowType) + " shadow failed: Schema error: " + ex.getMessage(), (Throwable)ex);
                    }
                }
                return doContinue;
            }
        };
        ajc$this.getResourceTypeManager().searchObjectsIterative(type, objectClass, (ResourceType)resource.asObjectable(), resourceAttributesFilter, shadowHandler, null, result);
        result.recordSuccess();
    }

    static final /* synthetic */ Set discoverConnectors_aroundBody22(ProvisioningServiceImpl ajc$this, ConnectorHostType hostType, OperationResult parentResult, JoinPoint joinPoint) {
        Set<ConnectorType> discoverConnectors;
        OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".discoverConnectors");
        result.addParam("host", (Object)hostType);
        result.addContext("implementationClass", ProvisioningServiceImpl.class);
        try {
            discoverConnectors = ajc$this.connectorTypeManager.discoverConnectors(hostType, result);
        }
        catch (CommunicationException ex) {
            result.recordFatalError("Discovery failed", (Throwable)ex);
            throw ex;
        }
        result.computeStatus("Connector discovery failed");
        return discoverConnectors;
    }

    static final /* synthetic */ void postInit_aroundBody24(ProvisioningServiceImpl ajc$this, OperationResult parentResult, JoinPoint joinPoint) {
        OperationResult result = parentResult.createSubresult(String.valueOf(ProvisioningService.class.getName()) + ".initialize");
        result.addContext("implementationClass", ProvisioningServiceImpl.class);
        Set<ConnectorType> discoverLocalConnectors = ajc$this.connectorTypeManager.discoverLocalConnectors(result);
        for (ConnectorType connector : discoverLocalConnectors) {
            LOGGER.info("Discovered local connector {}" + ObjectTypeUtil.toShortString((ObjectType)connector));
        }
        result.computeStatus("Provisioning post-initialization failed");
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ProvisioningServiceImpl.java", ProvisioningServiceImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getObject", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "java.lang.Class:java.lang.String:com.evolveum.midpoint.schema.result.OperationResult", "type:oid:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "com.evolveum.midpoint.prism.PrismObject"), 172);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addObject", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "com.evolveum.midpoint.prism.PrismObject:com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptsType:com.evolveum.midpoint.schema.result.OperationResult", "object:scripts:parentResult", "com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "java.lang.String"), 293);
        ajc$tjp_10 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchObjectsIterative", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "java.lang.Class:com.evolveum.prism.xml.ns._public.query_2.QueryType:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.provisioning.api.ResultHandler:com.evolveum.midpoint.schema.result.OperationResult", "type:query:paging:handler:parentResult", "com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "void"), 976);
        ajc$tjp_11 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "discoverConnectors", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorHostType:com.evolveum.midpoint.schema.result.OperationResult", "hostType:parentResult", "com.evolveum.midpoint.util.exception.CommunicationException", "java.util.Set"), 1191);
        ajc$tjp_12 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "postInit", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "com.evolveum.midpoint.schema.result.OperationResult", "parentResult", "", "void"), 1217);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "synchronize", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "java.lang.String:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "resourceOid:task:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "int"), 367);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listObjects", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "java.lang.Class:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.schema.result.OperationResult", "objectType:paging:parentResult", "", "java.util.List"), 565);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "searchObjects", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "java.lang.Class:com.evolveum.prism.xml.ns._public.query_2.QueryType:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.schema.result.OperationResult", "type:query:paging:parentResult", "com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "java.util.List"), 577);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "countObjects", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "java.lang.Class:com.evolveum.prism.xml.ns._public.query_2.QueryType:com.evolveum.midpoint.schema.result.OperationResult", "type:query:parentResult", "com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "int"), 696);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "modifyObject", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "java.lang.Class:java.lang.String:java.util.Collection:com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptsType:com.evolveum.midpoint.schema.result.OperationResult", "type:oid:modifications:scripts:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "void"), 734);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteObject", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "java.lang.Class:java.lang.String:com.evolveum.midpoint.xml.ns._public.common.common_2.ScriptsType:com.evolveum.midpoint.schema.result.OperationResult", "type:oid:scripts:parentResult", "com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException:com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ConfigurationException:com.evolveum.midpoint.util.exception.SecurityViolationException", "void"), 814);
        ajc$tjp_8 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "testResource", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "java.lang.String", "resourceOid", "com.evolveum.midpoint.util.exception.ObjectNotFoundException", "com.evolveum.midpoint.schema.result.OperationResult"), 887);
        ajc$tjp_9 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "listResourceObjects", "com.evolveum.midpoint.provisioning.impl.ProvisioningServiceImpl", "java.lang.String:javax.xml.namespace.QName:com.evolveum.midpoint.xml.ns._public.common.api_types_2.PagingType:com.evolveum.midpoint.schema.result.OperationResult", "resourceOid:objectClass:paging:parentResult", "com.evolveum.midpoint.util.exception.SchemaException:com.evolveum.midpoint.util.exception.ObjectNotFoundException:com.evolveum.midpoint.util.exception.CommunicationException", "java.util.List"), 923);
    }
}

