/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.impl;

import com.evolveum.midpoint.common.QueryUtil;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.provisioning.ucf.api.ConnectorFactory;
import com.evolveum.midpoint.provisioning.ucf.api.ConnectorInstance;
import com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ConnectorTypeUtil;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorHostType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ConnectorType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.prism.xml.ns._public.query_2.QueryType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Component
public class ConnectorTypeManager {
    @Autowired
    @Qualifier(value="cacheRepositoryService")
    private RepositoryService repositoryService;
    @Autowired
    private ConnectorFactory connectorFactory;
    @Autowired(required=true)
    private PrismContext prismContext;
    private static final Trace LOGGER = TraceManager.getTrace(ConnectorTypeManager.class);
    private Map<String, ConfiguredConnectorInstanceEntry> connectorInstanceCache = new HashMap<String, ConfiguredConnectorInstanceEntry>();

    public ConnectorInstance getConfiguredConnectorInstance(ResourceType resource, OperationResult result) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException {
        String resourceOid = resource.getOid();
        String connectorOid = ResourceTypeUtil.getConnectorOid((ResourceType)resource);
        if (this.connectorInstanceCache.containsKey(resourceOid)) {
            ConfiguredConnectorInstanceEntry configuredConnectorInstanceEntry = this.connectorInstanceCache.get(resourceOid);
            if (configuredConnectorInstanceEntry.connectorOid.equals(connectorOid) && configuredConnectorInstanceEntry.configuration.equivalent((Object)resource.asPrismObject().findContainer(ResourceType.F_CONFIGURATION))) {
                LOGGER.trace("HIT in connector cache: returning configured connector {} from cache (referenced from {})", (Object)connectorOid, (Object)resource);
                return configuredConnectorInstanceEntry.connectorInstance;
            }
            this.connectorInstanceCache.remove(resourceOid);
        }
        LOGGER.debug("MISS in connector cache: creating configured connector {} as referenced from {}", (Object)connectorOid, (Object)resource);
        ConnectorInstance configuredConnectorInstance = this.createConfiguredConnectorInstance(resource, result);
        ConfiguredConnectorInstanceEntry cacheEntry = new ConfiguredConnectorInstanceEntry();
        cacheEntry.connectorOid = connectorOid;
        cacheEntry.configuration = resource.asPrismObject().findContainer(ResourceType.F_CONFIGURATION);
        cacheEntry.connectorInstance = configuredConnectorInstance;
        this.connectorInstanceCache.put(resourceOid, cacheEntry);
        return configuredConnectorInstance;
    }

    private ConnectorInstance createConfiguredConnectorInstance(ResourceType resource, OperationResult result) throws ObjectNotFoundException, SchemaException, CommunicationException, ConfigurationException {
        LOGGER.info("Creating new connector instance for {}", (Object)ObjectTypeUtil.toShortString((ObjectType)resource));
        ConnectorType connectorType = this.getConnectorType(resource, result);
        ConnectorInstance connector = null;
        try {
            connector = this.connectorFactory.createConnectorInstance(connectorType, ResourceTypeUtil.getResourceNamespace((ResourceType)resource));
        }
        catch (ObjectNotFoundException e) {
            result.recordFatalError(e.getMessage(), (Throwable)e);
            throw new ObjectNotFoundException(e.getMessage(), (Throwable)e);
        }
        try {
            connector.configure(resource.getConfiguration().asPrismContainerValue(), result);
        }
        catch (GenericFrameworkException e) {
            result.recordFatalError("Generic provisioning framework error", (Throwable)e);
            throw new SystemException("Generic provisioning framework error: " + e.getMessage(), (Throwable)e);
        }
        catch (CommunicationException e) {
            result.recordFatalError((Throwable)e);
            throw e;
        }
        catch (ConfigurationException e) {
            result.recordFatalError((Throwable)e);
            throw e;
        }
        return connector;
    }

    public ConnectorType getConnectorType(ResourceType resource, OperationResult result) throws ObjectNotFoundException, SchemaException {
        if (resource.getConnector() != null) {
            return resource.getConnector();
        }
        if (resource.getConnectorRef() == null || resource.getConnectorRef().getOid() == null) {
            result.recordFatalError("Connector reference missing in the resource " + ObjectTypeUtil.toShortString((ObjectType)resource));
            throw new ObjectNotFoundException("Connector reference missing in the resource " + ObjectTypeUtil.toShortString((ObjectType)resource));
        }
        String connOid = resource.getConnectorRef().getOid();
        PrismObject connectorPrism = this.repositoryService.getObject(ConnectorType.class, connOid, result);
        return (ConnectorType)connectorPrism.asObjectable();
    }

    public Set<ConnectorType> discoverLocalConnectors(OperationResult parentResult) {
        try {
            return this.discoverConnectors(null, parentResult);
        }
        catch (CommunicationException e) {
            parentResult.recordFatalError("Unexpected error: " + e.getMessage(), (Throwable)e);
            throw new SystemException("Unexpected error: " + e.getMessage(), (Throwable)e);
        }
    }

    public Set<ConnectorType> discoverConnectors(ConnectorHostType hostType, OperationResult parentResult) throws CommunicationException {
        Set<ConnectorType> foundConnectors;
        OperationResult result = parentResult.createSubresult(String.valueOf(ConnectorTypeManager.class.getName()) + ".discoverConnectors");
        result.addParam("host", (Object)hostType);
        if (hostType != null && hostType.getOid() == null) {
            throw new SystemException("Discovery attempt with non-persistent " + ObjectTypeUtil.toShortString((ObjectType)hostType));
        }
        HashSet<ConnectorType> discoveredConnectors = new HashSet<ConnectorType>();
        try {
            foundConnectors = this.connectorFactory.listConnectors(hostType, result);
        }
        catch (CommunicationException ex) {
            result.recordFatalError("Discovery failed: " + ex.getMessage(), (Throwable)ex);
            throw new CommunicationException("Discovery failed: " + ex.getMessage(), (Throwable)ex);
        }
        for (ConnectorType foundConnector : foundConnectors) {
            String oid;
            LOGGER.trace("Found connector " + ObjectTypeUtil.toShortString((ObjectType)foundConnector));
            boolean inRepo = true;
            try {
                inRepo = this.isInRepo(foundConnector, result);
            }
            catch (SchemaException e1) {
                LOGGER.error("Unexpected schema problem while checking existence of " + ObjectTypeUtil.toShortString((ObjectType)foundConnector), (Throwable)e1);
                result.recordPartialError("Unexpected schema problem while checking existence of " + ObjectTypeUtil.toShortString((ObjectType)foundConnector), (Throwable)e1);
            }
            if (inRepo) continue;
            LOGGER.trace("Connector " + ObjectTypeUtil.toShortString((ObjectType)foundConnector) + " not in the repository, \"dicovering\" it");
            if (hostType != null && foundConnector.getConnectorHost() == null) {
                foundConnector.setConnectorHost(hostType);
            }
            ConnectorInstance connectorInstance = null;
            try {
                connectorInstance = this.connectorFactory.createConnectorInstance(foundConnector, null);
                PrismSchema connectorSchema = connectorInstance.generateConnectorSchema();
                if (connectorSchema == null) {
                    LOGGER.warn("Connector {} haven't provided configuration schema", (Object)ObjectTypeUtil.toShortString((ObjectType)foundConnector));
                } else {
                    LOGGER.trace("Generated connector schema for {}: {} definitions", (Object)ObjectTypeUtil.toShortString((ObjectType)foundConnector), (Object)connectorSchema.getDefinitions().size());
                    Document xsdDoc = null;
                    xsdDoc = connectorSchema.serializeToXsd();
                    Element xsdElement = DOMUtil.getFirstChildElement((Node)xsdDoc);
                    LOGGER.trace("Generated XSD connector schema: {}", (Object)DOMUtil.serializeDOMToString((Node)xsdElement));
                    ConnectorTypeUtil.setConnectorXsdSchema((ConnectorType)foundConnector, (Element)xsdElement);
                }
            }
            catch (ObjectNotFoundException ex) {
                LOGGER.error("Cannot instantiate discovered connector " + ObjectTypeUtil.toShortString((ObjectType)foundConnector), (Throwable)ex);
                result.recordPartialError("Cannot instantiate discovered connector " + ObjectTypeUtil.toShortString((ObjectType)foundConnector), (Throwable)ex);
            }
            catch (SchemaException e) {
                LOGGER.error("Error processing connector schema for " + ObjectTypeUtil.toShortString((ObjectType)foundConnector) + ": " + e.getMessage(), (Throwable)e);
                result.recordPartialError("Error processing connector schema for " + ObjectTypeUtil.toShortString((ObjectType)foundConnector) + ": " + e.getMessage(), (Throwable)e);
            }
            if (StringUtils.isNotEmpty((String)foundConnector.getOid())) {
                LOGGER.warn("Provisioning framework " + foundConnector.getFramework() + " supplied OID for connector " + ObjectTypeUtil.toShortString((ObjectType)foundConnector));
                foundConnector.setOid(null);
            }
            try {
                this.prismContext.adopt((Objectable)foundConnector);
                oid = this.repositoryService.addObject(foundConnector.asPrismObject(), result);
            }
            catch (ObjectAlreadyExistsException e) {
                LOGGER.error("Got ObjectAlreadyExistsException while not expecting it: " + e.getMessage(), (Throwable)e);
                result.recordFatalError("Got ObjectAlreadyExistsException while not expecting it: " + e.getMessage(), (Throwable)e);
                throw new SystemException("Got ObjectAlreadyExistsException while not expecting it: " + e.getMessage(), (Throwable)e);
            }
            catch (SchemaException e) {
                LOGGER.error("Got SchemaException while not expecting it: " + e.getMessage(), (Throwable)e);
                result.recordFatalError("Got SchemaException while not expecting it: " + e.getMessage(), (Throwable)e);
                throw new SystemException("Got SchemaException while not expecting it: " + e.getMessage(), (Throwable)e);
            }
            foundConnector.setOid(oid);
            discoveredConnectors.add(foundConnector);
            LOGGER.info("Discovered new connector " + foundConnector);
        }
        result.recordSuccess();
        return discoveredConnectors;
    }

    private boolean isInRepo(ConnectorType connectorType, OperationResult result) throws SchemaException {
        List foundConnectors;
        Document doc = DOMUtil.getDocument();
        Element filter = QueryUtil.createAndFilter((Document)doc, (Element[])new Element[]{QueryUtil.createEqualFilter((Document)doc, null, (QName)SchemaConstants.C_CONNECTOR_FRAMEWORK, (String)connectorType.getFramework()), QueryUtil.createEqualFilter((Document)doc, null, (QName)SchemaConstants.C_CONNECTOR_CONNECTOR_TYPE, (String)connectorType.getConnectorType())});
        QueryType query = new QueryType();
        query.setFilter(filter);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Looking for connector in repository:\n{}", (Object)DOMUtil.serializeDOMToString((Node)filter));
        }
        try {
            foundConnectors = this.repositoryService.searchObjects(ConnectorType.class, query, null, result);
        }
        catch (SchemaException e) {
            LOGGER.error("Got SchemaException while not expecting it: " + e.getMessage(), (Throwable)e);
            result.recordFatalError("Got SchemaException while not expecting it: " + e.getMessage(), (Throwable)e);
            throw new SystemException("Got SchemaException while not expecting it: " + e.getMessage(), (Throwable)e);
        }
        if (foundConnectors.size() == 0) {
            return false;
        }
        String foundOid = null;
        for (PrismObject foundConnector : foundConnectors) {
            if (!this.compareConnectors((PrismObject<ConnectorType>)connectorType.asPrismObject(), (PrismObject<ConnectorType>)foundConnector)) continue;
            if (foundOid != null) {
                result.recordPartialError("Found more than one connector that matches " + connectorType.getFramework() + " : " + connectorType.getConnectorType() + " : " + connectorType.getVersion() + ". OIDs " + foundConnector.getOid() + " and " + foundOid + ". Inconsistent database state.");
                LOGGER.error("Found more than one connector that matches " + connectorType.getFramework() + " : " + connectorType.getConnectorType() + " : " + connectorType.getVersion() + ". OIDs " + foundConnector.getOid() + " and " + foundOid + ". Inconsistent database state.");
                return true;
            }
            foundOid = foundConnector.getOid();
        }
        return foundOid != null;
    }

    private boolean compareConnectors(PrismObject<ConnectorType> prismA, PrismObject<ConnectorType> prismB) {
        ConnectorType a = (ConnectorType)prismA.asObjectable();
        ConnectorType b = (ConnectorType)prismB.asObjectable();
        if (!a.getFramework().equals(b.getFramework())) {
            return false;
        }
        if (!a.getConnectorType().equals(b.getConnectorType())) {
            return false;
        }
        if (a.getConnectorHostRef() != null ? !a.getConnectorHostRef().equals((Object)b.getConnectorHostRef()) : b.getConnectorHostRef() != null) {
            return false;
        }
        if (a.getConnectorVersion() == null && b.getConnectorVersion() == null) {
            return true;
        }
        if (a.getConnectorVersion() != null && b.getConnectorVersion() != null) {
            return a.getConnectorVersion().equals(b.getConnectorVersion());
        }
        LOGGER.error("Inconsistent representation of ConnectorType, one has connectorVersion and other does not. OIDs: " + a.getOid() + " and " + b.getOid());
        return false;
    }

    private class ConfiguredConnectorInstanceEntry {
        public String connectorOid;
        public PrismContainer configuration;
        public ConnectorInstance connectorInstance;

        private ConfiguredConnectorInstanceEntry() {
        }
    }
}

