/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.ws.message.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensaml.ws.message.handler.BasicHandlerChain;
import org.opensaml.ws.message.handler.Handler;
import org.opensaml.ws.message.handler.HandlerChain;
import org.opensaml.ws.message.handler.PhasedHandlerChain;
import org.opensaml.xml.util.LazyList;
import org.opensaml.xml.util.LazyMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPhasedHandlerChain
extends BasicHandlerChain
implements PhasedHandlerChain {
    private final Logger log = LoggerFactory.getLogger(BasicPhasedHandlerChain.class);
    private List<String> phaseOrder = new LazyList();
    private Map<String, HandlerChain> phaseChains = new LazyMap();

    @Override
    public List<Handler> getHandlers() {
        ArrayList<Handler> handlers = new ArrayList<Handler>();
        for (String phaseName : this.getPhaseOrder()) {
            HandlerChain phase = this.getPhaseChains().get(phaseName);
            if (phase != null) {
                List<Handler> phaseHandlers = phase.getHandlers();
                if (!phaseHandlers.isEmpty()) {
                    handlers.addAll(phaseHandlers);
                    continue;
                }
                this.log.info("Specified phase name '{}' exists in PhasedHandlerChain, but contains no handlers", (Object)phaseName);
                continue;
            }
            this.log.warn("Specified phase name '{}' does not exist in PhasedHandlerChain: {}", (Object)phaseName, this.getPhaseChains().keySet());
        }
        return Collections.unmodifiableList(handlers);
    }

    @Override
    public Map<String, HandlerChain> getPhaseChains() {
        return this.phaseChains;
    }

    @Override
    public List<String> getPhaseOrder() {
        return this.phaseOrder;
    }

    @Override
    public void setPhaseOrder(List<String> newPhaseOrder) {
        this.phaseOrder = newPhaseOrder;
    }
}

