/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.xjc;

import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.xjc.JaxbTypeConverter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.Validate;

public class PropertyArrayList<T>
extends AbstractList<T> {
    private PrismProperty property;

    public PropertyArrayList(PrismProperty property) {
        Validate.notNull((Object)property, (String)"Property must not be null.");
        this.property = property;
    }

    @Override
    public int size() {
        return this.property.getValues().size();
    }

    @Override
    public T get(int index) {
        Object propertyRealValue = this.getPropertyValue(index).getValue();
        return JaxbTypeConverter.mapPropertyRealValueToJaxb(propertyRealValue);
    }

    @Override
    public boolean addAll(Collection<? extends T> ts) {
        Validate.notNull(ts, (String)"Collection must not be null.");
        if (ts.isEmpty()) {
            return false;
        }
        for (T jaxbObject : ts) {
            Object propertyRealValue = JaxbTypeConverter.mapJaxbToPropertyRealValue(jaxbObject);
            this.property.addValue(new PrismPropertyValue<Object>(propertyRealValue, null, null));
        }
        return true;
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> ts) {
        return this.addAll(ts);
    }

    @Override
    public boolean add(T t) {
        ArrayList<T> collection = new ArrayList<T>();
        collection.add(t);
        return this.addAll((Collection<? extends T>)collection);
    }

    @Override
    public void add(int i, T t) {
        this.add(t);
    }

    private PrismPropertyValue<Object> getPropertyValue(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Can't get object on position '" + index + "', list size is '" + this.size() + "'.");
        }
        Iterator iterator = this.property.getValues().iterator();
        int i = 0;
        while (i < index) {
            iterator.next();
            ++i;
        }
        return iterator.next();
    }

    @Override
    public T remove(int i) {
        PrismPropertyValue<Object> value = this.getPropertyValue(i);
        this.property.deleteValue(value);
        return (T)value.getValue();
    }

    @Override
    public boolean remove(Object o) {
        PrismPropertyValue value = null;
        for (PrismPropertyValue prismValue : this.property.getValues()) {
            if (o != null && o.equals(prismValue.getValue())) {
                value = prismValue;
                break;
            }
            if (o != null || prismValue.getValue() != null) continue;
            value = prismValue;
            break;
        }
        if (value == null) {
            return false;
        }
        return this.property.deleteValue(value);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean changed = false;
        for (Object object : objects) {
            if (!changed) {
                changed = this.remove(object);
                continue;
            }
            this.remove(object);
        }
        return changed;
    }
}

