/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.xjc;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.Validate;

public abstract class PrismContainerArrayList<T extends Containerable>
extends ArrayList<T> {
    private PrismContainer<T> container;

    public PrismContainerArrayList(PrismContainer<T> container) {
        Validate.notNull(container);
        this.container = container;
    }

    protected abstract T createItem(PrismContainerValue var1);

    protected abstract PrismContainerValue getValueFrom(T var1);

    @Override
    public T get(int i) {
        this.testIndex(i);
        return this.createItem(this.getValues().get(i));
    }

    private List<PrismContainerValue<T>> getValues() {
        return this.container.getValues();
    }

    @Override
    public int size() {
        return this.getValues().size();
    }

    private void testIndex(int i) {
        if (i < 0 || i >= this.getValues().size()) {
            throw new IndexOutOfBoundsException("Can't get index '" + i + "', values size is '" + this.getValues().size() + "'.");
        }
    }

    @Override
    public T remove(int i) {
        this.testIndex(i);
        PrismContainerValue<T> value = this.getValues().get(i);
        this.getValues().remove(i);
        return this.createItem(value);
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean changed = false;
        for (Object object : objects) {
            if (!changed) {
                changed = this.remove(object);
                continue;
            }
            this.remove(object);
        }
        return changed;
    }

    @Override
    public boolean remove(Object o) {
        Containerable t = (Containerable)o;
        PrismContainerValue value = this.getValueFrom(t);
        return this.container.remove(value);
    }

    @Override
    public boolean add(T t) {
        PrismContainerValue value = this.getValueFrom(t);
        try {
            return this.container.add(value);
        }
        catch (SchemaException ex) {
            throw new SystemException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> ts) {
        boolean changed = false;
        for (Containerable t : ts) {
            if (!changed) {
                changed = this.add((T)t);
                continue;
            }
            this.add((T)t);
        }
        return changed;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }
}

