/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.xjc;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.util.JAXBUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;

public class AnyArrayList<T extends Containerable>
extends AbstractList<Object> {
    private PrismContainerValue<T> containerValue;

    public AnyArrayList(PrismContainerValue<T> containerValue) {
        Validate.notNull(containerValue, (String)"Container value must not be null.");
        this.containerValue = containerValue;
    }

    @Override
    public int size() {
        if (this.isSchemaless()) {
            return this.getElements().size();
        }
        int size = 0;
        for (Item<?> item : this.containerValue.getItems()) {
            size += item.getValues().size();
        }
        return size;
    }

    @Override
    public Object get(int index) {
        if (this.isSchemaless()) {
            return this.getElements().get(index);
        }
        for (Item<?> item : this.containerValue.getItems()) {
            if (index < item.getValues().size()) {
                return this.asElement((PrismValue)item.getValue(index));
            }
            index -= item.getValues().size();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean addAll(Collection<? extends Object> elements) {
        Validate.notNull(elements, (String)"Collection must not be null.");
        if (elements.isEmpty()) {
            return false;
        }
        for (Object object : elements) {
            this.add(object);
        }
        return true;
    }

    @Override
    public boolean addAll(int i, Collection<? extends Object> elements) {
        return this.addAll(elements);
    }

    @Override
    public boolean add(Object element) {
        Item<?> item;
        if (this.isSchemaless()) {
            return this.getElements().add(element);
        }
        QName elementName = JAXBUtil.getElementQName((Object)element);
        try {
            item = this.containerValue.findOrCreateItem(elementName);
        }
        catch (SchemaException e1) {
            throw new IllegalStateException("Internal schema error: " + e1.getMessage(), e1);
        }
        try {
            return this.getPrismContext().getPrismDomProcessor().addItemValue(item, element, this.getContainer());
        }
        catch (SchemaException e) {
            throw new IllegalArgumentException("Element " + elementName + " cannot be added because is violates object schema: " + e.getMessage(), e);
        }
    }

    @Override
    public void add(int i, Object element) {
        this.add(element);
    }

    @Override
    public Object remove(int index) {
        if (this.isSchemaless()) {
            return this.getElements().remove(index);
        }
        for (Item<?> item : this.containerValue.getItems()) {
            if (index < item.getValues().size()) {
                item.remove(index);
                continue;
            }
            index -= item.getValues().size();
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean remove(Object element) {
        if (this.isSchemaless()) {
            return this.getElements().remove(element);
        }
        QName elementName = JAXBUtil.getElementQName((Object)element);
        Item<?> item = this.containerValue.findItem(elementName);
        try {
            return this.getPrismContext().getPrismDomProcessor().deleteItemValue(item, element, this.getContainer());
        }
        catch (SchemaException e) {
            throw new IllegalArgumentException("Element " + elementName + " cannot be removed because is violates object schema: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        boolean changed = false;
        for (Object object : objects) {
            if (!changed) {
                changed = this.remove(object);
                continue;
            }
            this.remove(object);
        }
        return changed;
    }

    private PrismContainerDefinition getDefinition() {
        PrismContainer<T> container = this.getContainer();
        if (container == null) {
            return null;
        }
        return container.getDefinition();
    }

    private boolean isSchemaless() {
        return this.getDefinition() == null;
    }

    private List<Object> getElements() {
        return this.containerValue.getRawElements();
    }

    private PrismContainer<T> getContainer() {
        return this.containerValue.getContainer();
    }

    private PrismContext getPrismContext() {
        return this.getContainer().getPrismContext();
    }

    private Object asElement(PrismValue itemValue) {
        return itemValue.asDomElement();
    }
}

