/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.util;

import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.prism.util.PrismContextFactory;
import com.evolveum.midpoint.prism.xml.PrismJaxbProcessor;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PrismTestUtil {
    private static final QName DEFAULT_ELEMENT_NAME = new QName("http://midpoint.evolveum.com/xml/ns/test/whatever-1.xsd", "whatever");
    private static PrismContext prismContext;
    private static PrismContextFactory prismContextFactory;

    public static void resetPrismContext(PrismContextFactory newPrismContextFactory) throws SchemaException, SAXException, IOException {
        if (prismContextFactory == newPrismContextFactory) {
            return;
        }
        PrismTestUtil.setFactory(newPrismContextFactory);
        PrismTestUtil.resetPrismContext();
    }

    public static void setFactory(PrismContextFactory newPrismContextFactory) {
        prismContextFactory = newPrismContextFactory;
    }

    public static void resetPrismContext() throws SchemaException, SAXException, IOException {
        prismContext = PrismTestUtil.createInitializedPrismContext();
    }

    public static PrismContext createPrismContext() throws SchemaException, FileNotFoundException {
        if (prismContextFactory == null) {
            throw new IllegalStateException("Cannot create prism context, no prism factory is set");
        }
        return prismContextFactory.createPrismContext();
    }

    public static PrismContext createInitializedPrismContext() throws SchemaException, SAXException, IOException {
        PrismContext newPrismContext = PrismTestUtil.createPrismContext();
        newPrismContext.initialize();
        return newPrismContext;
    }

    public static PrismContext getPrismContext() {
        if (prismContext == null) {
            throw new IllegalStateException("Prism context is not set in PrismTestUtil. Maybe a missing call to resetPrismContext(..) in test initialization?");
        }
        return prismContext;
    }

    public static SchemaRegistry getSchemaRegistry() {
        return prismContext.getSchemaRegistry();
    }

    public static <T extends Objectable> PrismObject<T> parseObject(File file) throws SchemaException {
        return PrismTestUtil.getPrismContext().getPrismDomProcessor().parseObject(file);
    }

    public static <T extends Objectable> PrismObject<T> parseObject(String xmlString) throws SchemaException {
        return PrismTestUtil.getPrismContext().parseObject(xmlString);
    }

    public static <T extends Objectable> PrismObject<T> parseObject(Element element) throws SchemaException {
        return PrismTestUtil.getPrismContext().parseObject(element);
    }

    public static List<PrismObject<? extends Objectable>> parseObjects(File file) throws SchemaException {
        return PrismTestUtil.getPrismContext().getPrismDomProcessor().parseObjects(file);
    }

    public static String serializeObjectToString(PrismObject<? extends Objectable> object) throws SchemaException {
        return PrismTestUtil.getPrismContext().getPrismDomProcessor().serializeObjectToString(object);
    }

    public static void marshalElementToDom(JAXBElement<?> jaxbElement, Node parentNode) throws JAXBException {
        PrismTestUtil.getPrismJaxbProcessor().marshalElementToDom(jaxbElement, parentNode);
    }

    public static <T> JAXBElement<T> unmarshalElement(String xmlString, Class<T> type) throws JAXBException, SchemaException {
        return PrismTestUtil.getPrismJaxbProcessor().unmarshalElement(xmlString, type);
    }

    public static <T> T unmarshalObject(File file, Class<T> type) throws JAXBException, SchemaException, FileNotFoundException {
        return PrismTestUtil.getPrismJaxbProcessor().unmarshalObject(file, type);
    }

    public static <T> T unmarshalObject(String stringXml, Class<T> type) throws JAXBException, SchemaException {
        return PrismTestUtil.getPrismJaxbProcessor().unmarshalObject(stringXml, type);
    }

    public static <T> JAXBElement<T> unmarshalElement(File xmlFile, Class<T> type) throws JAXBException, SchemaException, FileNotFoundException {
        return PrismTestUtil.getPrismJaxbProcessor().unmarshalElement(xmlFile, type);
    }

    public static <T> Element marshalObjectToDom(T jaxbObject, QName elementQName, Document doc) throws JAXBException {
        return PrismTestUtil.getPrismJaxbProcessor().marshalObjectToDom(jaxbObject, elementQName, doc);
    }

    public static Element toDomElement(Object element) throws JAXBException {
        return PrismTestUtil.getPrismJaxbProcessor().toDomElement(element);
    }

    public static Element toDomElement(Object jaxbElement, Document doc) throws JAXBException {
        return PrismTestUtil.getPrismJaxbProcessor().toDomElement(jaxbElement, doc);
    }

    public static Element toDomElement(Object jaxbElement, Document doc, boolean adopt, boolean clone, boolean deep) throws JAXBException {
        return PrismTestUtil.getPrismJaxbProcessor().toDomElement(jaxbElement, doc, adopt, clone, deep);
    }

    public static String marshalToString(Objectable objectable) throws JAXBException {
        return PrismTestUtil.getPrismJaxbProcessor().marshalToString(objectable);
    }

    public static String marshalElementToString(JAXBElement<?> jaxbElement) throws JAXBException {
        return PrismTestUtil.getPrismJaxbProcessor().marshalElementToString(jaxbElement);
    }

    public static String marshalElementToString(Object element) throws JAXBException {
        return PrismTestUtil.getPrismJaxbProcessor().marshalElementToString(element);
    }

    public static String marshalWrap(Object jaxbObject) throws JAXBException {
        JAXBElement jaxbElement = new JAXBElement(DEFAULT_ELEMENT_NAME, jaxbObject.getClass(), jaxbObject);
        return PrismTestUtil.marshalElementToString(jaxbElement);
    }

    private static PrismJaxbProcessor getPrismJaxbProcessor() {
        if (prismContext == null) {
            throw new IllegalStateException("No prism context in Prism test util");
        }
        PrismJaxbProcessor prismJaxbProcessor = prismContext.getPrismJaxbProcessor();
        if (prismJaxbProcessor == null) {
            throw new IllegalStateException("No prism JAXB processor in Prism test util");
        }
        return prismJaxbProcessor;
    }

    public static <T extends Objectable> PrismObjectDefinition<T> getObjectDefinition(Class<T> compileTimeClass) {
        return PrismTestUtil.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(compileTimeClass);
    }

    public static PolyString createPolyString(String orig) {
        PolyString polyString = new PolyString(orig);
        polyString.recompute(PrismTestUtil.getPrismContext().getDefaultPolyStringNormalizer());
        return polyString;
    }
}

