/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.util;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ContainerDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PrismValueDeltaSetTriple;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.prism.dom.PrismDomProcessor;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.prism.util.PrismTestUtil;
import com.evolveum.midpoint.prism.xml.PrismJaxbProcessor;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.prism.xml.ns._public.types_2.PolyStringType;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import javax.xml.bind.JAXBElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;

public class PrismAsserts {
    private static final Trace LOGGER = TraceManager.getTrace(PrismAsserts.class);

    public static <T> void assertPropertyValue(PrismContainer<?> container, QName propQName, T ... realPropValues) {
        PrismContainerValue<?> containerValue = container.getValue();
        PrismAsserts.assertSame("Wrong parent for value of container " + container, container, containerValue.getParent());
        PrismAsserts.assertPropertyValue(containerValue, propQName, realPropValues);
    }

    public static <T> void assertPropertyValue(PrismContainerValue<?> containerValue, QName propQName, T ... realPropValues) {
        PrismProperty property = containerValue.findProperty(propQName);
        PrismAsserts.assertNotNull("Property " + propQName + " not found in " + containerValue.getParent(), property);
        PrismAsserts.assertSame("Wrong parent for property " + property, containerValue, property.getParent());
        PrismAsserts.assertPropertyValue(property, realPropValues);
    }

    public static <T> void assertPropertyValue(PrismProperty<T> property, T ... expectedPropValues) {
        Collection pvals = property.getValues();
        QName propQName = property.getName();
        assert (pvals != null && !pvals.isEmpty()) : "Empty property " + propQName;
        PrismAsserts.assertSet("property " + propQName, pvals, expectedPropValues);
    }

    public static <T> void assertPropertyValues(String message, Collection<T> expected, Collection<PrismPropertyValue<T>> results) {
        PrismAsserts.assertEquals(String.valueOf(message) + " - unexpected number of results", expected.size(), (Object)results.size());
        HashSet<T> values = new HashSet<T>();
        for (PrismPropertyValue<T> result : results) {
            values.add(result.getValue());
        }
        PrismAsserts.assertEquals(message, expected, values);
    }

    public static <T> void assertPropertyValues(String message, Collection<PrismPropertyValue<T>> results, T ... expectedValues) {
        PrismAsserts.assertSet(message, results, expectedValues);
    }

    public static void assertReferenceValues(PrismReference ref, String ... oids) {
        assert (oids.length == ref.getValues().size()) : "Wrong number of values in " + ref + "; expected " + oids.length + " but was " + ref.getValues().size();
        String[] stringArray = oids;
        int n = oids.length;
        int n2 = 0;
        while (n2 < n) {
            String oid = stringArray[n2];
            PrismAsserts.assertReferenceValue(ref, oid);
            ++n2;
        }
    }

    public static void assertReferenceValue(PrismReference ref, String oid) {
        for (PrismReferenceValue val : ref.getValues()) {
            if (!oid.equals(val.getOid())) continue;
            return;
        }
        PrismAsserts.fail("Oid " + oid + " not found in reference " + ref);
    }

    public static <T extends Objectable> void assertObjectDefinition(PrismObjectDefinition<T> objDef, QName elementName, QName typeName, Class<T> compileTimeClass) {
        PrismAsserts.assertNotNull("No definition", objDef);
        PrismAsserts.assertEquals("Wrong elementName for " + objDef, elementName, (Object)objDef.getName());
        PrismAsserts.assertEquals("Wrong typeName for " + objDef, typeName, (Object)objDef.getTypeName());
        PrismAsserts.assertEquals("Wrong compileTimeClass for " + objDef, compileTimeClass, objDef.getCompileTimeClass());
    }

    public static void assertDefinition(Item item, QName type, int minOccurs, int maxOccurs) {
        ItemDefinition definition = item.getDefinition();
        PrismAsserts.assertDefinition(definition, item.getName(), type, minOccurs, maxOccurs);
    }

    public static void assertPropertyDefinition(PrismContainer<?> container, QName propertyName, QName type, int minOccurs, int maxOccurs) {
        PrismProperty findProperty = container.findProperty(propertyName);
        PrismPropertyDefinition definition = findProperty.getDefinition();
        PrismAsserts.assertDefinition(definition, propertyName, type, minOccurs, maxOccurs);
    }

    public static void assertPropertyDefinition(PrismContainerDefinition<?> containerDef, QName propertyName, QName type, int minOccurs, int maxOccurs) {
        PrismPropertyDefinition definition = containerDef.findPropertyDefinition(propertyName);
        PrismAsserts.assertDefinition(definition, propertyName, type, minOccurs, maxOccurs);
    }

    public static void assertItemDefinitionDisplayName(PrismContainerDefinition<?> containerDef, QName propertyName, String expectedDisplayName) {
        ItemDefinition definition = containerDef.findItemDefinition(propertyName);
        assert (PrismAsserts.equals(expectedDisplayName, definition.getDisplayName())) : "Wrong display name for item " + propertyName + ", expected " + expectedDisplayName + ", was " + definition.getDisplayName();
    }

    public static void assertItemDefinitionDisplayOrder(PrismContainerDefinition<?> containerDef, QName propertyName, Integer expectedDisplayOrder) {
        ItemDefinition definition = containerDef.findItemDefinition(propertyName);
        assert (PrismAsserts.equals(expectedDisplayOrder, definition.getDisplayOrder())) : "Wrong display order for item " + propertyName + ", expected " + expectedDisplayOrder + ", was " + definition.getDisplayOrder();
    }

    public static void assertItemDefinitionHelp(PrismContainerDefinition<?> containerDef, QName propertyName, String expectedHelp) {
        ItemDefinition definition = containerDef.findItemDefinition(propertyName);
        assert (PrismAsserts.equals(expectedHelp, definition.getHelp())) : "Wrong help for item " + propertyName + ", expected " + expectedHelp + ", was " + definition.getHelp();
    }

    public static void assertDefinition(ItemDefinition definition, QName itemName, QName type, int minOccurs, int maxOccurs) {
        PrismAsserts.assertNotNull("No definition for " + itemName, definition);
        PrismAsserts.assertEquals("Wrong definition type for " + itemName, type, (Object)definition.getTypeName());
        PrismAsserts.assertEquals("Wrong definition minOccurs for " + itemName, minOccurs, (Object)definition.getMinOccurs());
        PrismAsserts.assertEquals("Wrong definition maxOccurs for " + itemName, maxOccurs, (Object)definition.getMaxOccurs());
    }

    public static void assertParentConsistency(PrismContainerValue<?> pval) {
        for (Item<?> item : pval.getItems()) {
            assert (item.getParent() == pval) : "Wrong parent in " + item;
            PrismAsserts.assertParentConsistency(item);
        }
    }

    public static void assertParentConsistency(Item<?> item) {
        for (PrismValue pval : item.getValues()) {
            assert (pval.getParent() == item) : "Wrong parent of " + pval + " in " + DebugUtil.prettyPrint((QName)item.getName());
            if (!(pval instanceof PrismContainerValue)) continue;
            PrismAsserts.assertParentConsistency((PrismContainerValue)pval);
        }
    }

    public static void assertPropertyReplace(ObjectDelta<?> userDelta, QName propertyName, Object ... expectedValues) {
        PropertyDelta propertyDelta = userDelta.findPropertyDelta(propertyName);
        PrismAsserts.assertNotNull("Property delta for " + propertyName + " not found", propertyDelta);
        PrismAsserts.assertSet("delta for " + propertyName, propertyDelta.getValuesToReplace(), expectedValues);
    }

    public static void assertPropertyAdd(ObjectDelta<?> userDelta, QName propertyName, Object ... expectedValues) {
        PropertyDelta propertyDelta = userDelta.findPropertyDelta(propertyName);
        PrismAsserts.assertNotNull("Property delta for " + propertyName + " not found", propertyDelta);
        PrismAsserts.assertSet("delta for " + propertyName, propertyDelta.getValuesToAdd(), expectedValues);
    }

    public static void assertPropertyDelete(ObjectDelta<?> userDelta, QName propertyName, Object ... expectedValues) {
        PropertyDelta propertyDelta = userDelta.findPropertyDelta(propertyName);
        PrismAsserts.assertNotNull("Property delta for " + propertyName + " not found", propertyDelta);
        PrismAsserts.assertSet("delta for " + propertyName, propertyDelta.getValuesToDelete(), expectedValues);
    }

    public static void assertPropertyReplace(ObjectDelta<?> userDelta, PropertyPath propertyPath, Object ... expectedValues) {
        PropertyDelta propertyDelta = userDelta.findPropertyDelta(propertyPath);
        PrismAsserts.assertNotNull("Property delta for " + propertyPath + " not found", propertyDelta);
        PrismAsserts.assertSet("delta for " + propertyPath.last().getName(), propertyDelta.getValuesToReplace(), expectedValues);
    }

    public static void assertPropertyAdd(ObjectDelta<?> userDelta, PropertyPath propertyPath, Object ... expectedValues) {
        PropertyDelta propertyDelta = userDelta.findPropertyDelta(propertyPath);
        PrismAsserts.assertNotNull("Property delta for " + propertyPath + " not found", propertyDelta);
        PrismAsserts.assertSet("delta for " + propertyPath.last().getName(), propertyDelta.getValuesToAdd(), expectedValues);
    }

    public static void assertPropertyDelete(ObjectDelta<?> userDelta, PropertyPath propertyPath, Object ... expectedValues) {
        PropertyDelta propertyDelta = userDelta.findPropertyDelta(propertyPath);
        PrismAsserts.assertNotNull("Property delta for " + propertyPath + " not found", propertyDelta);
        PrismAsserts.assertSet("delta for " + propertyPath.last().getName(), propertyDelta.getValuesToDelete(), expectedValues);
    }

    public static void assertNoItemDelta(ObjectDelta<?> userDelta, PropertyPath propertyPath) {
        assert (!userDelta.hasItemDelta(propertyPath)) : "Delta for item " + propertyPath + " present while not expecting it";
    }

    public static ContainerDelta<?> assertContainerAdd(ObjectDelta<?> objectDelta, QName name) {
        return PrismAsserts.assertContainerAdd(objectDelta, new PropertyPath(name));
    }

    public static ContainerDelta<?> assertContainerAdd(ObjectDelta<?> objectDelta, PropertyPath propertyPath) {
        ContainerDelta delta = objectDelta.findContainerDelta(propertyPath);
        PrismAsserts.assertNotNull("Container delta for " + propertyPath + " not found", delta);
        assert (!delta.isEmpty()) : "Container delta for " + propertyPath + " is empty";
        assert (delta.getValuesToAdd() != null) : "Container delta for " + propertyPath + " has null values to add";
        assert (!delta.getValuesToAdd().isEmpty()) : "Container delta for " + propertyPath + " has empty values to add";
        return delta;
    }

    public static ContainerDelta<?> assertContainerDelete(ObjectDelta<?> objectDelta, QName name) {
        return PrismAsserts.assertContainerDelete(objectDelta, new PropertyPath(name));
    }

    public static ContainerDelta<?> assertContainerDelete(ObjectDelta<?> objectDelta, PropertyPath propertyPath) {
        ContainerDelta delta = objectDelta.findContainerDelta(propertyPath);
        PrismAsserts.assertNotNull("Container delta for " + propertyPath + " not found", delta);
        assert (!delta.isEmpty()) : "Container delta for " + propertyPath + " is empty";
        assert (delta.getValuesToDelete() != null) : "Container delta for " + propertyPath + " has null values to delete";
        assert (!delta.getValuesToDelete().isEmpty()) : "Container delta for " + propertyPath + " has empty values to delete";
        return delta;
    }

    public static <T, V extends PrismValue> void assertTriplePlus(PrismValueDeltaSetTriple<V> triple, T ... expectedValues) {
        assert (triple != null) : "Plus set is null";
        PrismAsserts.assertTripleSet("plus set", triple.getPlusSet(), expectedValues);
    }

    public static <T, V extends PrismValue> void assertTripleZero(PrismValueDeltaSetTriple<V> triple, T ... expectedValues) {
        assert (triple != null) : "Zero set is null";
        PrismAsserts.assertTripleSet("zero set", triple.getZeroSet(), expectedValues);
    }

    public static <T, V extends PrismValue> void assertTripleMinus(PrismValueDeltaSetTriple<V> triple, T ... expectedValues) {
        assert (triple != null) : "Minus set is null";
        PrismAsserts.assertTripleSet("minus set", triple.getMinusSet(), expectedValues);
    }

    public static <T, V extends PrismValue> void assertTripleSet(String setName, Collection<V> tripleSet, T ... expectedValues) {
        assert (tripleSet.size() == expectedValues.length) : "Unexpected number of elements in triple " + setName + ", expected " + expectedValues.length + ", was " + tripleSet.size();
        T[] TArray = expectedValues;
        int n = expectedValues.length;
        int n2 = 0;
        while (n2 < n) {
            T expectedValue = TArray[n2];
            boolean found = false;
            for (PrismValue tval : tripleSet) {
                if (tval instanceof PrismPropertyValue) {
                    PrismPropertyValue pval = (PrismPropertyValue)tval;
                    if (!expectedValue.equals(pval.getValue())) continue;
                    found = true;
                    break;
                }
                throw new IllegalArgumentException("Unknown type of prism value " + tval);
            }
            if (!found) assert (false) : "Expected value '" + expectedValue + "' was not found in triple " + setName + "; values :" + tripleSet;
            ++n2;
        }
    }

    public static <V extends PrismValue> void assertTripleNoPlus(PrismValueDeltaSetTriple<V> triple) {
        PrismAsserts.assertTripleNoSet("plus set", triple.getPlusSet());
    }

    public static <V extends PrismValue> void assertTripleNoZero(PrismValueDeltaSetTriple<V> triple) {
        PrismAsserts.assertTripleNoSet("zero set", triple.getZeroSet());
    }

    public static <V extends PrismValue> void assertTripleNoMinus(PrismValueDeltaSetTriple<V> triple) {
        PrismAsserts.assertTripleNoSet("minus set", triple.getMinusSet());
    }

    public static <V extends PrismValue> void assertTripleNoSet(String setName, Collection<V> set) {
        assert (set == null || set.isEmpty()) : "Expected triple " + setName + " to be empty, but it was: " + set;
    }

    public static void assertEquals(String message, PolyString expected, PolyString actual) {
        assert (expected.equals(actual)) : String.valueOf(message) + "; expected " + DebugUtil.dump((Dumpable)expected) + ", was " + DebugUtil.dump((Dumpable)actual);
    }

    public static void assertEqualsPolyString(String message, String expectedOrig, PolyString actual) {
        PolyString expected = new PolyString(expectedOrig);
        expected.recompute(PrismTestUtil.getPrismContext().getDefaultPolyStringNormalizer());
        PrismAsserts.assertEquals(message, expected, actual);
    }

    public static void assertEqualsPolyString(String message, String expectedOrig, PolyStringType actual) {
        assert (actual != null) : String.valueOf(message) + ": null value";
        assert (MiscUtil.equals((Object)expectedOrig, (Object)actual.getOrig())) : String.valueOf(message) + "; expected orig " + expectedOrig + " but was " + actual.getOrig();
        PolyString expected = new PolyString(expectedOrig);
        expected.recompute(PrismTestUtil.getPrismContext().getDefaultPolyStringNormalizer());
        assert (MiscUtil.equals((Object)expected.getNorm(), (Object)actual.getNorm())) : String.valueOf(message) + "; expected norm " + expected.getNorm() + " but was " + actual.getNorm();
    }

    public static void assertEqualsPolyString(String message, PolyStringType expected, PolyStringType actual) {
        assert (actual != null) : String.valueOf(message) + ": null value";
        assert (MiscUtil.equals((Object)expected.getOrig(), (Object)actual.getOrig())) : String.valueOf(message) + "; expected orig " + expected.getOrig() + " but was " + actual.getOrig();
        assert (MiscUtil.equals((Object)expected.getNorm(), (Object)actual.getNorm())) : String.valueOf(message) + "; expected norm " + expected.getNorm() + " but was " + actual.getNorm();
    }

    public static void assertEquals(String message, XMLGregorianCalendar expected, Object actual) {
        if (actual instanceof XMLGregorianCalendar) {
            XMLGregorianCalendar actualXmlCal = (XMLGregorianCalendar)actual;
            PrismAsserts.assertEquals(message, XmlTypeConverter.toMillis(expected), (Object)XmlTypeConverter.toMillis(actualXmlCal));
        } else assert (false) : String.valueOf(message) + ": expected instance of XMLGregorianCalendar but got " + actual.getClass().getName();
    }

    public static void assertElementsEquals(Object expected, Object actual) throws SchemaException {
        PrismAsserts.assertEquals(PrismAsserts.elementToPrism(expected), PrismAsserts.elementToPrism(actual));
    }

    public static void assertEquals(File fileNewXml, String objectString) throws SchemaException {
        PrismAsserts.assertEquals(PrismAsserts.toPrism(fileNewXml), PrismAsserts.toPrism(objectString));
    }

    public static void assertEquals(Objectable expected, Objectable actual) throws SchemaException {
        PrismAsserts.assertEquals(actual.asPrismObject(), actual.asPrismObject());
    }

    public static void assertEquals(File fileNewXml, Objectable objectable) throws SchemaException {
        PrismAsserts.assertEquals(PrismAsserts.toPrism(fileNewXml), objectable.asPrismObject());
    }

    public static void assertEquals(File fileNewXml, PrismObject<?> actual) throws SchemaException {
        PrismAsserts.assertEquals(PrismAsserts.toPrism(fileNewXml), actual);
    }

    public static void assertEquals(PrismObject<?> prism1, PrismObject<?> prism2) {
        if (prism1 == null) {
            PrismAsserts.fail("Left prism is null");
        }
        if (prism2 == null) {
            PrismAsserts.fail("Right prism is null");
        }
        PrismAsserts.assertEquals(null, prism1, prism2);
    }

    public static void assertEquals(String message, PrismObject expected, PrismObject actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null) {
            PrismAsserts.fail(String.valueOf(message) + ": expected null, was " + actual);
        }
        if (actual == null) {
            PrismAsserts.fail(String.valueOf(message) + ": expected " + expected + ", was null");
        }
        if (expected.equals(actual)) {
            return;
        }
        if (message == null) {
            message = "Prism object not equal";
        }
        ObjectDelta delta = expected.diff(actual);
        String suffix = "the difference: " + delta;
        if (delta.isEmpty()) {
            suffix = String.valueOf(suffix) + ": Empty delta. The difference is most likely in meta-data";
        }
        LOGGER.error("ASSERT: {}: {} and {} not equals, delta:\n{}", new Object[]{message, expected, actual, delta.dump()});
        assert (false) : String.valueOf(message) + ": " + suffix;
    }

    public static void assertEquivalent(String message, File expectedFile, PrismObject actual) throws SchemaException {
        PrismAsserts.assertEquivalent(message, PrismAsserts.toPrism(expectedFile), actual);
    }

    public static void assertEquivalent(String message, PrismObject expected, PrismObject actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null) {
            PrismAsserts.fail(String.valueOf(message) + ": expected null, was " + actual);
        }
        if (actual == null) {
            PrismAsserts.fail(String.valueOf(message) + ": expected " + expected + ", was null");
        }
        if (expected.equivalent(actual)) {
            return;
        }
        if (message == null) {
            message = "Prism object not equal";
        }
        ObjectDelta delta = expected.diff(actual);
        String suffix = "the difference: " + delta;
        if (delta.isEmpty()) {
            suffix = String.valueOf(suffix) + ": Empty delta. This is not expected. Somethig has got quite wrong here.";
        }
        LOGGER.error("ASSERT: {}: {} and {} not equivalent, delta:\n{}", new Object[]{message, expected, actual, delta.dump()});
        assert (false) : String.valueOf(message) + ": " + suffix;
    }

    private static <T> void assertSet(String inMessage, Collection<PrismPropertyValue<T>> actualPValues, T[] expectedValues) {
        PrismAsserts.assertNotNull("Null value set in " + inMessage, actualPValues);
        PrismAsserts.assertEquals("Wrong number of values in " + inMessage, expectedValues.length, (Object)actualPValues.size());
        for (PrismPropertyValue<T> actualPValue : actualPValues) {
            boolean found = false;
            T[] TArray = expectedValues;
            int n = expectedValues.length;
            int n2 = 0;
            while (n2 < n) {
                T value = TArray[n2];
                if (value.equals(actualPValue.getValue())) {
                    found = true;
                }
                ++n2;
            }
            if (found) continue;
            PrismAsserts.fail("Unexpected value " + actualPValue + " in " + inMessage);
        }
    }

    private static PrismObject<?> toPrism(String objectString) throws SchemaException {
        return PrismAsserts.getDomProcessor().parseObject(objectString);
    }

    private static PrismObject<?> toPrism(File objectFile) throws SchemaException {
        return PrismAsserts.getDomProcessor().parseObject(objectFile);
    }

    private static PrismObject<?> toPrism(Node domNode) throws SchemaException {
        return PrismAsserts.getDomProcessor().parseObject(domNode);
    }

    private static PrismObject<?> elementToPrism(Object element) throws SchemaException {
        if (element instanceof Node) {
            return PrismAsserts.toPrism((Node)element);
        }
        if (element instanceof JAXBElement) {
            JAXBElement jaxbElement = (JAXBElement)element;
            Object value = jaxbElement.getValue();
            if (value instanceof Objectable) {
                return ((Objectable)value).asPrismObject();
            }
            throw new IllegalArgumentException("Unknown JAXB element value " + value);
        }
        throw new IllegalArgumentException("Unknown element type " + element);
    }

    private static PrismDomProcessor getDomProcessor() {
        return PrismTestUtil.getPrismContext().getPrismDomProcessor();
    }

    private static PrismJaxbProcessor getJaxbProcessor() {
        return PrismTestUtil.getPrismContext().getPrismJaxbProcessor();
    }

    static void assertNotNull(String string, Object object) {
        assert (object != null) : string;
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        assert (expected.equals(actual)) : String.valueOf(message) + ": expected (" + expected.getClass().getSimpleName() + ")" + expected + ", was (" + actual.getClass().getSimpleName() + ")" + actual;
    }

    static void assertSame(String message, Object expected, Object actual) {
        assert (expected == actual) : String.valueOf(message) + ": expected (" + expected.getClass().getSimpleName() + ")" + expected + ", was (" + actual.getClass().getSimpleName() + ")" + actual;
    }

    static void fail(String message) {
        assert (false) : message;
    }

    private static boolean equals(Object a, Object b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.equals(b);
    }
}

