/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.schema;

import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.Definition;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.prism.schema.SchemaDescription;
import com.evolveum.midpoint.prism.xml.DynamicNamespacePrefixMapper;
import com.evolveum.midpoint.util.ClassPathUtil;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.Dumpable;
import com.evolveum.midpoint.util.JAXBUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.xml.resolver.Catalog;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.springframework.beans.factory.annotation.Autowired;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaRegistry
implements LSResourceResolver,
EntityResolver,
Dumpable {
    private static final QName DEFAULT_XSD_TYPE = DOMUtil.XSD_STRING;
    private SchemaFactory schemaFactory;
    private Schema javaxSchema;
    private EntityResolver builtinSchemaResolver;
    private List<SchemaDescription> schemaDescriptions = new ArrayList<SchemaDescription>();
    private Map<String, SchemaDescription> parsedSchemas = new HashMap<String, SchemaDescription>();
    private Map<QName, ComplexTypeDefinition> extensionSchemas = new HashMap<QName, ComplexTypeDefinition>();
    private PrismSchema objectSchema = null;
    private boolean initialized = false;
    private String objectSchemaNamespace;
    private DynamicNamespacePrefixMapper namespacePrefixMapper;
    @Autowired(required=true)
    private PrismContext prismContext;
    private static final Trace LOGGER = TraceManager.getTrace(SchemaRegistry.class);

    public String getObjectSchemaNamespace() {
        return this.objectSchemaNamespace;
    }

    public void setObjectSchemaNamespace(String objectSchemaNamespace) {
        this.objectSchemaNamespace = objectSchemaNamespace;
    }

    public DynamicNamespacePrefixMapper getNamespacePrefixMapper() {
        return this.namespacePrefixMapper;
    }

    public void setNamespacePrefixMapper(DynamicNamespacePrefixMapper namespacePrefixMapper) {
        this.namespacePrefixMapper = namespacePrefixMapper;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public EntityResolver getBuiltinSchemaResolver() {
        return this.builtinSchemaResolver;
    }

    public void setBuiltinSchemaResolver(EntityResolver builtinSchemaResolver) {
        this.builtinSchemaResolver = builtinSchemaResolver;
    }

    public void registerSchemaResource(String resourcePath, String usualPrefix) throws SchemaException {
        SchemaDescription desc = SchemaDescription.parseResource(resourcePath);
        desc.setUsualPrefix(usualPrefix);
        this.registerSchemaDescription(desc);
    }

    public void registerPrismSchemaResource(String resourcePath, String usualPrefix) throws SchemaException {
        SchemaDescription desc = SchemaDescription.parseResource(resourcePath);
        desc.setUsualPrefix(usualPrefix);
        desc.setPrismSchema(true);
        this.registerSchemaDescription(desc);
    }

    public void registerPrismSchemaResource(String resourcePath, String usualPrefix, Package compileTimeClassesPackage) throws SchemaException {
        this.registerPrismSchemaResource(resourcePath, usualPrefix, compileTimeClassesPackage, false);
    }

    public void registerPrismDefaultSchemaResource(String resourcePath, String usualPrefix, Package compileTimeClassesPackage) throws SchemaException {
        this.registerPrismSchemaResource(resourcePath, usualPrefix, compileTimeClassesPackage, true);
    }

    public void registerPrismSchemaResource(String resourcePath, String usualPrefix, Package compileTimeClassesPackage, boolean defaultSchema) throws SchemaException {
        SchemaDescription desc = SchemaDescription.parseResource(resourcePath);
        desc.setUsualPrefix(usualPrefix);
        desc.setPrismSchema(true);
        desc.setDefault(defaultSchema);
        desc.setCompileTimeClassesPackage(compileTimeClassesPackage);
        this.registerSchemaDescription(desc);
    }

    public void registerSchema(Node node, String sourceDescription) throws SchemaException {
        SchemaDescription desc = SchemaDescription.parseNode(node, sourceDescription);
        this.registerSchemaDescription(desc);
    }

    public void registerSchema(Node node, String sourceDescription, String usualPrefix) throws SchemaException {
        SchemaDescription desc = SchemaDescription.parseNode(node, sourceDescription);
        desc.setUsualPrefix(usualPrefix);
        this.registerSchemaDescription(desc);
    }

    public void registerPrismSchemaFile(File file) throws FileNotFoundException, SchemaException {
        this.loadPrismSchemaFileDescription(file);
    }

    public SchemaDescription loadPrismSchemaFileDescription(File file) throws FileNotFoundException, SchemaException {
        SchemaDescription desc = SchemaDescription.parseFile(file);
        desc.setPrismSchema(true);
        this.registerSchemaDescription(desc);
        return desc;
    }

    private void registerSchemaDescription(SchemaDescription desc) {
        if (desc.getUsualPrefix() != null) {
            this.namespacePrefixMapper.registerPrefix(desc.getNamespace(), desc.getUsualPrefix(), desc.isDefault());
        }
        this.parsedSchemas.put(desc.getNamespace(), desc);
        this.schemaDescriptions.add(desc);
    }

    public void registerPrismSchemasFromDirectory(File directory) throws FileNotFoundException, SchemaException {
        List<File> files = Arrays.asList(directory.listFiles());
        Collections.sort(files);
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            if (file.isDirectory()) {
                this.registerPrismSchemasFromDirectory(file);
            }
            if (!file.isFile()) continue;
            this.registerPrismSchemaFile(file);
        }
    }

    public void loadPrismSchemasFromDirectory(File directory) throws FileNotFoundException, SchemaException {
        List<File> files = Arrays.asList(directory.listFiles());
        Collections.sort(files);
        for (File file : files) {
            if (file.getName().startsWith(".")) continue;
            if (file.isDirectory()) {
                this.loadPrismSchemasFromDirectory(file);
            }
            if (!file.isFile()) continue;
            this.loadPrismSchemaFile(file);
        }
    }

    public void loadPrismSchemaFile(File file) throws FileNotFoundException, SchemaException {
        SchemaDescription desc = this.loadPrismSchemaFileDescription(file);
        this.parsePrismSchema(desc);
    }

    public void initialize() throws SAXException, IOException, SchemaException {
        if (this.prismContext == null) {
            throw new IllegalStateException("Prism context not set");
        }
        if (this.namespacePrefixMapper == null) {
            throw new IllegalStateException("Namespace prefix mapper not set");
        }
        try {
            this.initResolver();
            this.parsePrismSchemas();
            this.parseJavaxSchema();
            this.compileCompileTimeClassList();
            this.initialized = true;
        }
        catch (SAXException ex) {
            if (ex instanceof SAXParseException) {
                SAXParseException sex = (SAXParseException)ex;
                throw new SchemaException("Error parsing schema " + sex.getSystemId() + " line " + sex.getLineNumber() + ": " + sex.getMessage());
            }
            throw ex;
        }
    }

    private void parseJavaxSchema() throws SAXException, IOException {
        this.schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Source[] sources = new Source[this.schemaDescriptions.size()];
        int i = 0;
        for (SchemaDescription schemaDescription : this.schemaDescriptions) {
            Source source;
            sources[i] = source = schemaDescription.getSource();
            ++i;
        }
        this.schemaFactory.setResourceResolver(this);
        this.javaxSchema = this.schemaFactory.newSchema(sources);
    }

    private void parsePrismSchemas() throws SchemaException {
        for (SchemaDescription schemaDescription : this.schemaDescriptions) {
            if (!schemaDescription.isPrismSchema()) continue;
            this.parsePrismSchema(schemaDescription);
        }
    }

    private void parsePrismSchema(SchemaDescription schemaDescription) throws SchemaException {
        String namespace = schemaDescription.getNamespace();
        Element domElement = schemaDescription.getDomElement();
        PrismSchema schema = PrismSchema.parse(domElement, this, schemaDescription.getSourceDescription(), this.getPrismContext());
        if (namespace == null) {
            namespace = schema.getNamespace();
        }
        LOGGER.trace("Parsed schema {}, namespace: {}", (Object)schemaDescription.getSourceDescription(), (Object)namespace);
        schemaDescription.setSchema(schema);
        this.detectExtensionSchema(schema);
    }

    private void detectExtensionSchema(PrismSchema schema) throws SchemaException {
        for (ComplexTypeDefinition def : schema.getDefinitions(ComplexTypeDefinition.class)) {
            QName extType = def.getExtensionForType();
            if (extType == null) continue;
            if (this.extensionSchemas.containsKey(extType)) {
                throw new SchemaException("Duplicate definition of extension for type " + extType + ": " + def + " and " + this.extensionSchemas.get(extType));
            }
            this.extensionSchemas.put(extType, def);
        }
    }

    private void compileCompileTimeClassList() {
        for (SchemaDescription schemaDescription : this.schemaDescriptions) {
            Package pkg = schemaDescription.getCompileTimeClassesPackage();
            if (pkg == null) continue;
            Map<QName, Class<?>> map = this.createXsdTypeMap(pkg);
            schemaDescription.setXsdTypeTocompileTimeClassMap(map);
        }
    }

    private void initResolver() throws IOException {
        CatalogManager catalogManager = new CatalogManager();
        catalogManager.setUseStaticCatalog(true);
        catalogManager.setIgnoreMissingProperties(true);
        catalogManager.setVerbosity(1);
        catalogManager.setPreferPublic(true);
        CatalogResolver catalogResolver = new CatalogResolver(catalogManager);
        Catalog catalog = catalogResolver.getCatalog();
        Enumeration<URL> catalogs = Thread.currentThread().getContextClassLoader().getResources("META-INF/catalog.xml");
        while (catalogs.hasMoreElements()) {
            URL catalogURL = catalogs.nextElement();
            catalog.parseCatalog(catalogURL);
        }
        this.builtinSchemaResolver = catalogResolver;
    }

    public Schema getJavaxSchema() {
        return this.javaxSchema;
    }

    public PrismSchema getSchema(String namespace) {
        return this.parsedSchemas.get(namespace).getSchema();
    }

    public PrismSchema getObjectSchema() {
        if (!this.initialized) {
            throw new IllegalStateException("Attempt to get common schema from uninitialized Schema Registry");
        }
        if (this.objectSchema == null) {
            this.initializeObjectSchema();
        }
        return this.objectSchema;
    }

    private void initializeObjectSchema() {
        if (this.objectSchemaNamespace == null) {
            throw new IllegalArgumentException("Object schema namespace is not set");
        }
        PrismSchema commonSchema = this.parsedSchemas.get(this.objectSchemaNamespace).getSchema();
        this.objectSchema = new PrismSchema(this.objectSchemaNamespace, this.prismContext);
        for (Definition def : commonSchema.getDefinitions()) {
            QName typeName;
            if (def instanceof PrismObjectDefinition && this.extensionSchemas.containsKey(typeName = def.getTypeName())) {
                LOGGER.trace("Applying extension type for {}: {}", (Object)typeName, (Object)this.extensionSchemas.get(typeName));
                PrismObjectDefinition objDef = (PrismObjectDefinition)def;
                PrismContainerDefinition enhDef = objDef.clone();
                ((PrismObjectDefinition)enhDef).setExtensionDefinition(this.extensionSchemas.get(typeName));
                def = enhDef;
                LOGGER.trace("Resuting object type def:\n{}", (Object)enhDef.dump());
            }
            this.objectSchema.getDefinitions().add(def);
        }
    }

    public Collection<Package> getCompileTimePackages() {
        ArrayList<Package> compileTimePackages = new ArrayList<Package>(this.schemaDescriptions.size());
        for (SchemaDescription desc : this.schemaDescriptions) {
            if (desc.getCompileTimeClassesPackage() == null) continue;
            compileTimePackages.add(desc.getCompileTimeClassesPackage());
        }
        return compileTimePackages;
    }

    private Map<QName, Class<?>> createXsdTypeMap(Package pkg) {
        HashMap map = new HashMap();
        for (Class clazz : ClassPathUtil.listClasses((Package)pkg)) {
            QName typeName = JAXBUtil.getTypeQName((Class)clazz);
            if (typeName == null) continue;
            map.put(typeName, clazz);
        }
        return map;
    }

    private SchemaDescription lookupSchemaDescription(String namespace) {
        for (SchemaDescription desc : this.schemaDescriptions) {
            if (!namespace.equals(desc.getNamespace())) continue;
            return desc;
        }
        return null;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource inputSource = this.resolveResourceFromRegisteredSchemas(null, publicId, publicId, systemId, null);
        if (inputSource == null) {
            inputSource = this.resolveResourceUsingBuiltinResolver(null, null, publicId, systemId, null);
        }
        if (inputSource == null) {
            LOGGER.error("Unable to resolve resource with publicID: {}, systemID: {}", new Object[]{publicId, systemId});
            return null;
        }
        LOGGER.trace("Resolved resource with publicID: {}, systemID: {} : {}", new Object[]{publicId, systemId, inputSource});
        return inputSource;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputSource inputSource = this.resolveResourceFromRegisteredSchemas(type, namespaceURI, publicId, systemId, baseURI);
        if (inputSource == null) {
            inputSource = this.resolveResourceUsingBuiltinResolver(type, namespaceURI, publicId, systemId, baseURI);
        }
        if (inputSource == null) {
            LOGGER.error("Unable to resolve resource of type {}, namespaceURI: {}, publicID: {}, systemID: {}, baseURI: {}", new Object[]{type, namespaceURI, publicId, systemId, baseURI});
            return null;
        }
        LOGGER.trace("Resolved resource of type {}, namespaceURI: {}, publicID: {}, systemID: {}, baseURI: {} : {}", new Object[]{type, namespaceURI, publicId, systemId, baseURI, inputSource});
        return new Input(publicId, systemId, inputSource.getByteStream());
    }

    private InputSource resolveResourceFromRegisteredSchemas(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputSource source = this.resolveResourceFromRegisteredSchemasByNamespace(namespaceURI);
        if (source == null) {
            source = this.resolveResourceFromRegisteredSchemasByNamespace(publicId);
        }
        if (source == null) {
            source = this.resolveResourceFromRegisteredSchemasByNamespace(systemId);
        }
        return source;
    }

    private InputSource resolveResourceFromRegisteredSchemasByNamespace(String namespaceURI) {
        if (namespaceURI != null && this.parsedSchemas.containsKey(namespaceURI)) {
            SchemaDescription schemaDescription = this.parsedSchemas.get(namespaceURI);
            if (schemaDescription.canInputStream()) {
                InputStream inputStream = schemaDescription.openInputStream();
                InputSource source = new InputSource();
                source.setByteStream(inputStream);
                source.setSystemId(namespaceURI);
                source.setPublicId(namespaceURI);
                return source;
            }
            throw new IllegalStateException("Requested resolution of schema " + schemaDescription.getSourceDescription() + " that does not support input stream");
        }
        return null;
    }

    public InputSource resolveResourceUsingBuiltinResolver(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        InputSource inputSource = null;
        try {
            inputSource = namespaceURI != null ? this.builtinSchemaResolver.resolveEntity(publicId, namespaceURI) : this.builtinSchemaResolver.resolveEntity(publicId, systemId);
        }
        catch (SAXException e) {
            LOGGER.error("XML parser error resolving reference of type {}, namespaceURI: {}, publicID: {}, systemID: {}, baseURI: {}: {}", new Object[]{type, namespaceURI, publicId, systemId, baseURI, e.getMessage(), e});
            return null;
        }
        catch (IOException e) {
            LOGGER.error("IO error resolving reference of type {}, namespaceURI: {}, publicID: {}, systemID: {}, baseURI: {}: {}", new Object[]{type, namespaceURI, publicId, systemId, baseURI, e.getMessage(), e});
            return null;
        }
        return inputSource;
    }

    public String dump() {
        StringBuilder sb = new StringBuilder("SchemaRegistry:");
        sb.append("  Parsed Schemas:\n");
        for (String namespace : this.parsedSchemas.keySet()) {
            sb.append("    ");
            sb.append(namespace);
            sb.append(": ");
            sb.append(this.parsedSchemas.get(namespace).dump());
            sb.append("\n");
        }
        return sb.toString();
    }

    public Class<?> determineCompileTimeClass(QName elementName, ComplexTypeDefinition complexTypeDefinition) {
        return this.determineCompileTimeClass(complexTypeDefinition.getTypeName());
    }

    public Class<?> determineCompileTimeClass(ComplexTypeDefinition complexTypeDefinition) {
        return this.determineCompileTimeClass(complexTypeDefinition.getTypeName());
    }

    public Class<?> determineCompileTimeClass(QName typeName) {
        if (typeName.getNamespaceURI() == null) {
            throw new IllegalArgumentException("XSD type " + typeName + " has no namespace, cannot determine schema");
        }
        SchemaDescription desc = this.findSchemaDescriptionByNamespace(typeName.getNamespaceURI());
        if (desc == null) {
            return null;
        }
        Package pkg = desc.getCompileTimeClassesPackage();
        if (pkg == null) {
            return null;
        }
        Class compileTimeClass = JAXBUtil.findClassForType((QName)typeName, (Package)pkg);
        return compileTimeClass;
    }

    public PrismSchema findSchemaByCompileTimeClass(Class<? extends Objectable> compileTimeClass) {
        Package compileTimePackage = compileTimeClass.getPackage();
        for (SchemaDescription desc : this.schemaDescriptions) {
            if (!compileTimePackage.equals(desc.getCompileTimeClassesPackage())) continue;
            PrismSchema schema = desc.getSchema();
            if (schema.getNamespace().equals(this.objectSchemaNamespace)) {
                return this.getObjectSchema();
            }
            return schema;
        }
        return null;
    }

    public <T extends Objectable> PrismObjectDefinition<T> findObjectDefinitionByCompileTimeClass(Class<T> compileTimeClass) {
        PrismSchema schema = this.findSchemaByCompileTimeClass(compileTimeClass);
        if (schema == null) {
            return null;
        }
        return schema.findObjectDefinitionByCompileTimeClass(compileTimeClass);
    }

    public void applyDefinition(PrismObject<? extends Objectable> prismObject, Class<? extends Objectable> type) throws SchemaException {
        this.applyDefinition(prismObject, type, true);
    }

    public void applyDefinition(PrismObject<? extends Objectable> prismObject, Class<? extends Objectable> type, boolean force) throws SchemaException {
        PrismObjectDefinition objectDefinition = this.determineDefinitionFromClass(type);
        prismObject.applyDefinition(objectDefinition, force);
    }

    public <T extends Objectable> PrismObjectDefinition<T> findObjectDefinitionByType(QName typeName) {
        PrismSchema schema = this.findSchemaByNamespace(typeName.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.findObjectDefinitionByType(typeName);
    }

    public <T extends Objectable> PrismObjectDefinition<T> findObjectDefinitionByElementName(QName elementName) {
        PrismSchema schema = this.findSchemaByNamespace(elementName.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.findObjectDefinitionByElementName(elementName);
    }

    public PrismContainerDefinition findContainerDefinitionByType(QName typeName) {
        PrismSchema schema = this.findSchemaByNamespace(typeName.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.findContainerDefinitionByType(typeName);
    }

    public PrismContainerDefinition findContainerDefinitionByElementName(QName elementName) {
        PrismSchema schema = this.findSchemaByNamespace(elementName.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.findContainerDefinitionByElementName(elementName);
    }

    public ItemDefinition findItemDefinitionByElementName(QName elementName) {
        PrismSchema schema = this.findSchemaByNamespace(elementName.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.findItemDefinition(elementName, ItemDefinition.class);
    }

    public PrismPropertyDefinition findPropertyDefinitionByElementName(QName elementName) {
        PrismSchema schema = this.findSchemaByNamespace(elementName.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.findPropertyDefinitionByElementName(elementName);
    }

    public ComplexTypeDefinition findComplexTypeDefinition(QName typeName) {
        PrismSchema schema = this.findSchemaByNamespace(typeName.getNamespaceURI());
        if (schema == null) {
            return null;
        }
        return schema.findComplexTypeDefinition(typeName);
    }

    public PrismSchema findSchemaByNamespace(String namespaceURI) {
        if (namespaceURI.equals(this.objectSchemaNamespace)) {
            return this.getObjectSchema();
        }
        SchemaDescription desc = this.findSchemaDescriptionByNamespace(namespaceURI);
        if (desc == null) {
            return null;
        }
        return desc.getSchema();
    }

    public SchemaDescription findSchemaDescriptionByNamespace(String namespaceURI) {
        for (SchemaDescription desc : this.schemaDescriptions) {
            if (!namespaceURI.equals(desc.getNamespace())) continue;
            return desc;
        }
        return null;
    }

    public PrismObjectDefinition determineDefinitionFromClass(Class type) {
        PrismObjectDefinition def = this.findObjectDefinitionByCompileTimeClass(type);
        if (def != null) {
            return def;
        }
        Class superclass = type.getSuperclass();
        if (superclass == Object.class) {
            return null;
        }
        return this.determineDefinitionFromClass(superclass);
    }

    public boolean hasImplicitTypeDefinition(QName elementName, QName typeName) {
        PrismSchema schema = this.findSchemaByNamespace(elementName.getNamespaceURI());
        ItemDefinition itemDefinition = schema.findItemDefinition(elementName, ItemDefinition.class);
        if (itemDefinition == null) {
            return false;
        }
        return typeName.equals(itemDefinition.getTypeName());
    }

    public static ItemDefinition createDefaultItemDefinition(QName itemName, PrismContext prismContext) {
        PrismPropertyDefinition propDef = new PrismPropertyDefinition(itemName, itemName, DEFAULT_XSD_TYPE, prismContext);
        propDef.setMaxOccurs(-1);
        propDef.setDynamic(true);
        return propDef;
    }

    public ItemDefinition resolveGlobalItemDefinition(QName elementQName) throws SchemaException {
        String elementNamespace = elementQName.getNamespaceURI();
        if (elementNamespace == null) {
            return null;
        }
        PrismSchema schema = this.findSchemaByNamespace(elementNamespace);
        if (schema == null) {
            return null;
        }
        ItemDefinition itemDefinition = schema.findItemDefinition(elementQName, ItemDefinition.class);
        if (itemDefinition == null) {
            throw new SchemaException("No definition for item " + elementQName + " (schema for the namespace is present)");
        }
        return itemDefinition;
    }

    public <T extends Objectable> PrismObject<T> instantiate(Class<T> compileTimeClass) throws SchemaException {
        PrismObjectDefinition<T> objDef = this.findObjectDefinitionByCompileTimeClass(compileTimeClass);
        if (objDef == null) {
            throw new SchemaException("No definition for compile time class " + compileTimeClass);
        }
        return objDef.instantiate();
    }

    class Input
    implements LSInput {
        private String publicId;
        private String systemId;
        private BufferedInputStream inputStream;

        @Override
        public String getPublicId() {
            return this.publicId;
        }

        @Override
        public void setPublicId(String publicId) {
            this.publicId = publicId;
        }

        @Override
        public String getBaseURI() {
            return null;
        }

        @Override
        public InputStream getByteStream() {
            return null;
        }

        @Override
        public boolean getCertifiedText() {
            return false;
        }

        @Override
        public Reader getCharacterStream() {
            return null;
        }

        @Override
        public String getEncoding() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String getStringData() {
            BufferedInputStream bufferedInputStream = this.inputStream;
            synchronized (bufferedInputStream) {
                try {
                    byte[] input = new byte[this.inputStream.available()];
                    this.inputStream.read(input);
                    String contents = new String(input);
                    return contents;
                }
                catch (IOException e) {
                    LOGGER.error("IO error creating LSInput for publicID: {}, systemID: {}: {}", new Object[]{this.publicId, this.systemId, e.getMessage(), e});
                    return null;
                }
            }
        }

        @Override
        public void setBaseURI(String baseURI) {
        }

        @Override
        public void setByteStream(InputStream byteStream) {
        }

        @Override
        public void setCertifiedText(boolean certifiedText) {
        }

        @Override
        public void setCharacterStream(Reader characterStream) {
        }

        @Override
        public void setEncoding(String encoding) {
        }

        @Override
        public void setStringData(String stringData) {
        }

        @Override
        public String getSystemId() {
            return this.systemId;
        }

        @Override
        public void setSystemId(String systemId) {
            this.systemId = systemId;
        }

        public BufferedInputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(BufferedInputStream inputStream) {
            this.inputStream = inputStream;
        }

        public Input(String publicId, String sysId, InputStream input) {
            this.publicId = publicId;
            this.systemId = sysId;
            this.inputStream = new BufferedInputStream(input);
        }
    }
}

