/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.schema;

import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismConstants;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.prism.schema.SchemaDefinitionFactory;
import com.evolveum.midpoint.prism.schema.SchemaHandler;
import com.evolveum.midpoint.prism.schema.SchemaProcessorUtil;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSTerm;
import com.sun.xml.xsom.XSType;
import com.sun.xml.xsom.parser.AnnotationParserFactory;
import com.sun.xml.xsom.parser.XSOMParser;
import com.sun.xml.xsom.util.DomAnnotationParserFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DomToSchemaProcessor {
    private static final Trace LOGGER = TraceManager.getTrace(DomToSchemaProcessor.class);
    private PrismSchema schema;
    private EntityResolver entityResolver;
    private PrismContext prismContext;
    private XSSchemaSet xsSchemaSet;
    private String shortDescription;

    DomToSchemaProcessor() {
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public SchemaRegistry getSchemaRegistry() {
        return this.prismContext.getSchemaRegistry();
    }

    private SchemaDefinitionFactory getDefinitionFactory() {
        return this.prismContext.getDefinitionFactory();
    }

    private String getNamespace() {
        return this.schema.getNamespace();
    }

    private boolean isMyNamespace(QName qname) {
        return this.getNamespace().equals(qname.getNamespaceURI());
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    PrismSchema parseDom(PrismSchema prismSchema, Element xsdSchema) throws SchemaException {
        Validate.notNull((Object)xsdSchema, (String)"XSD schema element must not be null.");
        this.schema = prismSchema;
        this.initSchema(xsdSchema);
        this.xsSchemaSet = this.parseSchema(xsdSchema);
        if (this.xsSchemaSet == null) {
            return this.schema;
        }
        this.processComplexTypeDefinitions(this.xsSchemaSet);
        this.createDefinitionsFromElements(this.xsSchemaSet);
        return this.schema;
    }

    private void initSchema(Element xsdSchema) throws SchemaException {
        String targetNamespace = xsdSchema.getAttributeNS(DOMUtil.XSD_ATTR_TARGET_NAMESPACE.getNamespaceURI(), DOMUtil.XSD_ATTR_TARGET_NAMESPACE.getLocalPart());
        if (StringUtils.isEmpty((String)targetNamespace)) {
            targetNamespace = xsdSchema.getAttribute(DOMUtil.XSD_ATTR_TARGET_NAMESPACE.getLocalPart());
        }
        if (StringUtils.isEmpty((String)targetNamespace)) {
            throw new SchemaException("Schema does not have targetNamespace specification");
        }
        this.schema.setNamespace(targetNamespace);
    }

    private XSSchemaSet parseSchema(Element schema) throws SchemaException {
        DOMUtil.fixNamespaceDeclarations((Element)schema);
        XSSchemaSet xss = null;
        try {
            TransformerFactory transfac = TransformerFactory.newInstance();
            Transformer trans = transfac.newTransformer();
            trans.setOutputProperty("omit-xml-declaration", "no");
            trans.setOutputProperty("indent", "yes");
            DOMSource source = new DOMSource(schema);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(out);
            trans.transform(source, result);
            XSOMParser parser = this.createSchemaParser();
            InputSource inSource = new InputSource(new ByteArrayInputStream(out.toByteArray()));
            inSource.setSystemId("SystemId");
            inSource.setEncoding("utf-8");
            parser.parse(inSource);
            xss = parser.getResult();
        }
        catch (SAXException e) {
            throw new SchemaException("XML error during XSD schema parsing: " + e.getMessage() + "(embedded exception " + e.getException() + ") in " + this.shortDescription, (Throwable)e);
        }
        catch (TransformerException e) {
            throw new SchemaException("XML transformer error during XSD schema parsing: " + e.getMessage() + "(locator: " + e.getLocator() + ", embedded exception:" + e.getException() + ") in " + this.shortDescription, (Throwable)e);
        }
        return xss;
    }

    private XSOMParser createSchemaParser() {
        XSOMParser parser = new XSOMParser();
        if (this.entityResolver == null) {
            this.entityResolver = this.prismContext.getSchemaRegistry();
            if (this.entityResolver == null) {
                throw new IllegalStateException("Entity resolver is not set (even tried to pull it from prism context)");
            }
        }
        SchemaHandler errorHandler = new SchemaHandler(this.entityResolver);
        parser.setErrorHandler((ErrorHandler)errorHandler);
        parser.setAnnotationParser((AnnotationParserFactory)new DomAnnotationParserFactory());
        parser.setEntityResolver((EntityResolver)errorHandler);
        return parser;
    }

    private void processComplexTypeDefinitions(XSSchemaSet set) throws SchemaException {
        Iterator iterator = set.iterateComplexTypes();
        while (iterator.hasNext()) {
            XSComplexType complexType = (XSComplexType)iterator.next();
            if (!complexType.getTargetNamespace().equals(this.schema.getNamespace())) continue;
            this.processComplexTypeDefinition(complexType);
        }
    }

    private ComplexTypeDefinition processComplexTypeDefinition(XSComplexType complexType) throws SchemaException {
        ComplexTypeDefinition complexTypeDefinition = this.createComplexTypeDefinition(complexType);
        ComplexTypeDefinition existingComplexTypeDefinition = this.schema.findComplexTypeDefinition(complexTypeDefinition.getTypeName());
        if (existingComplexTypeDefinition != null) {
            return existingComplexTypeDefinition;
        }
        this.schema.getDefinitions().add(complexTypeDefinition);
        PrismContainerDefinition defFromComplexType = this.getDefinitionFactory().createExtraDefinitionFromComplexType(complexType, complexTypeDefinition, this.prismContext, complexType.getAnnotation());
        if (defFromComplexType != null) {
            this.schema.getDefinitions().add(defFromComplexType);
        }
        return complexTypeDefinition;
    }

    private ComplexTypeDefinition getOrProcessComplexType(QName typeName) throws SchemaException {
        ComplexTypeDefinition complexTypeDefinition = this.schema.findComplexTypeDefinition(typeName);
        if (complexTypeDefinition != null) {
            return complexTypeDefinition;
        }
        XSComplexType complexType = this.xsSchemaSet.getComplexType(typeName.getNamespaceURI(), typeName.getLocalPart());
        return this.processComplexTypeDefinition(complexType);
    }

    private ComplexTypeDefinition createComplexTypeDefinition(XSComplexType complexType) throws SchemaException {
        QName superType;
        SchemaDefinitionFactory definitionFactory = this.getDefinitionFactory();
        ComplexTypeDefinition ctd = definitionFactory.createComplexTypeDefinition(complexType, this.prismContext, complexType.getAnnotation());
        XSContentType content = complexType.getContentType();
        if (content != null) {
            XSAnnotation annotation;
            Element extensionAnnotationElement;
            XSTerm term;
            XSParticle particle = content.asParticle();
            if (particle != null && (term = particle.getTerm()).isModelGroup()) {
                this.addPropertyDefinitionListFromGroup(term.asModelGroup(), ctd);
            }
            if ((extensionAnnotationElement = SchemaProcessorUtil.getAnnotationElement(annotation = complexType.getAnnotation(), PrismConstants.A_EXTENSION)) != null) {
                QName extensionType = DOMUtil.getQNameAttribute((Element)extensionAnnotationElement, (String)PrismConstants.A_EXTENSION_REF.getLocalPart());
                if (extensionType == null) {
                    throw new SchemaException("The " + PrismConstants.A_EXTENSION + "annontation on " + ctd.getTypeName() + " complex type does not have " + PrismConstants.A_EXTENSION_REF.getLocalPart() + " attribute", PrismConstants.A_EXTENSION_REF);
                }
                ctd.setExtensionForType(extensionType);
            }
        }
        if ((superType = this.determineSupertype(complexType)) != null) {
            ctd.setSuperType(superType);
        }
        if (this.isObjectDefinition((XSType)complexType)) {
            ctd.setObjectMarker(true);
        }
        if (this.isPropertyContainer((XSType)complexType)) {
            ctd.setContainerMarker(true);
        }
        if (this.isAny((XSType)complexType)) {
            ctd.setXsdAnyMarker(true);
        }
        if (this.getSchemaRegistry() != null) {
            Class<?> compileTimeClass = this.getSchemaRegistry().determineCompileTimeClass(ctd);
            ctd.setCompileTimeClass(compileTimeClass);
        }
        definitionFactory.finishComplexTypeDefinition(ctd, complexType, this.prismContext, complexType.getAnnotation());
        return ctd;
    }

    private void addPropertyDefinitionListFromGroup(XSModelGroup group, ComplexTypeDefinition ctd) throws SchemaException {
        XSParticle[] particles;
        XSParticle[] xSParticleArray = particles = group.getChildren();
        int n = particles.length;
        int n2 = 0;
        while (n2 < n) {
            XSParticle p = xSParticleArray[n2];
            XSTerm pterm = p.getTerm();
            if (pterm.isModelGroup()) {
                this.addPropertyDefinitionListFromGroup(pterm.asModelGroup(), ctd);
            }
            if (pterm.isElementDecl()) {
                XSAnnotation annotation = this.selectAnnotationToUse(p.getAnnotation(), pterm.getAnnotation());
                XSElementDecl elementDecl = pterm.asElementDecl();
                QName elementName = new QName(elementDecl.getTargetNamespace(), elementDecl.getName());
                QName typeFromAnnotation = this.getTypeAnnotation(p.getAnnotation());
                XSType xsType = elementDecl.getType();
                if (this.isObjectReference(xsType, annotation)) {
                    this.processObjectReferenceDefinition(xsType, elementName, annotation, ctd, p);
                } else if (!this.isObjectDefinition(xsType)) {
                    if (xsType.getName() == null && typeFromAnnotation == null) {
                        if (this.isAny(xsType)) {
                            if (this.isPropertyContainer(elementDecl)) {
                                XSAnnotation containerAnnotation = xsType.getAnnotation();
                                PrismContainerDefinition<?> containerDefinition = this.createPropertyContainerDefinition(xsType, p, null, containerAnnotation, false);
                                ctd.getDefinitions().add(containerDefinition);
                            } else {
                                PrismPropertyDefinition propDef = this.createPropertyDefinition(xsType, elementName, DOMUtil.XSD_ANY, ctd, annotation, p);
                                ctd.getDefinitions().add(propDef);
                            }
                        }
                    } else if (this.isPropertyContainer(elementDecl)) {
                        XSComplexType complexType = (XSComplexType)xsType;
                        ComplexTypeDefinition complexTypeDefinition = null;
                        if (typeFromAnnotation != null && complexType != null && !typeFromAnnotation.equals(this.getType(xsType))) {
                            complexTypeDefinition = this.isMyNamespace(typeFromAnnotation) ? this.getOrProcessComplexType(typeFromAnnotation) : this.getPrismContext().getSchemaRegistry().findComplexTypeDefinition(typeFromAnnotation);
                            if (complexTypeDefinition == null) {
                                throw new SchemaException("Cannot find definition of complex type " + typeFromAnnotation + " as specified in type override annotation at " + elementName);
                            }
                        } else {
                            complexTypeDefinition = this.createComplexTypeDefinition(complexType);
                        }
                        XSAnnotation containerAnnotation = complexType.getAnnotation();
                        PrismContainerDefinition<?> containerDefinition = this.createPropertyContainerDefinition(xsType, p, complexTypeDefinition, containerAnnotation, false);
                        if (this.isAny(xsType)) {
                            containerDefinition.setRuntimeSchema(true);
                            containerDefinition.setDynamic(true);
                        }
                        ctd.getDefinitions().add(containerDefinition);
                    } else {
                        QName typeName = new QName(xsType.getTargetNamespace(), xsType.getName());
                        PrismPropertyDefinition propDef = this.createPropertyDefinition(xsType, elementName, typeName, ctd, annotation, p);
                        ctd.add(propDef);
                    }
                }
            }
            ++n2;
        }
    }

    private PrismReferenceDefinition processObjectReferenceDefinition(XSType xsType, QName elementName, XSAnnotation annotation, ComplexTypeDefinition ctd, XSParticle elementParticle) throws SchemaException {
        Element targetTypeAnnotationElement;
        PrismReferenceDefinition definition;
        boolean hasExplicitPrimaryElementName;
        QName typeName = new QName(xsType.getTargetNamespace(), xsType.getName());
        QName primaryElementName = elementName;
        Element objRefAnnotationElement = SchemaProcessorUtil.getAnnotationElement(annotation, PrismConstants.A_OBJECT_REFERENCE);
        boolean bl = hasExplicitPrimaryElementName = objRefAnnotationElement != null && !StringUtils.isEmpty((String)objRefAnnotationElement.getTextContent());
        if (hasExplicitPrimaryElementName) {
            primaryElementName = DOMUtil.getQNameValue((Element)objRefAnnotationElement);
        }
        if ((definition = ctd.findItemDefinition(primaryElementName, PrismReferenceDefinition.class)) == null) {
            SchemaDefinitionFactory definitionFactory = this.getDefinitionFactory();
            definition = definitionFactory.createReferenceDefinition(primaryElementName, typeName, ctd, this.prismContext, annotation, elementParticle);
            ctd.add(definition);
        }
        if (hasExplicitPrimaryElementName) {
            if (definition.getTargetTypeName() == null) {
                definition.setTargetTypeName(typeName);
            }
            if (definition.getCompositeObjectElementName() == null) {
                definition.setCompositeObjectElementName(elementName);
            }
        } else {
            definition.setTypeName(typeName);
        }
        if ((targetTypeAnnotationElement = SchemaProcessorUtil.getAnnotationElement(annotation, PrismConstants.A_OBJECT_REFERENCE_TARGET_TYPE)) != null && !StringUtils.isEmpty((String)targetTypeAnnotationElement.getTextContent())) {
            QName targetType = DOMUtil.getQNameValue((Element)targetTypeAnnotationElement);
            definition.setTargetTypeName(targetType);
        }
        this.setMultiplicity(definition, elementParticle, annotation, false);
        return definition;
    }

    private void setMultiplicity(ItemDefinition itemDef, XSParticle particle, XSAnnotation annotation, boolean topLevel) {
        if (topLevel || particle == null) {
            itemDef.setMinOccurs(0);
            Element maxOccursAnnotation = SchemaProcessorUtil.getAnnotationElement(annotation, PrismConstants.A_MAX_OCCURS);
            if (maxOccursAnnotation != null) {
                String maxOccursString = maxOccursAnnotation.getTextContent();
                int maxOccurs = Integer.parseInt(maxOccursString);
                itemDef.setMaxOccurs(maxOccurs);
            } else {
                itemDef.setMaxOccurs(-1);
            }
        } else {
            itemDef.setMinOccurs(particle.getMinOccurs());
            itemDef.setMaxOccurs(particle.getMaxOccurs());
        }
    }

    private void createDefinitionsFromElements(XSSchemaSet set) throws SchemaException {
        Iterator iterator = set.iterateElementDecls();
        while (iterator.hasNext()) {
            XSElementDecl xsElementDecl = (XSElementDecl)iterator.next();
            if (xsElementDecl.getTargetNamespace().equals(this.schema.getNamespace())) {
                QName elementName = new QName(xsElementDecl.getTargetNamespace(), xsElementDecl.getName());
                XSType xsType = xsElementDecl.getType();
                if (xsType == null) {
                    throw new SchemaException("Found element " + elementName + " without type definition");
                }
                QName typeQName = this.determineType(xsElementDecl);
                if (typeQName == null) continue;
                XSAnnotation annotation = xsType.getAnnotation();
                if (this.isPropertyContainer(xsElementDecl) || this.isObjectDefinition(xsType)) {
                    ComplexTypeDefinition complexTypeDefinition = this.schema.findComplexTypeDefinition(typeQName);
                    PrismContainerDefinition<?> propertyContainerDefinition = this.createPropertyContainerDefinition(xsType, xsElementDecl, complexTypeDefinition, annotation, null, true);
                    this.schema.getDefinitions().add(propertyContainerDefinition);
                    continue;
                }
                PrismPropertyDefinition propDef = this.createPropertyDefinition(xsType, elementName, typeQName, null, xsElementDecl.getAnnotation(), null);
                this.schema.getDefinitions().add(propDef);
                continue;
            }
            xsElementDecl.getTargetNamespace().equals("http://www.w3.org/2001/XMLSchema");
        }
    }

    private QName determineType(XSElementDecl xsElementDecl) {
        QName type = this.getTypeAnnotation(xsElementDecl);
        if (type != null) {
            return type;
        }
        XSType xsType = xsElementDecl.getType();
        if (xsType == null) {
            return null;
        }
        return this.getType(xsType);
    }

    private QName getType(XSType xsType) {
        if (xsType.getName() == null) {
            return null;
        }
        return new QName(xsType.getTargetNamespace(), xsType.getName());
    }

    private QName getTypeAnnotation(XSElementDecl xsElementDecl) {
        XSAnnotation annotation = xsElementDecl.getAnnotation();
        return this.getTypeAnnotation(annotation);
    }

    private QName getTypeAnnotation(XSAnnotation annotation) {
        return SchemaProcessorUtil.getAnnotationQName(annotation, PrismConstants.A_TYPE);
    }

    private boolean isAny(XSType xsType) {
        XSTerm term;
        XSParticle particle;
        XSComplexType complexType;
        XSContentType contentType;
        if (xsType instanceof XSComplexType && (contentType = (complexType = (XSComplexType)xsType).getContentType()) != null && (particle = contentType.asParticle()) != null && (term = particle.getTerm()) != null) {
            return this.isAny(term);
        }
        return false;
    }

    private QName determineSupertype(XSComplexType complexType) {
        XSType baseType = complexType.getBaseType();
        if (baseType == null) {
            return null;
        }
        if (baseType.getName().equals("anyType")) {
            return null;
        }
        return new QName(baseType.getTargetNamespace(), baseType.getName());
    }

    private boolean isAny(XSTerm term) {
        XSParticle[] children;
        if (term.isWildcard()) {
            return true;
        }
        if (term.isModelGroup() && (children = term.asModelGroup().getChildren()) != null) {
            XSParticle[] xSParticleArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                XSParticle childParticle = xSParticleArray[n2];
                XSTerm childTerm = childParticle.getTerm();
                if (childTerm != null && this.isAny(childTerm)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean isPropertyContainer(XSElementDecl xsElementDecl) {
        Element annoElement = SchemaProcessorUtil.getAnnotationElement(xsElementDecl.getAnnotation(), PrismConstants.A_PROPERTY_CONTAINER);
        if (annoElement != null) {
            return true;
        }
        return this.isPropertyContainer(xsElementDecl.getType());
    }

    private boolean isPropertyContainer(XSType xsType) {
        Element annoElement = SchemaProcessorUtil.getAnnotationElement(xsType.getAnnotation(), PrismConstants.A_PROPERTY_CONTAINER);
        if (annoElement != null) {
            return true;
        }
        if (xsType.getBaseType() != null && !xsType.getBaseType().equals(xsType)) {
            return this.isPropertyContainer(xsType.getBaseType());
        }
        return false;
    }

    private boolean isObjectReference(XSType xsType, XSAnnotation annotation) {
        if (this.isObjectReference(annotation)) {
            return true;
        }
        return this.isObjectReference(xsType);
    }

    private boolean isObjectReference(XSAnnotation annotation) {
        Element objRefAnnotationElement = SchemaProcessorUtil.getAnnotationElement(annotation, PrismConstants.A_OBJECT_REFERENCE);
        return objRefAnnotationElement != null;
    }

    private boolean isObjectReference(XSType xsType) {
        return SchemaProcessorUtil.hasAnnotation(xsType, PrismConstants.A_OBJECT_REFERENCE);
    }

    private boolean isObjectDefinition(XSType xsType) {
        return SchemaProcessorUtil.hasAnnotation(xsType, PrismConstants.A_OBJECT);
    }

    private PrismContainerDefinition<?> createPropertyContainerDefinition(XSType xsType, XSParticle elementParticle, ComplexTypeDefinition complexTypeDefinition, XSAnnotation annotation, boolean topLevel) throws SchemaException {
        XSTerm elementTerm = elementParticle.getTerm();
        XSElementDecl elementDecl = elementTerm.asElementDecl();
        PrismContainerDefinition<?> pcd = this.createPropertyContainerDefinition(xsType, elementDecl, complexTypeDefinition, annotation, elementParticle, topLevel);
        return pcd;
    }

    private PrismContainerDefinition<?> createPropertyContainerDefinition(XSType xsType, XSElementDecl elementDecl, ComplexTypeDefinition complexTypeDefinition, XSAnnotation complexTypeAnnotation, XSParticle elementParticle, boolean topLevel) throws SchemaException {
        QName elementName = new QName(elementDecl.getTargetNamespace(), elementDecl.getName());
        PrismContainerDefinition pcd = null;
        SchemaDefinitionFactory definitionFactory = this.getDefinitionFactory();
        if (this.isObjectDefinition(xsType)) {
            Class<?> compileTimeClass = null;
            if (this.getSchemaRegistry() != null) {
                compileTimeClass = this.getSchemaRegistry().determineCompileTimeClass(elementName, complexTypeDefinition);
            }
            pcd = definitionFactory.createObjectDefinition(elementName, complexTypeDefinition, this.prismContext, compileTimeClass, complexTypeAnnotation, elementParticle);
            pcd.setMinOccurs(1);
            pcd.setMaxOccurs(1);
        } else {
            pcd = definitionFactory.createContainerDefinition(elementName, complexTypeDefinition, this.prismContext, complexTypeAnnotation, elementParticle);
            this.setMultiplicity(pcd, elementParticle, elementDecl.getAnnotation(), topLevel);
        }
        this.parseItemDefinitionAnnotations(pcd, complexTypeAnnotation);
        this.parseItemDefinitionAnnotations(pcd, elementDecl.getAnnotation());
        if (elementParticle != null) {
            this.parseItemDefinitionAnnotations(pcd, elementParticle.getAnnotation());
        }
        return pcd;
    }

    private PrismPropertyDefinition createPropertyDefinition(XSType xsType, QName elementName, QName typeName, ComplexTypeDefinition ctd, XSAnnotation annotation, XSParticle elementParticle) throws SchemaException {
        SchemaDefinitionFactory definitionFactory = this.getDefinitionFactory();
        PrismPropertyDefinition propDef = definitionFactory.createPropertyDefinition(elementName, typeName, ctd, this.prismContext, annotation, elementParticle);
        this.setMultiplicity(propDef, elementParticle, annotation, ctd == null);
        this.parseItemDefinitionAnnotations(propDef, annotation);
        List<Element> accessElements = SchemaProcessorUtil.getAnnotationElements(annotation, PrismConstants.A_ACCESS);
        if (accessElements == null || accessElements.isEmpty()) {
            propDef.setCreate(true);
            propDef.setUpdate(true);
            propDef.setRead(true);
        } else {
            propDef.setCreate(false);
            propDef.setUpdate(false);
            propDef.setRead(false);
            for (Element e : accessElements) {
                String access = e.getTextContent();
                if (access.equals("create")) {
                    propDef.setCreate(true);
                }
                if (access.equals("update")) {
                    propDef.setUpdate(true);
                }
                if (!access.equals("read")) continue;
                propDef.setRead(true);
            }
        }
        Element indexableElement = SchemaProcessorUtil.getAnnotationElement(annotation, PrismConstants.A_INDEXED);
        if (indexableElement != null) {
            Boolean indexable = XmlTypeConverter.toJavaValue(indexableElement, Boolean.class);
            propDef.setIndexed(indexable);
        }
        return propDef;
    }

    private void parseItemDefinitionAnnotations(ItemDefinition itemDef, XSAnnotation annotation) throws SchemaException {
        Element help;
        Element displayOrderElement;
        Element attributeDisplayName;
        if (annotation == null || annotation.getAnnotation() == null) {
            return;
        }
        QName elementName = itemDef.getName();
        List<Element> ignore = SchemaProcessorUtil.getAnnotationElements(annotation, PrismConstants.A_IGNORE);
        if (ignore != null && !ignore.isEmpty()) {
            if (ignore.size() != 1) {
                throw new SchemaException("More than one " + PrismConstants.A_IGNORE.getLocalPart() + " annotation on declaration of element " + elementName);
            }
            String ignoreString = ignore.get(0).getTextContent();
            if (StringUtils.isEmpty((String)ignoreString)) {
                itemDef.setIgnored(true);
            } else {
                itemDef.setIgnored(Boolean.parseBoolean(ignoreString));
            }
        }
        if ((attributeDisplayName = SchemaProcessorUtil.getAnnotationElement(annotation, PrismConstants.A_DISPLAY_NAME)) != null) {
            itemDef.setDisplayName(attributeDisplayName.getTextContent());
        }
        if ((displayOrderElement = SchemaProcessorUtil.getAnnotationElement(annotation, PrismConstants.A_DISPLAY_ORDER)) != null) {
            Integer displayOrder = DOMUtil.getIntegerValue((Element)displayOrderElement);
            itemDef.setDisplayOrder(displayOrder);
        }
        if ((help = SchemaProcessorUtil.getAnnotationElement(annotation, PrismConstants.A_HELP)) != null) {
            itemDef.setHelp(help.getTextContent());
        }
    }

    private boolean containsAccessFlag(String flag, List<Element> accessList) {
        for (Element element : accessList) {
            if (!flag.equals(element.getTextContent())) continue;
            return true;
        }
        return false;
    }

    private XSAnnotation selectAnnotationToUse(XSAnnotation particleAnnotation, XSAnnotation termAnnotation) {
        boolean useParticleAnnotation = false;
        if (particleAnnotation != null && particleAnnotation.getAnnotation() != null && this.testAnnotationAppinfo(particleAnnotation)) {
            useParticleAnnotation = true;
        }
        boolean useTermAnnotation = false;
        if (termAnnotation != null && termAnnotation.getAnnotation() != null && this.testAnnotationAppinfo(termAnnotation)) {
            useTermAnnotation = true;
        }
        if (useParticleAnnotation) {
            return particleAnnotation;
        }
        if (useTermAnnotation) {
            return termAnnotation;
        }
        return null;
    }

    private boolean testAnnotationAppinfo(XSAnnotation annotation) {
        Element appinfo = SchemaProcessorUtil.getAnnotationElement(annotation, new QName("http://www.w3.org/2001/XMLSchema", "appinfo"));
        return appinfo != null;
    }
}

