/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.delta;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.util.exception.SchemaException;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;

public class ReferenceDelta
extends ItemDelta<PrismReferenceValue> {
    public ReferenceDelta(PrismReferenceDefinition itemDefinition) {
        super(itemDefinition);
    }

    public ReferenceDelta(PropertyPath propertyPath, PrismReferenceDefinition itemDefinition) {
        super(propertyPath, (ItemDefinition)itemDefinition);
    }

    public ReferenceDelta(PropertyPath parentPath, QName name, PrismReferenceDefinition itemDefinition) {
        super(parentPath, name, itemDefinition);
    }

    public ReferenceDelta(QName name, PrismReferenceDefinition itemDefinition) {
        super(name, (ItemDefinition)itemDefinition);
    }

    @Override
    public Class<PrismReference> getItemClass() {
        return PrismReference.class;
    }

    @Override
    public void setDefinition(ItemDefinition definition) {
        if (!(definition instanceof PrismReferenceDefinition)) {
            throw new IllegalArgumentException("Cannot apply " + definition + " to reference delta");
        }
        super.setDefinition(definition);
    }

    @Override
    public void applyDefinition(ItemDefinition definition) throws SchemaException {
        if (!(definition instanceof PrismReferenceDefinition)) {
            throw new IllegalArgumentException("Cannot apply definition " + definition + " to reference delta " + this);
        }
        super.applyDefinition(definition);
    }

    @Override
    public void applyTo(Item item) throws SchemaException {
        if (!(item instanceof PrismReference)) {
            throw new SchemaException("Cannot apply reference delta " + this + " to item " + item + " of type " + item.getClass());
        }
        super.applyTo(item);
    }

    @Override
    public ReferenceDelta clone() {
        ReferenceDelta clone = new ReferenceDelta(this.getPath(), (PrismReferenceDefinition)this.getDefinition());
        this.copyValues(clone);
        return clone;
    }

    protected void copyValues(ReferenceDelta clone) {
        super.copyValues(clone);
    }

    public static Collection<? extends ItemDelta> createModificationReplaceCollection(QName propertyName, PrismObjectDefinition<?> objectDefinition, PrismReferenceValue refValue) {
        ArrayList<ReferenceDelta> modifications = new ArrayList<ReferenceDelta>(1);
        ReferenceDelta delta = ReferenceDelta.createModificationReplace(propertyName, objectDefinition, refValue);
        modifications.add(delta);
        return modifications;
    }

    public static ReferenceDelta createModificationReplace(QName refName, PrismObjectDefinition<?> objectDefinition, PrismReferenceValue refValue) {
        PrismReferenceDefinition referenceDefinition = objectDefinition.findItemDefinition(refName, PrismReferenceDefinition.class);
        ReferenceDelta referenceDelta = new ReferenceDelta(refName, referenceDefinition);
        referenceDelta.setValueToReplace(refValue);
        return referenceDelta;
    }

    public static Collection<? extends ItemDelta> createModificationAddCollection(QName propertyName, PrismObjectDefinition<?> objectDefinition, PrismReferenceValue refValue) {
        Collection<ItemDelta<?>> modifications = ReferenceDelta.createModificationsCollection(1);
        ReferenceDelta delta = ReferenceDelta.createModificationAdd(propertyName, objectDefinition, refValue);
        modifications.add(delta);
        return modifications;
    }

    private static Collection<? extends ItemDelta<?>> createModificationsCollection(int initSize) {
        return new ArrayList(initSize);
    }

    public static ReferenceDelta createModificationAdd(QName refName, PrismObjectDefinition<?> objectDefinition, String oid) {
        return ReferenceDelta.createModificationAdd(refName, objectDefinition, new PrismReferenceValue(oid));
    }

    public static ReferenceDelta createModificationAdd(QName refName, PrismObjectDefinition<?> objectDefinition, PrismReferenceValue refValue) {
        PrismReferenceDefinition referenceDefinition = objectDefinition.findItemDefinition(refName, PrismReferenceDefinition.class);
        ReferenceDelta referenceDelta = new ReferenceDelta(refName, referenceDefinition);
        referenceDelta.addValueToAdd(refValue);
        return referenceDelta;
    }

    public static <T extends Objectable> ReferenceDelta createModificationAdd(Class<T> type, QName refName, PrismContext prismContext, PrismReferenceValue refValue) {
        PrismObjectDefinition<T> objectDefinition = prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(type);
        return ReferenceDelta.createModificationAdd(refName, objectDefinition, refValue);
    }

    public static <T extends Objectable> Collection<? extends ItemDelta> createModificationAddCollection(Class<T> type, QName refName, PrismContext prismContext, PrismReferenceValue refValue) {
        Collection<ItemDelta<?>> modifications = ReferenceDelta.createModificationsCollection(1);
        ReferenceDelta delta = ReferenceDelta.createModificationAdd(type, refName, prismContext, refValue);
        modifications.add(delta);
        return modifications;
    }

    public static <T extends Objectable> ReferenceDelta createModificationAdd(Class<T> type, QName refName, PrismContext prismContext, PrismObject<?> refTarget) {
        PrismReferenceValue refValue = PrismReferenceValue.createFromTarget(refTarget);
        return ReferenceDelta.createModificationAdd(type, refName, prismContext, refValue);
    }

    public static <T extends Objectable> Collection<? extends ItemDelta> createModificationAddCollection(Class<T> type, QName refName, PrismContext prismContext, PrismObject<?> refTarget) {
        Collection<ItemDelta<?>> modifications = ReferenceDelta.createModificationsCollection(1);
        ReferenceDelta delta = ReferenceDelta.createModificationAdd(type, refName, prismContext, refTarget);
        modifications.add(delta);
        return modifications;
    }

    public static Collection<? extends ItemDelta> createModificationDeleteCollection(QName propertyName, PrismObjectDefinition<?> objectDefinition, PrismReferenceValue refValue) {
        ArrayList<ReferenceDelta> modifications = new ArrayList<ReferenceDelta>(1);
        ReferenceDelta delta = ReferenceDelta.createModificationDelete(propertyName, objectDefinition, refValue);
        modifications.add(delta);
        return modifications;
    }

    public static ReferenceDelta createModificationDelete(QName refName, PrismObjectDefinition<?> objectDefinition, String oid) {
        return ReferenceDelta.createModificationDelete(refName, objectDefinition, new PrismReferenceValue(oid));
    }

    public static ReferenceDelta createModificationDelete(QName refName, PrismObjectDefinition<?> objectDefinition, PrismObject<?> refTarget) {
        PrismReferenceValue refValue = PrismReferenceValue.createFromTarget(refTarget);
        return ReferenceDelta.createModificationDelete(refName, objectDefinition, refValue);
    }

    public static ReferenceDelta createModificationDelete(QName refName, PrismObjectDefinition<?> objectDefinition, PrismReferenceValue refValue) {
        PrismReferenceDefinition referenceDefinition = objectDefinition.findItemDefinition(refName, PrismReferenceDefinition.class);
        ReferenceDelta referenceDelta = new ReferenceDelta(refName, referenceDefinition);
        referenceDelta.addValueToDelete(refValue);
        return referenceDelta;
    }

    public static <T extends Objectable> ReferenceDelta createModificationDelete(Class<T> type, QName refName, PrismContext prismContext, PrismReferenceValue refValue) {
        PrismObjectDefinition<T> objectDefinition = prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(type);
        return ReferenceDelta.createModificationDelete(refName, objectDefinition, refValue);
    }

    public static <T extends Objectable> Collection<? extends ItemDelta> createModificationDeleteCollection(Class<T> type, QName refName, PrismContext prismContext, PrismReferenceValue refValue) {
        Collection<ItemDelta<?>> modifications = ReferenceDelta.createModificationsCollection(1);
        ReferenceDelta delta = ReferenceDelta.createModificationDelete(type, refName, prismContext, refValue);
        modifications.add(delta);
        return modifications;
    }

    public static <T extends Objectable> ReferenceDelta createModificationDelete(Class<T> type, QName refName, PrismContext prismContext, PrismObject<?> refTarget) {
        PrismReferenceValue refValue = PrismReferenceValue.createFromTarget(refTarget);
        return ReferenceDelta.createModificationDelete(type, refName, prismContext, refValue);
    }

    public static <T extends Objectable> ReferenceDelta createModificationDelete(Class<T> type, QName refName, PrismObject<?> refTarget) {
        PrismReferenceValue refValue = PrismReferenceValue.createFromTarget(refTarget);
        return ReferenceDelta.createModificationDelete(type, refName, refTarget.getPrismContext(), refValue);
    }

    public static <T extends Objectable> Collection<? extends ItemDelta> createModificationDeleteCollection(Class<T> type, QName refName, PrismContext prismContext, PrismObject<?> refTarget) {
        Collection<ItemDelta<?>> modifications = ReferenceDelta.createModificationsCollection(1);
        ReferenceDelta delta = ReferenceDelta.createModificationDelete(type, refName, prismContext, refTarget);
        modifications.add(delta);
        return modifications;
    }
}

