/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.PropertyPathSegment;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class PrismObject<T extends Objectable>
extends PrismContainer<T> {
    protected String oid;
    protected String version;
    private T objectable = null;

    public PrismObject(QName name, Class<T> compileTimeClass) {
        super(name, compileTimeClass);
    }

    public PrismObject(QName name, PrismObjectDefinition<T> definition, PrismContext prismContext) {
        super(name, definition, prismContext);
    }

    public String getOid() {
        return this.oid;
    }

    public void setOid(String oid) {
        this.oid = oid;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public PrismObjectDefinition<T> getDefinition() {
        return (PrismObjectDefinition)super.getDefinition();
    }

    public T asObjectable() {
        if (this.objectable != null) {
            return this.objectable;
        }
        Class clazz = this.getCompileTimeClass();
        if (clazz == null) {
            throw new SystemException("Unknown compile time class of this prism object '" + this.getName() + "'.");
        }
        if (Modifier.isAbstract(clazz.getModifiers())) {
            throw new SystemException("Can't create instance of class '" + clazz.getSimpleName() + "', it's abstract.");
        }
        try {
            this.objectable = (Objectable)clazz.newInstance();
            this.objectable.setupContainer(this);
            return this.objectable;
        }
        catch (SystemException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new SystemException("Couldn't create jaxb object instance of '" + clazz + "': " + ex.getMessage(), (Throwable)ex);
        }
    }

    public PrismContainer<?> getExtension() {
        return this.getValue().findItem(new QName(this.getName().getNamespaceURI(), "extension"), PrismContainer.class);
    }

    @Override
    public void applyDefinition(ItemDefinition definition) throws SchemaException {
        if (!(definition instanceof PrismObjectDefinition)) {
            throw new IllegalArgumentException("Cannot apply " + definition + " to object");
        }
        super.applyDefinition(definition);
    }

    @Override
    public <I extends Item<?>> I findItem(PropertyPath path, Class<I> type) {
        try {
            return this.findCreateItem(path, type, null, false);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Item<?> findItem(PropertyPath path) {
        try {
            return this.findCreateItem(path, Item.class, null, false);
        }
        catch (SchemaException e) {
            throw new SystemException("Internal Error: " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    <I extends Item<?>> I findCreateItem(PropertyPath path, Class<I> type, ItemDefinition itemDefinition, boolean create) throws SchemaException {
        PropertyPathSegment first = path.first();
        PropertyPath rest = path.rest();
        Item subitem = null;
        if (rest.isEmpty()) {
            subitem = this.getValue().findCreateItem(first.getName(), Item.class, itemDefinition, create);
        } else {
            PrismContainerDefinition contDef = null;
            if (this.getDefinition() != null) {
                contDef = this.getDefinition().findContainerDefinition(first.getName());
                if (contDef == null) {
                    throw new SchemaException("No definition for container " + first.getName() + " in " + this);
                }
                if (contDef instanceof PrismObjectDefinition) {
                    throw new IllegalStateException("Got " + contDef + " as a subitem " + first.getName() + " from " + this.getDefinition() + "which was quite unexpected");
                }
            }
            subitem = this.getValue().findCreateItem(first.getName(), PrismContainer.class, contDef, create);
        }
        if (subitem == null) {
            return null;
        }
        if (subitem instanceof PrismContainer) {
            return ((PrismContainer)subitem).findCreateItem(path, type, itemDefinition, create);
        }
        if (type.isAssignableFrom(subitem.getClass())) {
            return (I)subitem;
        }
        if (create) {
            throw new IllegalStateException("The " + type.getSimpleName() + " cannot be created because " + subitem.getClass().getSimpleName() + " with the same name exists");
        }
        return null;
    }

    public void addReplaceExisting(Item<?> item) throws SchemaException {
        this.getValue().addReplaceExisting(item);
    }

    @Override
    public PrismObject<T> clone() {
        PrismObject<T> clone = new PrismObject<T>(this.getName(), this.getDefinition(), this.prismContext);
        this.copyValues(clone);
        return clone;
    }

    @Override
    protected void copyValues(PrismObject<T> clone) {
        super.copyValues(clone);
        clone.oid = this.oid;
        clone.version = this.version;
    }

    public ObjectDelta<T> diff(PrismObject<T> other) {
        return this.diff(other, true);
    }

    public ObjectDelta<T> diff(PrismObject<T> other, boolean ignoreMetadata) {
        if (other == null) {
            ObjectDelta objectDelta = new ObjectDelta(this.getCompileTimeClass(), ChangeType.DELETE);
            objectDelta.setOid(this.getOid());
            return objectDelta;
        }
        ObjectDelta objectDelta = new ObjectDelta(this.getCompileTimeClass(), ChangeType.MODIFY);
        objectDelta.setOid(this.getOid());
        ArrayList itemDeltas = new ArrayList();
        this.diffInternal(other, null, itemDeltas, ignoreMetadata);
        objectDelta.addModifications(itemDeltas);
        return objectDelta;
    }

    public ObjectDelta<T> createDelta(ChangeType changeType) {
        ObjectDelta delta = new ObjectDelta(this.getCompileTimeClass(), changeType);
        delta.setOid(this.getOid());
        return delta;
    }

    public ObjectDelta<T> createAddDelta() {
        ObjectDelta<T> delta = this.createDelta(ChangeType.ADD);
        delta.setObjectToAdd(this);
        return delta;
    }

    public ObjectDelta<T> createDeleteDelta() {
        ObjectDelta<T> delta = this.createDelta(ChangeType.DELETE);
        delta.setOid(this.getOid());
        return delta;
    }

    @Override
    public void setParent(PrismValue parentValue) {
        throw new IllegalStateException("Cannot set parent for an object");
    }

    @Override
    public PrismValue getParent() {
        return null;
    }

    @Override
    public PropertyPath getPath(PropertyPath pathPrefix) {
        if (pathPrefix != null && !pathPrefix.isEmpty()) {
            throw new IllegalStateException("It makes no sense to use pathPrefix for an object");
        }
        return new PropertyPath();
    }

    public Element asDomElement() {
        return this.getValue().asDomElement();
    }

    private Collection<PropertyPath> listItemPaths() {
        ArrayList<PropertyPath> list = new ArrayList<PropertyPath>();
        this.addItemPathsToList(new PropertyPath(), list);
        return list;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.oid == null ? 0 : this.oid.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrismObject other = (PrismObject)obj;
        return !(this.oid == null ? other.oid != null : !this.oid.equals(other.oid));
    }

    @Override
    public boolean equivalent(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrismObject other = (PrismObject)obj;
        if (this.oid == null ? other.oid != null : !this.oid.equals(other.oid)) {
            return false;
        }
        ObjectDelta<T> delta = this.diff(other, true);
        return delta.isEmpty();
    }

    @Override
    public String toString() {
        return this.toDebugName();
    }

    public String toDebugName() {
        return String.valueOf(this.toDebugType()) + ":" + this.getOid() + "(" + this.getNamePropertyValue() + ")";
    }

    private PrismProperty<String> getNameProperty() {
        QName elementName = this.getName();
        String myNamespace = elementName.getNamespaceURI();
        return this.findProperty(new QName(myNamespace, "name"));
    }

    private String getNamePropertyValue() {
        PrismProperty<String> nameProperty = this.getNameProperty();
        if (nameProperty == null) {
            return null;
        }
        return nameProperty.getRealValue();
    }

    public String toDebugType() {
        QName elementName = this.getName();
        if (elementName == null) {
            return "(unknown)";
        }
        return elementName.getLocalPart();
    }

    @Override
    protected String getDebugDumpClassName() {
        return "PO";
    }

    @Override
    protected String additionalDumpDescription() {
        return ", " + this.getOid();
    }
}

