/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.ComplexTypeDefinition;
import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Definition;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismReferenceDefinition;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.schema.PrismSchema;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.DebugDumpable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;

public class PrismContainerDefinition<V extends Containerable>
extends ItemDefinition {
    private static final long serialVersionUID = -5068923696147960699L;
    protected ComplexTypeDefinition complexTypeDefinition;
    protected Class<V> compileTimeClass;
    protected boolean isRuntimeSchema;

    public PrismContainerDefinition(QName name, ComplexTypeDefinition complexTypeDefinition, PrismContext prismContext) {
        this(name, complexTypeDefinition, prismContext, null);
    }

    public PrismContainerDefinition(QName name, ComplexTypeDefinition complexTypeDefinition, PrismContext prismContext, Class<V> compileTimeClass) {
        super(name, PrismContainerDefinition.determineDefaultName(complexTypeDefinition), PrismContainerDefinition.determineTypeName(complexTypeDefinition), prismContext);
        this.complexTypeDefinition = complexTypeDefinition;
        if (complexTypeDefinition == null) {
            this.isRuntimeSchema = true;
            this.setDynamic(true);
        } else {
            this.isRuntimeSchema = complexTypeDefinition.isXsdAnyMarker();
            this.setDynamic(this.isRuntimeSchema);
        }
        this.compileTimeClass = compileTimeClass;
    }

    private static QName determineTypeName(ComplexTypeDefinition complexTypeDefinition) {
        if (complexTypeDefinition == null) {
            return DOMUtil.XSD_ANY;
        }
        return complexTypeDefinition.getTypeName();
    }

    private static QName determineDefaultName(ComplexTypeDefinition complexTypeDefinition) {
        if (complexTypeDefinition == null) {
            return null;
        }
        return complexTypeDefinition.getDefaultName();
    }

    public Class<V> getCompileTimeClass() {
        if (this.compileTimeClass != null) {
            return this.compileTimeClass;
        }
        if (this.complexTypeDefinition == null) {
            return null;
        }
        return this.complexTypeDefinition.getCompileTimeClass();
    }

    public void setCompileTimeClass(Class<V> compileTimeClass) {
        this.compileTimeClass = compileTimeClass;
    }

    protected String getSchemaNamespace() {
        return this.getNameOrDefaultName().getNamespaceURI();
    }

    public ComplexTypeDefinition getComplexTypeDefinition() {
        return this.complexTypeDefinition;
    }

    public void setComplexTypeDefinition(ComplexTypeDefinition complexTypeDefinition) {
        this.complexTypeDefinition = complexTypeDefinition;
    }

    @Override
    void revive(PrismContext prismContext) {
        if (this.prismContext != null) {
            return;
        }
        this.prismContext = prismContext;
        if (this.complexTypeDefinition != null) {
            this.complexTypeDefinition.revive(prismContext);
        }
    }

    public <D extends ItemDefinition> D findItemDefinition(QName name, Class<D> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("type not specified while searching for " + name + " in " + this);
        }
        if (name == null) {
            throw new IllegalArgumentException("name not specified while searching in " + this);
        }
        for (ItemDefinition def : this.getDefinitions()) {
            if (!this.isItemValid(def, name, clazz)) continue;
            return (D)def;
        }
        return null;
    }

    private <T extends ItemDefinition> boolean isItemValid(ItemDefinition def, QName name, Class<T> clazz) {
        if (def == null) {
            return false;
        }
        return def.isValidFor(name, clazz);
    }

    @Override
    public <T extends ItemDefinition> T findItemDefinition(PropertyPath path, Class<T> clazz) {
        if (path.isEmpty()) {
            return (T)this;
        }
        QName first = path.first().getName();
        for (ItemDefinition def : this.getDefinitions()) {
            if (!first.equals(def.getName())) continue;
            return def.findItemDefinition(path.rest(), clazz);
        }
        return null;
    }

    public ItemDefinition findItemDefinition(QName name) {
        return this.findItemDefinition(name, ItemDefinition.class);
    }

    public ItemDefinition findItemDefinition(PropertyPath path) {
        return this.findItemDefinition(path, ItemDefinition.class);
    }

    public PrismPropertyDefinition findPropertyDefinition(QName name) {
        return this.findItemDefinition(name, PrismPropertyDefinition.class);
    }

    public PrismPropertyDefinition findPropertyDefinition(PropertyPath propertyPath) {
        if (propertyPath.isEmpty()) {
            throw new IllegalArgumentException("Property path is empty while searching for property definition in " + this);
        }
        if (propertyPath.size() == 1) {
            return this.findPropertyDefinition(propertyPath.first().getName());
        }
        PrismContainerDefinition pcd = this.findContainerDefinition(propertyPath.first().getName());
        return pcd.findPropertyDefinition(propertyPath.rest());
    }

    public PrismReferenceDefinition findReferenceDefinition(QName name) {
        return this.findItemDefinition(name, PrismReferenceDefinition.class);
    }

    public <X extends Containerable> PrismContainerDefinition<X> findContainerDefinition(QName name) {
        return this.findItemDefinition(name, PrismContainerDefinition.class);
    }

    public <X extends Containerable> PrismContainerDefinition<X> findContainerDefinition(String name) {
        return this.findContainerDefinition(new QName(this.getNamespace(), name));
    }

    public PrismContainerDefinition findContainerDefinition(PropertyPath path) {
        return this.findItemDefinition(path, PrismContainerDefinition.class);
    }

    public Collection<ItemDefinition> getDefinitions() {
        if (this.complexTypeDefinition == null) {
            return new HashSet<ItemDefinition>();
        }
        return this.complexTypeDefinition.getDefinitions();
    }

    public Set<PrismPropertyDefinition> getPropertyDefinitions() {
        HashSet<PrismPropertyDefinition> props = new HashSet<PrismPropertyDefinition>();
        for (ItemDefinition def : this.complexTypeDefinition.getDefinitions()) {
            if (!(def instanceof PrismPropertyDefinition)) continue;
            props.add((PrismPropertyDefinition)def);
        }
        return props;
    }

    public boolean isRuntimeSchema() {
        return this.isRuntimeSchema;
    }

    public void setRuntimeSchema(boolean isRuntimeSchema) {
        this.isRuntimeSchema = isRuntimeSchema;
    }

    @Override
    public PrismContainer<V> instantiate() {
        return this.instantiate(this.getNameOrDefaultName());
    }

    @Override
    public PrismContainer<V> instantiate(QName name) {
        return new PrismContainer(name, this, this.prismContext);
    }

    @Override
    public PrismContainerDefinition<V> clone() {
        PrismContainerDefinition<V> clone = new PrismContainerDefinition<V>(this.name, this.complexTypeDefinition, this.prismContext, this.compileTimeClass);
        this.copyDefinitionData(clone);
        return clone;
    }

    protected void copyDefinitionData(PrismContainerDefinition<V> clone) {
        super.copyDefinitionData(clone);
        clone.complexTypeDefinition = this.complexTypeDefinition;
        clone.isRuntimeSchema = this.isRuntimeSchema;
        clone.compileTimeClass = this.compileTimeClass;
    }

    public PrismContainerDefinition<V> cloneWithReplacedDefinition(QName itemName, ItemDefinition newDefinition) {
        ItemDefinition clone = this.clone();
        ComplexTypeDefinition originalComplexTypeDefinition = this.getComplexTypeDefinition();
        ComplexTypeDefinition cloneComplexTypeDefinition = originalComplexTypeDefinition.clone();
        ((PrismContainerDefinition)clone).setComplexTypeDefinition(cloneComplexTypeDefinition);
        cloneComplexTypeDefinition.replaceDefinition(itemName, newDefinition);
        return clone;
    }

    public PrismPropertyDefinition createPropertyDefinition(QName name, QName typeName) {
        PrismPropertyDefinition propDef = new PrismPropertyDefinition(name, name, typeName, this.prismContext);
        this.getDefinitions().add(propDef);
        return propDef;
    }

    public PrismPropertyDefinition createPropertyDefinition(QName name, QName typeName, int minOccurs, int maxOccurs) {
        PrismPropertyDefinition propDef = new PrismPropertyDefinition(name, name, typeName, this.prismContext);
        propDef.setMinOccurs(minOccurs);
        propDef.setMaxOccurs(maxOccurs);
        this.getDefinitions().add(propDef);
        return propDef;
    }

    public PrismPropertyDefinition createPropertyDefinition(QName name) {
        PrismPropertyDefinition propDef = new PrismPropertyDefinition(name, name, null, this.prismContext);
        this.getDefinitions().add(propDef);
        return propDef;
    }

    public PrismPropertyDefinition createPropertyDefinition(String localName, QName typeName) {
        QName name = new QName(this.getSchemaNamespace(), localName);
        return this.createPropertyDefinition(name, typeName);
    }

    public PrismPropertyDefinition createPropertyDefinition(String localName, String localTypeName) {
        QName name = new QName(this.getSchemaNamespace(), localName);
        QName typeName = new QName(this.getSchemaNamespace(), localTypeName);
        return this.createPropertyDefinition(name, typeName);
    }

    public PrismPropertyDefinition createPropertyDefinition(String localName, String localTypeName, int minOccurs, int maxOccurs) {
        QName name = new QName(this.getSchemaNamespace(), localName);
        QName typeName = new QName(this.getSchemaNamespace(), localTypeName);
        PrismPropertyDefinition propertyDefinition = this.createPropertyDefinition(name, typeName);
        propertyDefinition.setMinOccurs(minOccurs);
        propertyDefinition.setMaxOccurs(maxOccurs);
        return propertyDefinition;
    }

    public PrismContainerDefinition createContainerDefinition(QName name, QName typeName) {
        return this.createContainerDefinition(name, typeName, 1, 1);
    }

    public PrismContainerDefinition createContainerDefinition(QName name, QName typeName, int minOccurs, int maxOccurs) {
        PrismSchema typeSchema = this.prismContext.getSchemaRegistry().findSchemaByNamespace(typeName.getNamespaceURI());
        if (typeSchema == null) {
            throw new IllegalArgumentException("Schema for namespace " + typeName.getNamespaceURI() + " is not known in the prism context");
        }
        ComplexTypeDefinition typeDefinition = typeSchema.findComplexTypeDefinition(typeName);
        if (typeDefinition == null) {
            throw new IllegalArgumentException("Type " + typeName + " is not known in the schema");
        }
        return this.createContainerDefinition(name, typeDefinition, minOccurs, maxOccurs);
    }

    public PrismContainerDefinition<V> createContainerDefinition(QName name, ComplexTypeDefinition complexTypeDefinition, int minOccurs, int maxOccurs) {
        PrismContainerDefinition<V> def = new PrismContainerDefinition<V>(name, complexTypeDefinition, this.prismContext);
        def.setMinOccurs(minOccurs);
        def.setMaxOccurs(maxOccurs);
        this.getDefinitions().add(def);
        return def;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String debugDump(int indent) {
        void var3_4;
        StringBuilder sb = new StringBuilder();
        boolean bl = false;
        while (var3_4 < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++var3_4;
        }
        sb.append(this.toString());
        if (this.isRuntimeSchema()) {
            sb.append(" dynamic");
        }
        sb.append("\n");
        for (Definition definition : this.getDefinitions()) {
            sb.append(definition.debugDump(indent + 1));
        }
        return sb.toString();
    }

    public boolean isEmpty() {
        return this.complexTypeDefinition.isEmpty();
    }

    @Override
    protected String getDebugDumpClassName() {
        return "PCD";
    }

    @Override
    protected void extendToString(StringBuilder sb) {
        super.extendToString(sb);
        if (this.isRuntimeSchema) {
            sb.append(",runtime");
        }
    }
}

