/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.formatter.comment;

import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import org.aspectj.org.eclipse.jdt.internal.compiler.parser.ScannerHelper;
import org.aspectj.org.eclipse.jdt.internal.formatter.CodeFormatterVisitor;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.CommentFormatterUtil;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.CommentLine;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.CommentRange;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.HTMLEntity2JavaReader;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.IJavaDocTagConstants;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.Java2HTMLEntityReader;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.JavaDocLine;
import org.aspectj.org.eclipse.jdt.internal.formatter.comment.MultiCommentRegion;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.TextEdit;

public class JavaDocRegion
extends MultiCommentRegion
implements IJavaDocTagConstants {
    private final ArrayList fCodePositions = new ArrayList();
    private final boolean fFormatHtml;
    private final boolean fFormatSource;

    public JavaDocRegion(IDocument document, Position position, CodeFormatterVisitor formatter) {
        super(document, position, formatter);
        this.fFormatSource = this.preferences.comment_format_source;
        this.fFormatHtml = this.preferences.comment_format_html;
        this.fClear = this.preferences.comment_clear_blank_lines_in_javadoc_comment;
    }

    protected boolean canFormat(CommentRange previous, CommentRange next) {
        if (previous != null) {
            boolean isCurrentCode = next.hasAttribute(16);
            boolean isLastCode = previous.hasAttribute(16);
            int base = this.getOffset();
            if (!isLastCode && isCurrentCode) {
                this.fCodePositions.add(new Position(base + previous.getOffset()));
            } else if (isLastCode && !isCurrentCode) {
                this.fCodePositions.add(new Position(base + next.getOffset() + next.getLength()));
            }
            return !previous.hasAttribute(64) || !next.hasAttribute(64);
        }
        return false;
    }

    protected final void formatRegion(String indentation, int width) {
        super.formatRegion(indentation, width);
        if (this.fFormatSource) {
            try {
                if (this.fCodePositions.size() > 0) {
                    int begin = 0;
                    int end = 0;
                    Position position = null;
                    IDocument document = this.getDocument();
                    int index = this.fCodePositions.size() - 1;
                    while (index >= 0) {
                        position = (Position)this.fCodePositions.get(index--);
                        begin = position.getOffset();
                        if (index >= 0) {
                            position = (Position)this.fCodePositions.get(index--);
                            end = position.getOffset();
                        } else {
                            position = null;
                            end = this.getOffset() + this.getLength() - " */".trim().length();
                            while (end > begin && ScannerHelper.isWhitespace(document.getChar(end - 1))) {
                                --end;
                            }
                        }
                        String snippet = document.get(begin, end - begin);
                        snippet = this.preprocessCodeSnippet(snippet);
                        snippet = this.formatCodeSnippet(snippet);
                        snippet = this.postprocessCodeSnippet(snippet, indentation);
                        this.logEdit(snippet, begin - this.getOffset(), end - begin);
                    }
                }
            }
            catch (BadLocationException e) {
                CommentFormatterUtil.log(e);
            }
        }
    }

    private String preprocessCodeSnippet(String snippet) {
        StringBuffer buffer = new StringBuffer();
        DefaultLineTracker tracker = new DefaultLineTracker();
        String contentPrefix = " * ".trim();
        buffer.setLength(0);
        buffer.append(snippet);
        tracker.set(snippet);
        int line = tracker.getNumberOfLines() - 1;
        while (line > 0) {
            int lineOffset;
            try {
                lineOffset = tracker.getLineOffset(line);
            }
            catch (BadLocationException e) {
                CommentFormatterUtil.log(e);
                return snippet;
            }
            int prefixOffset = buffer.indexOf(contentPrefix, lineOffset);
            if (prefixOffset >= 0 && buffer.substring(lineOffset, prefixOffset).trim().length() == 0) {
                buffer.delete(lineOffset, prefixOffset + contentPrefix.length() + 1);
            }
            --line;
        }
        return this.convertHtml2Java(buffer.toString());
    }

    private String formatCodeSnippet(String snippet) {
        String lineDelimiter = TextUtilities.getDefaultLineDelimiter((IDocument)this.getDocument());
        TextEdit edit = CommentFormatterUtil.format2(0, snippet, 0, lineDelimiter, this.preferences.getMap());
        if (edit != null) {
            snippet = CommentFormatterUtil.evaluateFormatterEdit(snippet, edit, null);
        }
        return snippet;
    }

    private String postprocessCodeSnippet(String snippet, String indentation) {
        StringBuffer buffer = new StringBuffer();
        DefaultLineTracker tracker = new DefaultLineTracker();
        String patch = String.valueOf(indentation) + " * ";
        int i = snippet.length();
        while (i > 0 && ' ' == snippet.charAt(i - 1)) {
            --i;
        }
        snippet = snippet.substring(0, i);
        buffer.setLength(0);
        String lineDelimiter = this.getDelimiter();
        if (lineDelimiter != null && snippet.indexOf(lineDelimiter) != 0) {
            buffer.append(lineDelimiter);
        }
        buffer.append(this.convertJava2Html(snippet));
        if (lineDelimiter != null && snippet.lastIndexOf(lineDelimiter) != snippet.length() - lineDelimiter.length()) {
            buffer.append(lineDelimiter);
        }
        tracker.set(buffer.toString());
        int line = tracker.getNumberOfLines() - 1;
        while (line > 0) {
            try {
                buffer.insert(tracker.getLineOffset(line), patch);
            }
            catch (BadLocationException e) {
                CommentFormatterUtil.log(e);
                return snippet;
            }
            --line;
        }
        return buffer.toString();
    }

    protected final void markHtmlRanges() {
        this.markTagRanges(IJavaDocTagConstants.JAVADOC_IMMUTABLE_TAGS, 64, true);
        if (this.fFormatSource) {
            this.markTagRanges(IJavaDocTagConstants.JAVADOC_CODE_TAGS, 16, false);
        }
    }

    protected final void markHtmlTag(CommentRange range, char[] token) {
        if (range.hasAttribute(32)) {
            range.markHtmlTag(IJavaDocTagConstants.JAVADOC_IMMUTABLE_TAGS, token, 64, true, true);
            if (this.fFormatHtml) {
                range.markHtmlTag(IJavaDocTagConstants.JAVADOC_SEPARATOR_TAGS, token, 4096, true, true);
                range.markHtmlTag(IJavaDocTagConstants.JAVADOC_BREAK_TAGS, token, 4, false, true);
                range.markHtmlTag(IJavaDocTagConstants.JAVADOC_SINGLE_BREAK_TAG, token, 4, true, false);
                range.markHtmlTag(IJavaDocTagConstants.JAVADOC_NEWLINE_TAGS, token, 128, true, false);
            } else {
                range.markHtmlTag(IJavaDocTagConstants.JAVADOC_CODE_TAGS, token, 4096, true, true);
            }
        }
    }

    protected final void markJavadocTag(CommentRange range, char[] token) {
        range.markPrefixTag(IJavaDocTagConstants.JAVADOC_PARAM_TAGS, '@', token, 1024);
        if (token[0] == '@' && !range.hasAttribute(1024)) {
            range.setAttribute(2048);
        }
    }

    protected final void markTagRanges(char[][] tags, int attribute, boolean html) {
        int level = 0;
        int count = 0;
        char[] token = null;
        CommentRange current = null;
        int index = 0;
        while (index < tags.length) {
            level = 0;
            Iterator iterator = this.getRanges().iterator();
            while (iterator.hasNext()) {
                current = (CommentRange)iterator.next();
                count = current.getLength();
                if (count <= 0 && level <= 0) continue;
                token = this.getText(current.getOffset(), current.getLength()).toCharArray();
                level = current.markTagRange(token, tags[index], level, attribute, html);
            }
            ++index;
        }
    }

    protected boolean canAppend(CommentLine line, CommentRange previous, CommentRange next, int index, int count) {
        if (next.hasAttribute(8208) && line.getSize() != 0) {
            return false;
        }
        return super.canAppend(line, previous, next, index, count);
    }

    private String convertJava2Html(String formatted) {
        Java2HTMLEntityReader reader = new Java2HTMLEntityReader(new StringReader(formatted));
        char[] buf = new char[256];
        StringBuffer buffer = new StringBuffer();
        try {
            int l;
            do {
                if ((l = reader.read(buf)) == -1) continue;
                buffer.append(buf, 0, l);
            } while (l > 0);
            return buffer.toString();
        }
        catch (IOException e) {
            return formatted;
        }
    }

    private String convertHtml2Java(String html) {
        HTMLEntity2JavaReader reader = new HTMLEntity2JavaReader(new StringReader(html));
        char[] buf = new char[html.length()];
        try {
            int read = reader.read(buf);
            return new String(buf, 0, read);
        }
        catch (IOException e) {
            return html;
        }
    }

    protected CommentLine createLine() {
        return new JavaDocLine(this);
    }
}

