/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.security.api;

import com.evolveum.midpoint.util.MiscUtil;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ActivationType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CredentialsType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.prism.xml.ns._public.types_2.PolyStringType;
import java.io.Serializable;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.commons.lang.Validate;

public class PrincipalUser
implements Serializable {
    private static final long serialVersionUID = 8299738301872077768L;
    private UserType user;

    public PrincipalUser(UserType user) {
        Validate.notNull((Object)user, (String)"User must not be null.");
        this.user = user;
    }

    public boolean isEnabled() {
        CredentialsType credentials = this.user.getCredentials();
        if (credentials == null || credentials.getPassword() == null) {
            return false;
        }
        if (this.user.getActivation() != null) {
            long to;
            long from;
            ActivationType activation = this.user.getActivation();
            long time = System.currentTimeMillis();
            if (activation.getValidFrom() != null && time < (from = MiscUtil.asDate((XMLGregorianCalendar)activation.getValidFrom()).getTime())) {
                return false;
            }
            if (activation.getValidTo() != null && (to = MiscUtil.asDate((XMLGregorianCalendar)activation.getValidTo()).getTime()) > time) {
                return false;
            }
        }
        return true;
    }

    public UserType getUser() {
        return this.user;
    }

    public String getName() {
        return this.getUser().getName();
    }

    public String getFamilyName() {
        PolyStringType string = this.getUser().getFamilyName();
        return string != null ? string.getOrig() : null;
    }

    public String getFullName() {
        PolyStringType string = this.getUser().getFullName();
        return string != null ? string.getOrig() : null;
    }

    public String getGivenName() {
        PolyStringType string = this.getUser().getGivenName();
        return string != null ? string.getOrig() : null;
    }

    public String getOid() {
        return this.getUser().getOid();
    }
}

