/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.id.enhanced;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.id.IdentifierGenerationException;
import org.hibernate.id.IdentifierGeneratorHelper;
import org.hibernate.id.IntegralDataTypeHolder;
import org.hibernate.id.enhanced.AccessCallback;
import org.hibernate.id.enhanced.DatabaseStructure;
import org.hibernate.id.enhanced.Optimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.jdbc.AbstractReturningWork;
import org.jboss.logging.Logger;

public class TableStructure
implements DatabaseStructure {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)TableStructure.class.getName());
    private final String tableName;
    private final String valueColumnName;
    private final int initialValue;
    private final int incrementSize;
    private final Class numberType;
    private final String selectQuery;
    private final String updateQuery;
    private boolean applyIncrementSizeToSourceValues;
    private int accessCounter;

    public TableStructure(Dialect dialect, String tableName, String valueColumnName, int initialValue, int incrementSize, Class numberType) {
        this.tableName = tableName;
        this.initialValue = initialValue;
        this.incrementSize = incrementSize;
        this.valueColumnName = valueColumnName;
        this.numberType = numberType;
        this.selectQuery = "select " + valueColumnName + " as id_val" + " from " + dialect.appendLockHint(LockMode.PESSIMISTIC_WRITE, tableName) + dialect.getForUpdateString();
        this.updateQuery = "update " + tableName + " set " + valueColumnName + "= ?" + " where " + valueColumnName + "=?";
    }

    @Override
    public String getName() {
        return this.tableName;
    }

    @Override
    public int getInitialValue() {
        return this.initialValue;
    }

    @Override
    public int getIncrementSize() {
        return this.incrementSize;
    }

    @Override
    public int getTimesAccessed() {
        return this.accessCounter;
    }

    @Override
    public void prepare(Optimizer optimizer) {
        this.applyIncrementSizeToSourceValues = optimizer.applyIncrementSizeToSourceValues();
    }

    @Override
    public AccessCallback buildCallback(final SessionImplementor session) {
        return new AccessCallback(){

            @Override
            public IntegralDataTypeHolder getNextValue() {
                return session.getTransactionCoordinator().getTransaction().createIsolationDelegate().delegateWork(new AbstractReturningWork<IntegralDataTypeHolder>(){

                    @Override
                    public IntegralDataTypeHolder execute(Connection connection) throws SQLException {
                        int rows;
                        SqlStatementLogger statementLogger = session.getFactory().getServiceRegistry().getService(JdbcServices.class).getSqlStatementLogger();
                        IntegralDataTypeHolder value = IdentifierGeneratorHelper.getIntegralDataTypeHolder(TableStructure.this.numberType);
                        do {
                            statementLogger.logStatement(TableStructure.this.selectQuery, FormatStyle.BASIC.getFormatter());
                            PreparedStatement selectStatement = connection.prepareStatement(TableStructure.this.selectQuery);
                            try {
                                ResultSet selectRS = selectStatement.executeQuery();
                                if (!selectRS.next()) {
                                    String err = "could not read a hi value - you need to populate the table: " + TableStructure.this.tableName;
                                    LOG.error(err);
                                    throw new IdentifierGenerationException(err);
                                }
                                value.initialize(selectRS, 1L);
                                selectRS.close();
                            }
                            catch (SQLException sqle) {
                                LOG.error("could not read a hi value", sqle);
                                throw sqle;
                            }
                            finally {
                                selectStatement.close();
                            }
                            statementLogger.logStatement(TableStructure.this.updateQuery, FormatStyle.BASIC.getFormatter());
                            PreparedStatement updatePS = connection.prepareStatement(TableStructure.this.updateQuery);
                            try {
                                int increment = TableStructure.this.applyIncrementSizeToSourceValues ? TableStructure.this.incrementSize : 1;
                                IntegralDataTypeHolder updateValue = value.copy().add(increment);
                                updateValue.bind(updatePS, 1);
                                value.bind(updatePS, 2);
                                rows = updatePS.executeUpdate();
                            }
                            catch (SQLException e) {
                                LOG.unableToUpdateQueryHiValue(TableStructure.this.tableName, e);
                                throw e;
                            }
                            finally {
                                updatePS.close();
                            }
                        } while (rows == 0);
                        TableStructure.this.accessCounter++;
                        return value;
                    }
                }, true);
            }
        };
    }

    @Override
    public String[] sqlCreateStrings(Dialect dialect) throws HibernateException {
        return new String[]{dialect.getCreateTableString() + " " + this.tableName + " ( " + this.valueColumnName + " " + dialect.getTypeName(-5) + " )", "insert into " + this.tableName + " values ( " + this.initialValue + " )"};
    }

    @Override
    public String[] sqlDropStrings(Dialect dialect) throws HibernateException {
        StringBuffer sqlDropString = new StringBuffer().append("drop table ");
        if (dialect.supportsIfExistsBeforeTableName()) {
            sqlDropString.append("if exists ");
        }
        sqlDropString.append(this.tableName).append(dialect.getCascadeConstraintsString());
        if (dialect.supportsIfExistsAfterTableName()) {
            sqlDropString.append(" if exists");
        }
        return new String[]{sqlDropString.toString()};
    }

    @Override
    public boolean isPhysicalSequence() {
        return false;
    }
}

