/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.repo.sql.SqlRepositoryConfiguration;
import com.evolveum.midpoint.repo.sql.SqlRepositoryFactory;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.NodeErrorStatus;
import com.evolveum.midpoint.task.api.TaskManagerInitializationException;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerConfiguration;
import com.evolveum.midpoint.task.quartzimpl.TaskManagerQuartzImpl;
import com.evolveum.midpoint.task.quartzimpl.execution.JobExecutor;
import com.evolveum.midpoint.task.quartzimpl.handlers.NoOpTaskHandler;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;

public class Initializer {
    private static final transient Trace LOGGER = TraceManager.getTrace(Initializer.class);
    private TaskManagerQuartzImpl taskManager;

    Initializer(TaskManagerQuartzImpl taskManager) {
        this.taskManager = taskManager;
    }

    public void init(OperationResult result) throws TaskManagerInitializationException {
        MidpointConfiguration midpointConfiguration = this.taskManager.getMidpointConfiguration();
        LOGGER.info("Task Manager initialization.");
        TaskManagerConfiguration configuration = this.taskManager.getConfiguration();
        configuration.setBasicInformation(midpointConfiguration);
        configuration.validateBasicInformation();
        LOGGER.info("Task Manager: Quartz Job Store: " + (configuration.isJdbcJobStore() ? "JDBC" : "in-memory") + ", " + (configuration.isClustered() ? "" : "NOT ") + "clustered. Threads: " + configuration.getThreads());
        if (configuration.isJdbcJobStore()) {
            SqlRepositoryConfiguration sqlConfig;
            try {
                SqlRepositoryFactory sqlRepositoryFactory = (SqlRepositoryFactory)this.taskManager.getBeanFactory().getBean("sqlRepositoryFactory");
                sqlConfig = sqlRepositoryFactory.getSqlConfiguration();
            }
            catch (NoSuchBeanDefinitionException e) {
                LOGGER.info("SqlRepositoryFactory is not available, JDBC Job Store configuration will be taken from taskManager section only.");
                LOGGER.trace("Reason is", (Throwable)e);
                sqlConfig = null;
            }
            configuration.setJdbcJobStoreInformation(midpointConfiguration, sqlConfig);
            configuration.validateJdbcJobStoreInformation();
        }
        this.taskManager.getClusterManager().createNodeObject(result);
        if (!this.taskManager.getConfiguration().isTestMode()) {
            this.taskManager.getClusterManager().checkClusterConfiguration(result);
        }
        NoOpTaskHandler.instantiateAndRegister(this.taskManager);
        JobExecutor.setTaskManagerQuartzImpl(this.taskManager);
        this.taskManager.getExecutionManager().initializeLocalScheduler();
        if (this.taskManager.getLocalNodeErrorStatus() != NodeErrorStatus.OK) {
            this.taskManager.getExecutionManager().shutdownLocalSchedulerChecked();
        }
        if (!this.taskManager.getExecutionManager().synchronizeJobStores(result)) {
            if (!configuration.isJdbcJobStore()) {
                LOGGER.error("Some or all tasks could not be imported from midPoint repository to Quartz job store. They will therefore not be executed.");
            } else {
                LOGGER.warn("Some or all tasks could not be synchronized between midPoint repository and Quartz job store. They may not function correctly.");
            }
        }
        LOGGER.trace("Quartz scheduler initialized (not yet started, however)");
        LOGGER.info("Task Manager initialized");
    }
}

