/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.wf.activiti;

import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.ObjectFactory;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessInstanceEventType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessInstanceFinishedEventType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessInstanceStartedEventType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessVariable;
import org.activiti.engine.impl.pvm.delegate.ExecutionListenerExecution;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdmExecutionListener {
    private static Logger logger = LoggerFactory.getLogger(IdmExecutionListener.class);

    public void notify(ExecutionListenerExecution execution) throws Exception {
        this.notify(execution, "", null);
    }

    public void notify(ExecutionListenerExecution execution, String description) throws Exception {
        this.notify(execution, "", null);
    }

    public void notify(ExecutionListenerExecution execution, String description, String wfAnswer) throws Exception {
        if (execution == null) {
            logger.error("Variable 'execution' (ExecutionListenerExecution) cannot be null, please check your listener configuration.");
            return;
        }
        String eventName = execution.getEventName();
        String pid = execution.getProcessInstanceId();
        Object midpointTaskOid = execution.getVariable("midpointTaskOid");
        if (wfAnswer == null) {
            wfAnswer = (String)execution.getVariable("wfAnswer");
        }
        logger.info("** PROCESS EXECUTION EVENT: " + eventName + " **");
        logger.info("Process instance id = " + pid);
        logger.info("Description = " + description);
        logger.info("Answer = " + wfAnswer);
        Object event = "start".equals(eventName) ? new WfProcessInstanceStartedEventType() : ("end".equals(eventName) ? new WfProcessInstanceFinishedEventType() : new WfProcessInstanceEventType());
        event.setWfProcessInstanceId(pid);
        event.setWfAnswer(wfAnswer);
        if (midpointTaskOid != null) {
            event.setMidpointTaskOid(midpointTaskOid.toString());
        } else {
            logger.error("Process variable midpointTaskOid is not set!");
        }
        event.setWfStateDescription(description);
        for (String v : execution.getVariableNames()) {
            logger.info("Variable " + v + " = " + execution.getVariable(v));
            WfProcessVariable pv = new WfProcessVariable();
            pv.setName(v);
            Object o = execution.getVariable(v);
            pv.setValue(o != null ? o.toString() : null);
            event.getWfProcessVariable().add(pv);
        }
        logger.info("(end of event data, sending camel message)");
        logger.info("(camel message sent)");
    }

    public void notify(WfProcessInstanceEventType event) throws Exception {
        logger.info("(custom camel message sent)");
    }

    private String marshal(WfProcessInstanceEventType event) throws Exception {
        ObjectFactory of = new ObjectFactory();
        if (event instanceof WfProcessInstanceStartedEventType) {
            of.createWfProcessInstanceStartedEvent((WfProcessInstanceStartedEventType)event);
        } else if (event instanceof WfProcessInstanceFinishedEventType) {
            of.createWfProcessInstanceFinishedEvent((WfProcessInstanceFinishedEventType)event);
        } else {
            of.createWfProcessInstanceEvent(event);
        }
        return null;
    }
}

