/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.wf.activiti;

import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.wf.WfHook;
import com.evolveum.midpoint.wf.activiti.ActivitiEngine;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessInstanceEventType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class Activiti2Idm {
    @Autowired(required=true)
    ActivitiEngine activitiEngine;
    @Autowired(required=true)
    TaskManager taskManager;
    @Autowired(required=true)
    WfHook wfHook;
    private static final Trace LOGGER = TraceManager.getTrace(Activiti2Idm.class);

    public void onWorkflowMessage(Object o) {
        OperationResult result = new OperationResult("onWorkflowMessage");
        LOGGER.info("onWorkflowMessage starting.");
        try {
            String taskOid;
            WfProcessInstanceEventType event;
            if (o instanceof WfProcessInstanceEventType) {
                event = (WfProcessInstanceEventType)o;
                LOGGER.info("Received WfProcessInstanceEvent: " + event);
                taskOid = event.getMidpointTaskOid();
                if (taskOid == null) {
                    throw new Exception("Got a workflow message without taskOid: " + event.toString());
                }
            } else {
                throw new Exception("Unknown message type coming from the workflow: " + o);
            }
            Task task = this.taskManager.getTask(taskOid, result);
            this.wfHook.processWorkflowMessage(event, task, result);
        }
        catch (Exception e) {
            String message = "Couldn't process an event coming from the workflow management system";
            LoggingUtils.logException((Trace)LOGGER, (String)message, (Throwable)e, (Object[])new Object[0]);
            result.recordFatalError(message, (Throwable)e);
        }
        result.computeStatus();
        LOGGER.info("onWorkflowMessage ending; operation result status = " + result.getStatus());
    }
}

