/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.wf;

import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskExecutionStatus;
import com.evolveum.midpoint.task.api.TaskHandler;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.task.api.TaskRunResult;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.wf.WfHook;
import com.evolveum.midpoint.wf.WfTaskUtil;
import com.evolveum.midpoint.wf.WorkflowManager;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WfTaskHandler
implements TaskHandler,
InitializingBean {
    public static final String WF_SHADOW_TASK_URI = "http://evolveum.com/wf-shadow-task-uri";
    @Autowired(required=true)
    private WfHook workflowHook;
    @Autowired(required=true)
    private TaskManager taskManager;
    @Autowired(required=true)
    private WorkflowManager workflowManager;
    private static final Trace LOGGER = TraceManager.getTrace(WfTaskHandler.class);

    public TaskRunResult run(Task task) {
        if (this.workflowManager.isEnabled()) {
            if (task.getExecutionStatus() == TaskExecutionStatus.CLOSED) {
                LOGGER.info("Task " + task.getName() + " has been flagged as closed, so exit the run() method.");
            } else {
                PrismProperty idProp = task.getExtension(WfTaskUtil.WFPROCESSID_PROPERTY_NAME);
                Collection values = null;
                if (idProp != null) {
                    values = idProp.getRealValues(String.class);
                }
                if (values == null || values.isEmpty()) {
                    LOGGER.error("Process ID is not known for task " + task.getName());
                } else {
                    String id = (String)values.iterator().next();
                    LOGGER.info("Task " + task.getName() + ": requesting status for wf process id " + id + "...");
                    this.workflowHook.queryProcessInstance(id, task, null);
                }
            }
        } else {
            LOGGER.info("Workflow management is not currently enabled, skipping the task run.");
        }
        TaskRunResult result = new TaskRunResult();
        result.setRunResultStatus(TaskRunResult.TaskRunResultStatus.FINISHED);
        return result;
    }

    public Long heartbeat(Task task) {
        return null;
    }

    public void refreshStatus(Task task) {
    }

    public String getCategoryName(Task task) {
        return "Workflow";
    }

    public List<String> getCategoryNames() {
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        if (this.taskManager != null) {
            LOGGER.trace("Registering with taskManager as a handler for http://evolveum.com/wf-shadow-task-uri");
            this.taskManager.registerHandler(WF_SHADOW_TASK_URI, (TaskHandler)this);
        } else {
            LOGGER.error("Cannot register with taskManager as taskManager == null");
        }
    }
}

