/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.wf;

import com.evolveum.midpoint.model.api.hooks.ChangeHook;
import com.evolveum.midpoint.model.api.hooks.HookOperationMode;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskManager;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.LoggingUtils;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.wf.WfProcessStartCommand;
import com.evolveum.midpoint.wf.WfTaskUtil;
import com.evolveum.midpoint.wf.activiti.Idm2Activiti;
import com.evolveum.midpoint.wf.wrappers.WfProcessWrapper;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ModelOperationStageType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessInstanceEventType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessInstanceFinishedEventType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessInstanceStartedEventType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfProcessVariable;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfQueryProcessInstanceCommandType;
import com.evolveum.midpoint.xml.ns._public.communication.workflow_1.WfStartProcessInstanceCommandType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WfHook
implements ChangeHook {
    public static final String WORKFLOW_HOOK_URI = "http://midpoint.evolveum.com/model/workflow-hook-1";
    private static final Trace LOGGER = TraceManager.getTrace(WfHook.class);
    @Autowired(required=true)
    private TaskManager taskManager;
    @Autowired(required=true)
    private WfTaskUtil taskUtil;
    @Autowired(required=true)
    private Idm2Activiti idm2Activiti;
    private List<WfProcessWrapper> wrappers = new ArrayList<WfProcessWrapper>();

    public HookOperationMode preChangePrimary(Collection<ObjectDelta<? extends ObjectType>> changes, Task task, OperationResult result) {
        Validate.notNull(changes);
        Validate.notNull((Object)task);
        Validate.notNull((Object)result);
        LOGGER.trace("=====================================================================");
        LOGGER.trace("preChangePrimary: " + changes.toString());
        if (changes.size() != 1) {
            return this.reportHookError(result, "Invalid number of objectDeltas in preChangePrimary (" + changes.size() + "), expected 1");
        }
        return this.executeProcessStart(ModelOperationStageType.PRIMARY, changes, task, result);
    }

    public void registerWfProcessWrapper(WfProcessWrapper starter) {
        LOGGER.trace("Registering process wrapper: " + starter.getClass().getName());
        this.wrappers.add(starter);
    }

    public HookOperationMode preChangeSecondary(Collection<ObjectDelta<? extends ObjectType>> changes, Task task, OperationResult result) {
        LOGGER.trace("=====================================================================");
        LOGGER.trace("preChangeSecondary: " + this.dump(changes));
        return this.executeProcessStart(ModelOperationStageType.SECONDARY, changes, task, result);
    }

    public HookOperationMode postChange(Collection<ObjectDelta<? extends ObjectType>> changes, Task task, OperationResult result) {
        LOGGER.trace("=====================================================================");
        LOGGER.trace("postChange: " + changes.toString());
        for (ObjectDelta<? extends ObjectType> change : changes) {
            LOGGER.trace(change.debugDump());
        }
        return HookOperationMode.FOREGROUND;
    }

    private HookOperationMode executeProcessStart(ModelOperationStageType stage, Collection<ObjectDelta<? extends ObjectType>> changes, Task task, OperationResult result) {
        for (WfProcessWrapper wrapper : this.wrappers) {
            LOGGER.debug("Trying wrapper: " + wrapper.getClass().getName());
            WfProcessStartCommand startCommand = wrapper.startProcessIfNeeded(stage, changes, task);
            if (startCommand == null) continue;
            LOGGER.debug("Wrapper " + wrapper.getClass().getName() + " prepared the following wf process start command: " + startCommand);
            try {
                this.startProcessInstance(startCommand, wrapper, task, result);
            }
            catch (Exception e) {
                LoggingUtils.logException((Trace)LOGGER, (String)"Workflow process instance couldn't be started", (Throwable)e, (Object[])new Object[0]);
                return HookOperationMode.ERROR;
            }
            return HookOperationMode.BACKGROUND;
        }
        LOGGER.debug("No wrapper served this request, returning the FOREGROUND flag.");
        return HookOperationMode.FOREGROUND;
    }

    private String dump(Collection<ObjectDelta<? extends ObjectType>> changes) {
        StringBuffer sb = new StringBuffer();
        for (ObjectDelta<? extends ObjectType> change : changes) {
            sb.append(change.debugDump());
            sb.append('\n');
        }
        return sb.toString();
    }

    private HookOperationMode reportHookError(OperationResult result, String message) {
        LOGGER.error(message);
        result.recordFatalError(message);
        return HookOperationMode.ERROR;
    }

    private void startProcessInstance(WfProcessStartCommand startCommand, WfProcessWrapper wrapper, Task task, OperationResult parentResult) throws ObjectNotFoundException, SchemaException, ObjectAlreadyExistsException {
        LOGGER.trace(" === startProcessInstance starting ===");
        if (!task.isTransient()) {
            throw new IllegalStateException("Workflow-related task should be transient but it is persistent; task = " + task);
        }
        String taskName = "Workflow process-watching task " + (long)(Math.random() * 1000000.0);
        if (startCommand.isSimple()) {
            this.taskUtil.prepareActiveTask(task, taskName, parentResult);
        } else {
            this.taskUtil.preparePassiveTask(task, taskName, parentResult);
        }
        this.taskUtil.setProcessWrapper(task, wrapper);
        this.taskManager.switchToBackground(task, parentResult);
        this.taskUtil.recordProcessState(task, "Workflow process instance creation is being requested.", "", null, parentResult);
        WfStartProcessInstanceCommandType spicmd = new WfStartProcessInstanceCommandType();
        spicmd.setMidpointTaskOid(task.getOid());
        spicmd.setWfProcessName(startCommand.getProcessName());
        spicmd.setSendStartConfirmation(Boolean.valueOf(startCommand.isSimple()));
        this.setProcessVariables(spicmd, startCommand.getProcessVariables());
        try {
            this.idm2Activiti.idm2activiti(spicmd);
        }
        catch (Exception e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't send a request to start a process instance to workflow management system", (Throwable)e, (Object[])new Object[0]);
            this.taskUtil.recordProcessState(task, "Workflow process instance creation could not be requested: " + e, "", null, parentResult);
            parentResult.recordPartialError("Couldn't send a request to start a process instance to workflow management system", (Throwable)e);
        }
        parentResult.recordSuccessIfUnknown();
        LOGGER.trace(" === startProcessInstance ending ===");
    }

    private void setProcessVariables(WfStartProcessInstanceCommandType spicmd, Map<String, String> variables) {
        for (Map.Entry<String, String> e : variables.entrySet()) {
            WfProcessVariable var = new WfProcessVariable();
            var.setName(e.getKey());
            var.setValue(e.getValue());
            spicmd.getWfProcessVariable().add(var);
        }
    }

    void finishProcessing(WfProcessInstanceEventType event, Task task, OperationResult result) throws Exception {
        if (task == null) {
            task = this.taskManager.getTask(event.getMidpointTaskOid(), result);
        }
        WfProcessWrapper wrapper = this.taskUtil.getProcessWrapper(task, this.wrappers);
        wrapper.finishProcess(event, task, result);
    }

    void queryProcessInstance(String id, Task task, OperationResult parentResult) {
        String taskOid = task.getOid();
        Validate.notEmpty((String)taskOid, (String)"Task oid must not be null or empty (task must be persistent).");
        if (parentResult == null) {
            parentResult = new OperationResult("queryProcessInstance");
        }
        WfQueryProcessInstanceCommandType qpicmd = new WfQueryProcessInstanceCommandType();
        qpicmd.setMidpointTaskOid(taskOid);
        qpicmd.setWfProcessInstanceId(id);
        try {
            this.idm2Activiti.idm2activiti(qpicmd);
        }
        catch (Exception e) {
            LoggingUtils.logException((Trace)LOGGER, (String)"Couldn't send a request to query a process instance to workflow management system", (Throwable)e, (Object[])new Object[0]);
            parentResult.recordPartialError("Couldn't send a request to query a process instance to workflow management system", (Throwable)e);
        }
        parentResult.recordSuccessIfUnknown();
    }

    public void processWorkflowMessage(WfProcessInstanceEventType event, Task task, OperationResult result) throws Exception {
        String pid = event.getWfProcessInstanceId();
        String description = event.getWfStateDescription();
        if (description == null || description.isEmpty()) {
            if (event instanceof WfProcessInstanceStartedEventType) {
                description = "Workflow process instance has been created (process id " + pid + ")";
            } else if (event instanceof WfProcessInstanceFinishedEventType) {
                description = "Workflow process instance has been ended (process id " + pid + ")";
            } else if (event instanceof WfProcessInstanceEventType) {
                description = "Workflow process instance has proceeded further (process id " + pid + ")";
            }
        }
        String details = this.taskUtil.dumpVariables(event);
        this.taskUtil.recordProcessState(task, description, details, event, result);
        if (event instanceof WfProcessInstanceStartedEventType) {
            this.taskUtil.setWfProcessId(task, event.getWfProcessInstanceId(), result);
        }
        if (event instanceof WfProcessInstanceFinishedEventType) {
            this.finishProcessing(event, task, result);
        }
    }
}

