/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.init;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.common.crypto.AESProtector;
import com.evolveum.midpoint.common.crypto.Protector;
import com.evolveum.midpoint.init.ProtectorConfiguration;
import com.evolveum.midpoint.util.ClassPathUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;
import org.apache.commons.configuration.Configuration;
import org.springframework.beans.factory.annotation.Autowired;

public class ConfigurableProtectorFactory {
    private static final String PROTECTOR_CONFIGURATION = "midpoint.keystore";
    private static final Trace LOGGER = TraceManager.getTrace(ConfigurableProtectorFactory.class);
    @Autowired(required=true)
    private MidpointConfiguration configuration;
    private ProtectorConfiguration protectorConfig;

    public void init() {
        Configuration config = this.configuration.getConfiguration(PROTECTOR_CONFIGURATION);
        this.protectorConfig = new ProtectorConfiguration(config);
        if (config.getString("midpoint.home") == null) {
            return;
        }
        File ks = new File(this.protectorConfig.getKeyStorePath());
        if (ks.exists()) {
            return;
        }
        String keyStoreName = ks.getName();
        if (!ClassPathUtil.extractFileFromClassPath((String)("com/../../" + keyStoreName), (String)this.protectorConfig.getKeyStorePath()).booleanValue()) {
            ClassPathUtil.extractFileFromClassPath((String)keyStoreName, (String)this.protectorConfig.getKeyStorePath());
        }
    }

    public Protector getProtector() {
        AESProtector protector = new AESProtector();
        protector.setEncryptionKeyAlias(this.protectorConfig.getEncryptionKeyAlias());
        protector.setKeyStorePassword(this.protectorConfig.getKeyStorePassword());
        protector.setKeyStorePath(this.protectorConfig.getKeyStorePath());
        protector.setXmlCipher(this.protectorConfig.getXmlCipher());
        protector.init();
        return protector;
    }
}

