/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.init;

import com.evolveum.midpoint.common.configuration.api.MidpointConfiguration;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.schema.MidPointPrismContextFactory;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;

public class ConfigurablePrismContextFactory
extends MidPointPrismContextFactory {
    private static final Trace LOGGER = TraceManager.getTrace(ConfigurablePrismContextFactory.class);
    private static final String CONFIGURATION_GLOBAL = "midpoint.global";
    private static final String EXTENSION_DIR = "extensionDir";
    private MidpointConfiguration configuration;

    ConfigurablePrismContextFactory() {
    }

    public MidpointConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(MidpointConfiguration configuration) {
        this.configuration = configuration;
    }

    protected void registerExtensionSchemas(SchemaRegistry schemaRegistry) throws SchemaException {
        Configuration config = this.configuration.getConfiguration(CONFIGURATION_GLOBAL);
        if (config == null) {
            LOGGER.warn("Global part 'midpoint.global' is not defined in configuration file.");
            return;
        }
        String extensionDir = config.getString(EXTENSION_DIR);
        if (StringUtils.isEmpty((String)extensionDir) && StringUtils.isNotEmpty((String)this.configuration.getMidpointHome())) {
            extensionDir = String.valueOf(this.configuration.getMidpointHome()) + "/schema";
        }
        if (!StringUtils.isNotEmpty((String)extensionDir)) {
            LOGGER.warn("Not loading extension schemas, extensionDir or even midpoint.home is not defined.");
            return;
        }
        LOGGER.info("Loading extension schemas from folder '{}'.", new Object[]{extensionDir});
        try {
            File file = new File(extensionDir);
            if (!file.exists() || !file.isDirectory()) {
                LOGGER.warn("Extension dir '{}' does not exist, or is not a directory, skipping extension loading.", new Object[]{extensionDir});
                return;
            }
            schemaRegistry.registerPrismSchemasFromDirectory(file);
        }
        catch (Exception ex) {
            throw new SchemaException(ex.getMessage(), (Throwable)ex);
        }
    }
}

