/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.init;

import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;

public class ApplicationHomeSetup {
    private static final transient Trace LOGGER = TraceManager.getTrace(ApplicationHomeSetup.class);
    private String MIDPOINT_HOME;

    public void init(String midpointHome) {
        this.MIDPOINT_HOME = midpointHome;
        LOGGER.info(String.valueOf(this.MIDPOINT_HOME) + " = " + System.getProperty(this.MIDPOINT_HOME));
        System.out.println(String.valueOf(this.MIDPOINT_HOME) + " = " + System.getProperty(this.MIDPOINT_HOME));
        String mh = System.getProperty(this.MIDPOINT_HOME);
        if (!this.checkDirectoryExistence(mh)) {
            this.createDir(mh);
        }
        this.directorySetup(mh);
    }

    protected void directorySetup(String midpointHomeDir) {
        String[] directories;
        String[] stringArray = directories = new String[]{String.valueOf(midpointHomeDir) + "/icf-connectors", String.valueOf(midpointHomeDir) + "/idm-legacy", String.valueOf(midpointHomeDir) + "/log", String.valueOf(midpointHomeDir) + "/schema"};
        int n = directories.length;
        int n2 = 0;
        while (n2 < n) {
            String directory = stringArray[n2];
            if (!this.checkDirectoryExistence(directory)) {
                LOGGER.warn("Missing directory '{}'. Regeneration in progress...", new Object[]{directory});
                this.createDir(directory);
            }
            ++n2;
        }
    }

    private boolean checkDirectoryExistence(String dir) {
        File d = new File(dir);
        if (d.isFile()) {
            LOGGER.error(String.valueOf(dir) + " is file and NOT a directory.");
            throw new SystemException(String.valueOf(dir) + " is file and NOT a directory !!!");
        }
        if (d.isDirectory()) {
            LOGGER.info("Directory " + dir + " already exists. Reusing it.");
            return true;
        }
        return false;
    }

    private void createDir(String dir) {
        File d = new File(dir);
        if (d.exists() && d.isDirectory()) {
            return;
        }
        Boolean st = d.mkdirs();
        if (!st.booleanValue()) {
            LOGGER.error("Unable to create directory " + dir + " as user " + System.getProperty("user.name"));
        }
    }
}

