/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http;

import java.net.HttpURLConnection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transport.http.Headers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cookies {
    private final Map<String, Cookie> sessionCookies = new ConcurrentHashMap<String, Cookie>();
    private boolean maintainSession;

    public Map<String, Cookie> getSessionCookies() {
        return this.sessionCookies;
    }

    public void readFromConnection(HttpURLConnection connection) {
        if (this.maintainSession) {
            for (Map.Entry<String, List<String>> h : connection.getHeaderFields().entrySet()) {
                if (!"Set-Cookie".equalsIgnoreCase(h.getKey())) continue;
                this.handleSetCookie(h.getValue());
            }
        }
    }

    public void writeToMessageHeaders(Message message) {
        this.maintainSession = MessageUtils.getContextualBoolean((Message)message, (String)Message.MAINTAIN_SESSION, (boolean)false);
        if (this.maintainSession && this.sessionCookies.size() > 0) {
            new Headers(message).writeSessionCookies(this.sessionCookies);
        }
    }

    private void handleSetCookie(List<String> headers) {
        if (headers == null || headers.size() == 0) {
            return;
        }
        for (String header : headers) {
            String[] cookies;
            for (String cookie : cookies = header.split(",")) {
                String[] parts = cookie.split(";");
                String[] kv = parts[0].split("=", 2);
                if (kv.length != 2) continue;
                String name = kv[0].trim();
                String value = kv[1].trim();
                Cookie newCookie = new Cookie(name, value);
                for (int i = 1; i < parts.length; ++i) {
                    kv = parts[i].split("=", 2);
                    name = kv[0].trim();
                    String string = value = kv.length > 1 ? kv[1].trim() : null;
                    if (name.equalsIgnoreCase("discard")) {
                        newCookie.setMaxAge(0);
                        continue;
                    }
                    if (name.equalsIgnoreCase("max-age") && value != null) {
                        try {
                            newCookie.setMaxAge(Integer.parseInt(value));
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    if (!name.equalsIgnoreCase("path") || value == null) continue;
                    newCookie.setPath(value);
                }
                if (newCookie.getMaxAge() != 0) {
                    this.sessionCookies.put(newCookie.getName(), newCookie);
                    continue;
                }
                this.sessionCookies.remove(newCookie.getName());
            }
        }
    }
}

