/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.serializer.xml;

import java.io.Writer;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.serializer.XmlObjectSerializer;
import org.identityconnectors.framework.impl.serializer.xml.XmlObjectEncoder;

public class XmlObjectSerializerImpl
implements XmlObjectSerializer {
    public static final String MULTI_OBJECT_ELEMENT = "MultiObject";
    public static final String CONNECTORS_DTD = "connectors.dtd";
    private final Writer _output;
    private final boolean _multiObject;
    private final boolean _includeHeader;
    private boolean _firstObjectWritten;
    private boolean _documentEnded;

    public XmlObjectSerializerImpl(Writer output, boolean includeHeader, boolean multiObject) {
        this._output = output;
        this._includeHeader = includeHeader;
        this._multiObject = multiObject;
    }

    public void writeObject(Object object) {
        if (this._documentEnded) {
            throw new IllegalStateException("Attempt to writeObject after the document is already closed");
        }
        StringBuilder buf = new StringBuilder();
        XmlObjectEncoder encoder = new XmlObjectEncoder(buf);
        String elementName = encoder.writeObject(object);
        if (!this._firstObjectWritten) {
            this.startDocument(elementName);
        } else if (!this._multiObject) {
            throw new IllegalStateException("Attempt to write multiple objects on a single-object document");
        }
        this.write(buf.toString());
        this._firstObjectWritten = true;
    }

    public void flush() {
        try {
            this._output.flush();
        }
        catch (Exception e) {
            throw ConnectorException.wrap(e);
        }
    }

    public void close(boolean closeStream) {
        if (!this._documentEnded) {
            if (!this._firstObjectWritten) {
                if (!this._multiObject) {
                    throw new IllegalStateException("Attempt to write zero objects on a single-object document");
                }
                this.startDocument(null);
            }
            this.writeEndDocument();
            this._documentEnded = true;
        }
        if (closeStream) {
            try {
                this._output.close();
            }
            catch (Exception e) {
                throw ConnectorException.wrap(e);
            }
        }
    }

    private void startDocument(String firstElement) {
        if (this._includeHeader) {
            String docType = this._multiObject ? MULTI_OBJECT_ELEMENT : firstElement;
            String line1 = "<?xml version='1.0' encoding='UTF-8'?>\n";
            String line2 = "<!DOCTYPE " + docType + " PUBLIC '" + CONNECTORS_DTD + "' '" + CONNECTORS_DTD + "'>\n";
            this.write(line1);
            this.write(line2);
        }
        if (this._multiObject) {
            String line3 = "<MultiObject>\n";
            this.write(line3);
        }
    }

    private void writeEndDocument() {
        if (this._multiObject) {
            String line1 = "</MultiObject>\n";
            this.write(line1);
        }
    }

    private void write(String str) {
        try {
            this._output.write(str);
        }
        catch (Exception e) {
            throw ConnectorException.wrap(e);
        }
    }
}

