/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.List;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.api.ResultsHandlerConfiguration;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.filter.Filter;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.impl.api.local.operations.AttributesToGetResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.DuplicateFilteringResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.FilteredResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.NormalizingResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.ObjectNormalizerFacade;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.SearchOp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchImpl
extends ConnectorAPIOperationRunner
implements SearchApiOp {
    public SearchImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    @Override
    public void search(ObjectClass oclass, Filter originalFilter, ResultsHandler handler, OperationOptions options) {
        Assertions.nullCheck(oclass, "oclass");
        Assertions.nullCheck(handler, "handler");
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        SearchOp search = (SearchOp)((Object)this.getConnector());
        ResultsHandlerConfiguration hdlCfg = null != this.getOperationalContext() ? this.getOperationalContext().getResultsHandlerConfiguration() : new ResultsHandlerConfiguration();
        ResultsHandler handlerChain = handler;
        Filter finalFilter = originalFilter;
        if (hdlCfg.isEnableNormalizingResultsHandler()) {
            ObjectNormalizerFacade normalizer = this.getNormalizer(oclass);
            NormalizingResultsHandler normalizingHandler = new NormalizingResultsHandler(handler, normalizer);
            Filter normalizedFilter = normalizer.normalizeFilter(originalFilter);
            if (hdlCfg.isEnableFilteredResultsHandler()) {
                handlerChain = new FilteredResultsHandler(normalizingHandler, normalizedFilter);
                finalFilter = normalizedFilter;
            } else {
                handlerChain = normalizingHandler;
            }
        } else if (hdlCfg.isEnableFilteredResultsHandler()) {
            FilteredResultsHandler filteredHandler = new FilteredResultsHandler(handler, originalFilter);
        }
        if (hdlCfg.isEnableAttributesToGetSearchResultsHandler()) {
            handlerChain = this.getAttributesToGetResutlsHandler(handlerChain, options);
        }
        SearchImpl.rawSearch(search, oclass, finalFilter, handlerChain, options);
    }

    public static void rawSearch(SearchOp<?> search, ObjectClass oclass, Filter filter, ResultsHandler handler, OperationOptions options) {
        FilterTranslator<?> translator = search.createFilterTranslator(oclass, options);
        List<?> queries = translator.translate(filter);
        if (queries.size() == 0) {
            search.executeQuery(oclass, null, handler, options);
        } else {
            boolean eliminateDups;
            boolean bl = eliminateDups = queries.size() > 1;
            if (eliminateDups) {
                handler = new DuplicateFilteringResultsHandler(handler);
            }
            for (Object query : queries) {
                DuplicateFilteringResultsHandler h;
                SearchOp<?> hack = search;
                hack.executeQuery(oclass, query, handler, options);
                if (!(handler instanceof DuplicateFilteringResultsHandler) || (h = (DuplicateFilteringResultsHandler)handler).isStillHandling()) continue;
                break;
            }
        }
    }

    private ResultsHandler getAttributesToGetResutlsHandler(ResultsHandler handler, OperationOptions options) {
        ResultsHandler ret = handler;
        String[] attrsToGet = options.getAttributesToGet();
        if (attrsToGet != null && attrsToGet.length > 0) {
            ret = new AttributesToGetSearchResultsHandler(handler, attrsToGet);
        }
        return ret;
    }

    public static class AttributesToGetSearchResultsHandler
    extends AttributesToGetResultsHandler
    implements ResultsHandler {
        private final ResultsHandler _handler;

        public AttributesToGetSearchResultsHandler(ResultsHandler handler, String[] attrsToGet) {
            super(attrsToGet);
            Assertions.nullCheck(handler, "handler");
            this._handler = handler;
        }

        public boolean handle(ConnectorObject obj) {
            obj = this.reduceToAttrsToGet(obj);
            return this._handler.handle(obj);
        }
    }
}

