/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ConnectorFacade;
import org.identityconnectors.framework.api.ConnectorFacadeFactory;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.AbstractConnectorFacade;
import org.identityconnectors.framework.impl.api.AbstractConnectorInfo;
import org.identityconnectors.framework.impl.api.local.ConnectorPoolManager;
import org.identityconnectors.framework.impl.api.local.LocalConnectorFacadeImpl;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.remote.RemoteConnectorFacadeImpl;

public class ConnectorFacadeFactoryImpl
extends ConnectorFacadeFactory {
    private static final Log _log = Log.getLog(ConnectorFacadeFactoryImpl.class);

    public ConnectorFacade newInstance(APIConfiguration config) {
        AbstractConnectorFacade ret = null;
        APIConfigurationImpl impl = (APIConfigurationImpl)config;
        AbstractConnectorInfo connectorInfo = impl.getConnectorInfo();
        if (connectorInfo instanceof LocalConnectorInfoImpl) {
            LocalConnectorInfoImpl localInfo = (LocalConnectorInfoImpl)connectorInfo;
            try {
                ret = new LocalConnectorFacadeImpl(localInfo, impl);
            }
            catch (Exception ex) {
                String connector = impl.getConnectorInfo().getConnectorKey().toString();
                _log.error(ex, "Failed to create new connector facade: {0}, {1}", connector, config);
                throw ConnectorException.wrap(ex);
            }
        } else {
            ret = new RemoteConnectorFacadeImpl(impl);
        }
        return ret;
    }

    public void dispose() {
        ConnectorPoolManager.dispose();
    }
}

