/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ResultsHandlerConfiguration;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.impl.api.AbstractConnectorInfo;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class APIConfigurationImpl
implements APIConfiguration {
    private ObjectPoolConfiguration _connectorPoolConfiguration;
    private ResultsHandlerConfiguration _resultsHandlerConfiguration;
    private boolean _isConnectorPoolingSupported;
    private ConfigurationPropertiesImpl _configurationProperties;
    private int _bufferSize = 100;
    private Map<Class<? extends APIOperation>, Integer> _timeoutMap = new HashMap<Class<? extends APIOperation>, Integer>();
    private Set<Class<? extends APIOperation>> _supportedOperations;
    private transient AbstractConnectorInfo _connectorInfo;

    public AbstractConnectorInfo getConnectorInfo() {
        return this._connectorInfo;
    }

    public void setConnectorInfo(AbstractConnectorInfo connectorInfo) {
        this._connectorInfo = connectorInfo;
    }

    public void setConnectorPoolingSupported(boolean supported) {
        this._isConnectorPoolingSupported = supported;
    }

    public void setConnectorPoolConfiguration(ObjectPoolConfiguration config) {
        this._connectorPoolConfiguration = config;
    }

    public void setConfigurationProperties(ConfigurationPropertiesImpl properties) {
        if (this._configurationProperties != null) {
            this._configurationProperties.setParent(null);
        }
        this._configurationProperties = properties;
        if (this._configurationProperties != null) {
            this._configurationProperties.setParent(this);
        }
    }

    public Map<Class<? extends APIOperation>, Integer> getTimeoutMap() {
        return this._timeoutMap;
    }

    public void setTimeoutMap(Map<Class<? extends APIOperation>, Integer> map) {
        this._timeoutMap = map;
    }

    public void setSupportedOperations(Set<Class<? extends APIOperation>> op) {
        this._supportedOperations = op;
    }

    @Override
    public boolean isConnectorPoolingSupported() {
        return this._isConnectorPoolingSupported;
    }

    @Override
    public ObjectPoolConfiguration getConnectorPoolConfiguration() {
        if (this._connectorPoolConfiguration == null) {
            this._connectorPoolConfiguration = new ObjectPoolConfiguration();
        }
        return this._connectorPoolConfiguration;
    }

    @Override
    public ConfigurationPropertiesImpl getConfigurationProperties() {
        return this._configurationProperties;
    }

    @Override
    public int getTimeout(Class<? extends APIOperation> operation) {
        Integer ret = this._timeoutMap.get(operation);
        if (ret == null) {
            ret = -1;
        }
        return ret;
    }

    @Override
    public Set<Class<? extends APIOperation>> getSupportedOperations() {
        return CollectionUtil.newReadOnlySet(this._supportedOperations);
    }

    @Override
    public void setTimeout(Class<? extends APIOperation> operation, int timeout) {
        this._timeoutMap.put(operation, timeout);
    }

    @Override
    public void setProducerBufferSize(int size) {
        this._bufferSize = size;
    }

    @Override
    public int getProducerBufferSize() {
        return this._bufferSize;
    }

    @Override
    public ResultsHandlerConfiguration getResultsHandlerConfiguration() {
        if (null == this._resultsHandlerConfiguration) {
            this._resultsHandlerConfiguration = new ResultsHandlerConfiguration();
        }
        return this._resultsHandlerConfiguration;
    }

    public void setResultsHandlerConfiguration(ResultsHandlerConfiguration config) {
        this._resultsHandlerConfiguration = config;
    }
}

