/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.EnumSet;
import java.util.Set;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeInfoBuilder {
    private String _name;
    private Class<?> _type;
    private final EnumSet<AttributeInfo.Flags> _flags;

    public AttributeInfoBuilder() {
        this.setType(String.class);
        this._flags = EnumSet.noneOf(AttributeInfo.Flags.class);
    }

    public AttributeInfoBuilder(String name) {
        this(name, String.class);
    }

    public AttributeInfoBuilder(String name, Class<?> type) {
        this.setName(name);
        this.setType(type);
        this._flags = EnumSet.noneOf(AttributeInfo.Flags.class);
    }

    public AttributeInfo build() {
        return new AttributeInfo(this._name, this._type, this._flags);
    }

    public AttributeInfoBuilder setName(String name) {
        if (StringUtil.isBlank(name)) {
            throw new IllegalArgumentException("Argument must not be blank.");
        }
        this._name = name;
        return this;
    }

    public AttributeInfoBuilder setType(Class<?> value) {
        FrameworkUtil.checkAttributeType(value);
        this._type = value;
        return this;
    }

    public AttributeInfoBuilder setReadable(boolean value) {
        this.setFlag(AttributeInfo.Flags.NOT_READABLE, !value);
        return this;
    }

    public AttributeInfoBuilder setCreateable(boolean value) {
        this.setFlag(AttributeInfo.Flags.NOT_CREATABLE, !value);
        return this;
    }

    public AttributeInfoBuilder setRequired(boolean value) {
        this.setFlag(AttributeInfo.Flags.REQUIRED, value);
        return this;
    }

    public AttributeInfoBuilder setMultiValued(boolean value) {
        this.setFlag(AttributeInfo.Flags.MULTIVALUED, value);
        return this;
    }

    public AttributeInfoBuilder setUpdateable(boolean value) {
        this.setFlag(AttributeInfo.Flags.NOT_UPDATEABLE, !value);
        return this;
    }

    public AttributeInfoBuilder setReturnedByDefault(boolean value) {
        this.setFlag(AttributeInfo.Flags.NOT_RETURNED_BY_DEFAULT, !value);
        return this;
    }

    public AttributeInfoBuilder setFlags(Set<AttributeInfo.Flags> flags) {
        this._flags.clear();
        if (flags != null) {
            this._flags.addAll(flags);
        }
        return this;
    }

    private void setFlag(AttributeInfo.Flags flag, boolean value) {
        if (value) {
            this._flags.add(flag);
        } else {
            this._flags.remove((Object)flag);
        }
    }

    public static AttributeInfo build(String name, Class<?> type, Set<AttributeInfo.Flags> flags) {
        return new AttributeInfoBuilder(name, type).setFlags(flags).build();
    }

    public static AttributeInfo build(String name, Class<?> type) {
        return AttributeInfoBuilder.build(name, type, null);
    }

    public static AttributeInfo build(String name) {
        return AttributeInfoBuilder.build(name, String.class);
    }
}

