/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.common.logging.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.logging.LogSpi;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKLogger
implements LogSpi {
    private volatile ConcurrentMap<String, Logger> map = new ConcurrentHashMap<String, Logger>(1);

    @Override
    public void log(Class<?> clazz, String methodName, Log.Level level, String message, Throwable ex) {
        String clazzName = clazz.getName();
        Level jdkLevel = this.getJDKLevel(level);
        Logger logger = this.getJDKLogger(clazzName);
        if (ex == null) {
            logger.logp(jdkLevel, clazzName, methodName, message);
        } else {
            logger.logp(jdkLevel, clazzName, methodName, message, ex);
        }
    }

    @Override
    public boolean isLoggable(Class<?> clazz, Log.Level level) {
        return this.getJDKLogger(clazz.getName()).isLoggable(this.getJDKLevel(level));
    }

    Level getJDKLevel(Log.Level level) {
        Level ret = Level.SEVERE;
        if (Log.Level.OK.equals((Object)level)) {
            ret = Level.FINE;
        } else if (Log.Level.INFO.equals((Object)level)) {
            ret = Level.INFO;
        } else if (Log.Level.WARN.equals((Object)level)) {
            ret = Level.WARNING;
        }
        return ret;
    }

    Logger getJDKLogger(String key) {
        Logger aLogger = (Logger)this.map.get(key);
        if (aLogger == null) {
            aLogger = Logger.getLogger(key);
            Logger old = this.map.putIfAbsent(key, aLogger);
            aLogger = old != null ? old : aLogger;
        }
        return aLogger;
    }

    ConcurrentMap<String, Logger> getMap() {
        return this.map;
    }
}

