/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util.xml;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.util.xml.Attribute;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Element {
    protected String uri;
    protected String tagName;
    protected Map<String, Attribute> attributeMap = new HashMap<String, Attribute>();
    protected int line;
    protected int column;
    protected StringBuilder text = new StringBuilder();
    protected List<Element> elements = new ArrayList<Element>();

    public Element(String uri, String localName, String qName, Attributes attributes, Locator locator) {
        this.uri = uri;
        String string = this.tagName = uri == null || uri.equals("") ? qName : localName;
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String attributeUri = attributes.getURI(i);
                String name = attributeUri == null || attributeUri.equals("") ? attributes.getQName(i) : attributes.getLocalName(i);
                String value = attributes.getValue(i);
                this.attributeMap.put(this.composeMapKey(attributeUri, name), new Attribute(name, value, attributeUri));
            }
        }
        if (locator != null) {
            this.line = locator.getLineNumber();
            this.column = locator.getColumnNumber();
        }
    }

    public List<Element> elements(String tagName) {
        return this.elementsNS(null, tagName);
    }

    public List<Element> elementsNS(String nameSpaceUri, String tagName) {
        ArrayList<Element> selectedElements = new ArrayList<Element>();
        for (Element element : this.elements) {
            if (!tagName.equals(element.getTagName()) || nameSpaceUri != null && (nameSpaceUri == null || !nameSpaceUri.equals(element.getUri()))) continue;
            selectedElements.add(element);
        }
        return selectedElements;
    }

    public Element element(String tagName) {
        return this.elementNS(null, tagName);
    }

    public Element elementNS(String nameSpaceUri, String tagName) {
        List<Element> elements = this.elementsNS(nameSpaceUri, tagName);
        if (elements.size() == 0) {
            return null;
        }
        if (elements.size() > 1) {
            throw new ActivitiException("Parsing exception: multiple elements with tag name " + tagName + " found");
        }
        return elements.get(0);
    }

    public void add(Element element) {
        this.elements.add(element);
    }

    public String attribute(String name) {
        if (this.attributeMap.containsKey(name)) {
            return this.attributeMap.get(name).getValue();
        }
        return null;
    }

    public Set<String> attributes() {
        return this.attributeMap.keySet();
    }

    public String attributeNS(String namespaceUri, String name) {
        return this.attribute(this.composeMapKey(namespaceUri, name));
    }

    public String attribute(String name, String defaultValue) {
        if (this.attributeMap.containsKey(name)) {
            return this.attributeMap.get(name).getValue();
        }
        return defaultValue;
    }

    public String attributeNS(String namespaceUri, String name, String defaultValue) {
        return this.attribute(this.composeMapKey(namespaceUri, name), defaultValue);
    }

    protected String composeMapKey(String attributeUri, String attributeName) {
        StringBuilder strb = new StringBuilder();
        if (attributeUri != null && !attributeUri.equals("")) {
            strb.append(attributeUri);
            strb.append(":");
        }
        strb.append(attributeName);
        return strb.toString();
    }

    public List<Element> elements() {
        return this.elements;
    }

    public String toString() {
        return "<" + this.tagName + "...";
    }

    public String getUri() {
        return this.uri;
    }

    public String getTagName() {
        return this.tagName;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public void appendText(String text) {
        this.text.append(text);
    }

    public String getText() {
        return this.text.toString();
    }

    public void collectIds(List<String> ids) {
        ids.add(this.attribute("id"));
        for (Element child : this.elements) {
            child.collectIds(ids);
        }
    }
}

