/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util.io;

import java.io.InputStream;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.util.io.StreamSource;

public class ResourceStreamSource
implements StreamSource {
    String resource;
    ClassLoader classLoader;

    public ResourceStreamSource(String resource) {
        this.resource = resource;
    }

    public ResourceStreamSource(String resource, ClassLoader classLoader) {
        this.resource = resource;
        this.classLoader = classLoader;
    }

    public InputStream getInputStream() {
        InputStream inputStream = null;
        if (this.classLoader == null) {
            inputStream = ReflectUtil.getResourceAsStream(this.resource);
        } else {
            this.classLoader.getResourceAsStream(this.resource);
        }
        if (inputStream == null) {
            throw new ActivitiException("resource '" + this.resource + "' doesn't exist");
        }
        return inputStream;
    }

    public String toString() {
        return "Resource[" + this.resource + "]";
    }
}

