/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.rules;

import java.util.Map;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.persistence.entity.DeploymentEntity;
import org.drools.KnowledgeBase;

public class RulesHelper {
    public static KnowledgeBase findKnowledgeBaseByDeploymentId(String deploymentId) {
        Map<String, Object> knowledgeBaseCache = Context.getProcessEngineConfiguration().getDeploymentCache().getKnowledgeBaseCache();
        KnowledgeBase knowledgeBase = (KnowledgeBase)knowledgeBaseCache.get(deploymentId);
        if (knowledgeBase == null) {
            DeploymentEntity deployment = Context.getCommandContext().getDeploymentManager().findDeploymentById(deploymentId);
            if (deployment == null) {
                throw new ActivitiException("no deployment with id " + deploymentId);
            }
            Context.getProcessEngineConfiguration().getDeploymentCache().deploy(deployment);
            knowledgeBase = (KnowledgeBase)knowledgeBaseCache.get(deploymentId);
            if (knowledgeBase == null) {
                throw new ActivitiException("deployment " + deploymentId + " doesn't contain any rules");
            }
        }
        return knowledgeBase;
    }
}

