/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.HashMap;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class VariableInstanceEntity
implements ValueFields,
PersistentObject,
Serializable {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected int revision;
    protected String name;
    protected String processInstanceId;
    protected String executionId;
    protected String taskId;
    protected Long longValue;
    protected Double doubleValue;
    protected String textValue;
    protected String textValue2;
    protected ByteArrayEntity byteArrayValue;
    protected String byteArrayValueId;
    protected Object cachedValue;
    protected VariableType type;

    protected VariableInstanceEntity() {
    }

    public static VariableInstanceEntity createAndInsert(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = VariableInstanceEntity.create(name, type, value);
        Context.getCommandContext().getDbSqlSession().insert(variableInstance);
        return variableInstance;
    }

    public static VariableInstanceEntity create(String name, VariableType type, Object value) {
        VariableInstanceEntity variableInstance = new VariableInstanceEntity();
        variableInstance.name = name;
        variableInstance.type = type;
        variableInstance.setValue(value);
        return variableInstance;
    }

    public void setExecution(ExecutionEntity execution) {
        this.executionId = execution.getId();
        this.processInstanceId = execution.getProcessInstanceId();
    }

    public void delete() {
        DbSqlSession dbSqlSession = Context.getCommandContext().getDbSqlSession();
        dbSqlSession.delete(VariableInstanceEntity.class, this.id);
        if (this.byteArrayValueId != null) {
            this.getByteArrayValue();
            dbSqlSession.delete(ByteArrayEntity.class, this.byteArrayValueId);
        }
    }

    public void setByteArrayValue(ByteArrayEntity byteArrayValue) {
        this.byteArrayValue = byteArrayValue;
        this.byteArrayValueId = byteArrayValue != null ? byteArrayValue.getId() : null;
    }

    public Object getPersistentState() {
        HashMap<String, Object> persistentState = new HashMap<String, Object>();
        if (this.longValue != null) {
            persistentState.put("longValue", this.longValue);
        }
        if (this.doubleValue != null) {
            persistentState.put("doubleValue", this.doubleValue);
        }
        if (this.textValue != null) {
            persistentState.put("textValue", this.textValue);
        }
        if (this.byteArrayValueId != null) {
            persistentState.put("byteArrayValueId", this.byteArrayValueId);
        }
        return persistentState;
    }

    public int getRevisionNext() {
        return this.revision + 1;
    }

    public void setProcessInstanceId(String processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public void setExecutionId(String executionId) {
        this.executionId = executionId;
    }

    public void setByteArrayValueId(String byteArrayValueId) {
        this.byteArrayValueId = byteArrayValueId;
        this.byteArrayValue = null;
    }

    public ByteArrayEntity getByteArrayValue() {
        if (this.byteArrayValue == null && this.byteArrayValueId != null) {
            this.byteArrayValue = Context.getCommandContext().getDbSqlSession().selectById(ByteArrayEntity.class, this.byteArrayValueId);
        }
        return this.byteArrayValue;
    }

    public Object getValue() {
        if (!this.type.isCachable() || this.cachedValue == null) {
            this.cachedValue = this.type.getValue(this);
        }
        return this.cachedValue;
    }

    public void setValue(Object value) {
        this.type.setValue(value, this);
        this.cachedValue = value;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getByteArrayValueId() {
        return this.byteArrayValueId;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public String getProcessInstanceId() {
        return this.processInstanceId;
    }

    public String getExecutionId() {
        return this.executionId;
    }

    public Long getLongValue() {
        return this.longValue;
    }

    public void setLongValue(Long longValue) {
        this.longValue = longValue;
    }

    public Double getDoubleValue() {
        return this.doubleValue;
    }

    public void setDoubleValue(Double doubleValue) {
        this.doubleValue = doubleValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public String getName() {
        return this.name;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public void setType(VariableType type) {
        this.type = type;
    }

    public VariableType getType() {
        return this.type;
    }

    public Object getCachedValue() {
        return this.cachedValue;
    }

    public void setCachedValue(Object cachedValue) {
        this.cachedValue = cachedValue;
    }

    public String getTextValue2() {
        return this.textValue2;
    }

    public void setTextValue2(String textValue2) {
        this.textValue2 = textValue2;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }
}

