/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractManager;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.task.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskManager
extends AbstractManager {
    public void deleteTasksByProcessInstanceId(String processInstanceId, String deleteReason, boolean cascade) {
        List tasks = this.getDbSqlSession().createTaskQuery().processInstanceId(processInstanceId).list();
        String reason = deleteReason == null || deleteReason.isEmpty() ? "deleted" : deleteReason;
        for (TaskEntity task : tasks) {
            this.deleteTask(task, reason, cascade);
        }
    }

    public void deleteTask(TaskEntity task, String deleteReason, boolean cascade) {
        if (!task.isDeleted()) {
            task.setDeleted(true);
            CommandContext commandContext = Context.getCommandContext();
            String taskId = task.getId();
            List<Task> subTasks = this.findTasksByParentTaskId(taskId);
            for (Task subTask : subTasks) {
                this.deleteTask((TaskEntity)subTask, deleteReason, cascade);
            }
            commandContext.getIdentityLinkManager().deleteIdentityLinksByTaskId(taskId);
            commandContext.getVariableInstanceManager().deleteVariableInstanceByTask(task);
            if (cascade) {
                commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(taskId);
            } else {
                commandContext.getHistoricTaskInstanceManager().markTaskInstanceEnded(taskId, deleteReason);
            }
            this.getDbSqlSession().delete(TaskEntity.class, task.getId());
        }
    }

    public TaskEntity findTaskById(String id) {
        if (id == null) {
            throw new ActivitiException("Invalid task id : null");
        }
        return (TaskEntity)this.getDbSqlSession().selectOne("selectTask", id);
    }

    public List<Task> findTasksByQueryCriteria(TaskQueryImpl taskQuery, Page page) {
        String query = "selectTaskByQueryCriteria";
        return this.getDbSqlSession().selectList("selectTaskByQueryCriteria", taskQuery, page);
    }

    public long findTaskCountByQueryCriteria(TaskQueryImpl taskQuery) {
        return (Long)this.getDbSqlSession().selectOne("selectTaskCountByQueryCriteria", taskQuery);
    }

    public List<Task> findTasksByParentTaskId(String parentTaskId) {
        return this.getDbSqlSession().selectList("selectTasksByParentTaskId", parentTaskId);
    }

    public void deleteTask(String taskId, boolean cascade) {
        TaskEntity task = Context.getCommandContext().getTaskManager().findTaskById(taskId);
        if (task != null) {
            this.deleteTask(task, "deleted", cascade);
        } else if (cascade) {
            Context.getCommandContext().getHistoricTaskInstanceManager().deleteHistoricTaskInstanceById(taskId);
        }
    }
}

