/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.Collections;
import java.util.List;
import org.activiti.engine.history.HistoricProcessInstance;
import org.activiti.engine.impl.HistoricProcessInstanceQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.AbstractHistoricManager;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoricProcessInstanceManager
extends AbstractHistoricManager {
    public HistoricProcessInstanceEntity findHistoricProcessInstance(String processInstanceId) {
        if (this.historyLevel > 0) {
            return this.getDbSqlSession().selectById(HistoricProcessInstanceEntity.class, processInstanceId);
        }
        return null;
    }

    public void deleteHistoricProcessInstanceByProcessDefinitionId(String processDefinitionId) {
        if (this.historyLevel > 0) {
            List historicProcessInstanceIds = this.getDbSqlSession().selectList("selectHistoricProcessInstanceIdsByProcessDefinitionId", processDefinitionId);
            for (String historicProcessInstanceId : historicProcessInstanceIds) {
                this.deleteHistoricProcessInstanceById(historicProcessInstanceId);
            }
        }
    }

    public void deleteHistoricProcessInstanceById(String historicProcessInstanceId) {
        if (this.historyLevel > 0) {
            CommandContext commandContext = Context.getCommandContext();
            commandContext.getHistoricDetailManager().deleteHistoricDetailsByProcessInstanceId(historicProcessInstanceId);
            commandContext.getHistoricActivityInstanceManager().deleteHistoricActivityInstancesByProcessInstanceId(historicProcessInstanceId);
            commandContext.getHistoricTaskInstanceManager().deleteHistoricTaskInstancesByProcessInstanceId(historicProcessInstanceId);
            this.getDbSqlSession().delete(HistoricProcessInstanceEntity.class, historicProcessInstanceId);
        }
    }

    public long findHistoricProcessInstanceCountByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery) {
        if (this.historyLevel > 0) {
            return (Long)this.getDbSqlSession().selectOne("selectHistoricProcessInstanceCountByQueryCriteria", historicProcessInstanceQuery);
        }
        return 0L;
    }

    public List<HistoricProcessInstance> findHistoricProcessInstancesByQueryCriteria(HistoricProcessInstanceQueryImpl historicProcessInstanceQuery, Page page) {
        if (this.historyLevel > 0) {
            return this.getDbSqlSession().selectList("selectHistoricProcessInstancesByQueryCriteria", historicProcessInstanceQuery, page);
        }
        return Collections.EMPTY_LIST;
    }
}

