/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.history.handler;

import java.util.List;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;

public class ActivityInstanceEndHandler
implements ExecutionListener {
    public void notify(DelegateExecution execution) {
        ExecutionEntity executionEntity = (ExecutionEntity)execution;
        HistoricActivityInstanceEntity historicActivityInstance = ActivityInstanceEndHandler.findActivityInstance(executionEntity);
        if (historicActivityInstance != null) {
            historicActivityInstance.markEnded(null);
        }
    }

    public static HistoricActivityInstanceEntity findActivityInstance(ExecutionEntity execution) {
        CommandContext commandContext = Context.getCommandContext();
        String executionId = execution.getId();
        String activityId = execution.getActivityId();
        DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
        List<HistoricActivityInstanceEntity> cachedHistoricActivityInstances = dbSqlSession.findInCache(HistoricActivityInstanceEntity.class);
        for (HistoricActivityInstanceEntity cachedHistoricActivityInstance : cachedHistoricActivityInstances) {
            if (!executionId.equals(cachedHistoricActivityInstance.getExecutionId()) || activityId == null || !activityId.equals(cachedHistoricActivityInstance.getActivityId()) || cachedHistoricActivityInstance.getEndTime() != null) continue;
            return cachedHistoricActivityInstance;
        }
        List historicActivityInstances = new HistoricActivityInstanceQueryImpl(commandContext).executionId(executionId).activityId(activityId).unfinished().listPage(0, 1);
        if (!historicActivityInstances.isEmpty()) {
            return (HistoricActivityInstanceEntity)historicActivityInstances.get(0);
        }
        if (execution.getParentId() != null) {
            return ActivityInstanceEndHandler.findActivityInstance(execution.getParent());
        }
        return null;
    }
}

