/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.ActivitiOptimisticLockingException;
import org.activiti.engine.ActivitiWrongDbException;
import org.activiti.engine.impl.DeploymentQueryImpl;
import org.activiti.engine.impl.ExecutionQueryImpl;
import org.activiti.engine.impl.GroupQueryImpl;
import org.activiti.engine.impl.HistoricActivityInstanceQueryImpl;
import org.activiti.engine.impl.HistoricDetailQueryImpl;
import org.activiti.engine.impl.HistoricProcessInstanceQueryImpl;
import org.activiti.engine.impl.HistoricTaskInstanceQueryImpl;
import org.activiti.engine.impl.JobQueryImpl;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.ProcessDefinitionQueryImpl;
import org.activiti.engine.impl.ProcessInstanceQueryImpl;
import org.activiti.engine.impl.TaskQueryImpl;
import org.activiti.engine.impl.UserQueryImpl;
import org.activiti.engine.impl.cfg.ProcessEngineConfigurationImpl;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSessionFactory;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.db.upgrade.DbUpgradeStep;
import org.activiti.engine.impl.interceptor.Session;
import org.activiti.engine.impl.persistence.entity.PropertyEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.util.ClassNameUtil;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;
import org.activiti.engine.impl.variable.DeserializedObject;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbSqlSession
implements Session {
    private static Logger log = Logger.getLogger(DbSqlSession.class.getName());
    protected SqlSession sqlSession;
    protected DbSqlSessionFactory dbSqlSessionFactory;
    protected List<PersistentObject> insertedObjects = new ArrayList<PersistentObject>();
    protected Map<Class<?>, Map<String, CachedObject>> cachedObjects = new HashMap();
    protected List<DeleteOperation> deletedObjects = new ArrayList<DeleteOperation>();
    protected List<DeserializedObject> deserializedObjects = new ArrayList<DeserializedObject>();
    protected String connectionMetadataDefaultCatalog = null;
    protected String connectionMetadataDefaultSchema = null;
    public static String[] JDBC_METADATA_TABLE_TYPES = new String[]{"TABLE"};

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession();
    }

    public DbSqlSession(DbSqlSessionFactory dbSqlSessionFactory, Connection connection, String catalog, String schema) {
        this.dbSqlSessionFactory = dbSqlSessionFactory;
        this.sqlSession = dbSqlSessionFactory.getSqlSessionFactory().openSession(connection);
        this.connectionMetadataDefaultCatalog = catalog;
        this.connectionMetadataDefaultSchema = schema;
    }

    public void insert(PersistentObject persistentObject) {
        if (persistentObject.getId() == null) {
            String id = this.dbSqlSessionFactory.getIdGenerator().getNextId();
            persistentObject.setId(id);
        }
        this.insertedObjects.add(persistentObject);
        this.cachePut(persistentObject, false);
    }

    public void delete(Class<?> persistentObjectClass, String persistentObjectId) {
        for (DeleteOperation deleteOperation : this.deletedObjects) {
            if (!(deleteOperation instanceof DeleteById)) continue;
            DeleteById deleteById = (DeleteById)deleteOperation;
            if (!persistentObjectClass.equals(deleteById.persistenceObjectClass) || !persistentObjectId.equals(deleteById.persistentObjectId)) continue;
            return;
        }
        this.deletedObjects.add(new DeleteById(persistentObjectClass, persistentObjectId));
    }

    public void delete(String statement, Object parameter) {
        this.deletedObjects.add(new DeleteBulk(statement, parameter));
    }

    public List selectList(String statement) {
        return this.selectList(statement, null);
    }

    public List selectList(String statement, Object parameter) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        List loadedObjects = this.sqlSession.selectList(statement, parameter);
        return this.filterLoadedObjects(loadedObjects);
    }

    public List selectList(String statement, Object parameter, Page page) {
        statement = this.dbSqlSessionFactory.mapStatement(statement);
        List loadedObjects = page != null ? this.sqlSession.selectList(statement, parameter, new RowBounds(page.getFirstResult(), page.getMaxResults())) : this.sqlSession.selectList(statement, parameter);
        return this.filterLoadedObjects(loadedObjects);
    }

    public Object selectOne(String statement, Object parameter) {
        Object result = this.sqlSession.selectOne(statement = this.dbSqlSessionFactory.mapStatement(statement), parameter);
        if (result instanceof PersistentObject) {
            PersistentObject loadedObject = (PersistentObject)result;
            result = this.cacheFilter(loadedObject);
        }
        return result;
    }

    public <T extends PersistentObject> T selectById(Class<T> entityClass, String id) {
        PersistentObject persistentObject = (PersistentObject)this.cacheGet(entityClass, id);
        if (persistentObject != null) {
            return (T)persistentObject;
        }
        String selectStatement = this.dbSqlSessionFactory.getSelectStatement(entityClass);
        persistentObject = (PersistentObject)this.sqlSession.selectOne(selectStatement = this.dbSqlSessionFactory.mapStatement(selectStatement), (Object)id);
        if (persistentObject == null) {
            return null;
        }
        this.cachePut(persistentObject, true);
        return (T)persistentObject;
    }

    protected List filterLoadedObjects(List<Object> loadedObjects) {
        if (loadedObjects.isEmpty()) {
            return loadedObjects;
        }
        if (!PersistentObject.class.isAssignableFrom(loadedObjects.get(0).getClass())) {
            return loadedObjects;
        }
        ArrayList<PersistentObject> filteredObjects = new ArrayList<PersistentObject>(loadedObjects.size());
        for (Object loadedObject : loadedObjects) {
            PersistentObject cachedPersistentObject = this.cacheFilter((PersistentObject)loadedObject);
            filteredObjects.add(cachedPersistentObject);
        }
        return filteredObjects;
    }

    protected CachedObject cachePut(PersistentObject persistentObject, boolean storeState) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(persistentObject.getClass());
        if (classCache == null) {
            classCache = new HashMap<String, CachedObject>();
            this.cachedObjects.put(persistentObject.getClass(), classCache);
        }
        CachedObject cachedObject = new CachedObject(persistentObject, storeState);
        classCache.put(persistentObject.getId(), cachedObject);
        return cachedObject;
    }

    protected PersistentObject cacheFilter(PersistentObject persistentObject) {
        PersistentObject cachedPersistentObject = (PersistentObject)this.cacheGet(persistentObject.getClass(), persistentObject.getId());
        if (cachedPersistentObject != null) {
            return cachedPersistentObject;
        }
        this.cachePut(persistentObject, true);
        return persistentObject;
    }

    protected <T> T cacheGet(Class<T> entityClass, String id) {
        CachedObject cachedObject = null;
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            cachedObject = classCache.get(id);
        }
        if (cachedObject != null) {
            return (T)cachedObject.getPersistentObject();
        }
        return null;
    }

    protected void cacheRemove(Class<?> persistentObjectClass, String persistentObjectId) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(persistentObjectClass);
        if (classCache == null) {
            return;
        }
        classCache.remove(persistentObjectId);
    }

    public <T> List<T> findInCache(Class<T> entityClass) {
        Map<String, CachedObject> classCache = this.cachedObjects.get(entityClass);
        if (classCache != null) {
            ArrayList<PersistentObject> entities = new ArrayList<PersistentObject>(classCache.size());
            for (CachedObject cachedObject : classCache.values()) {
                entities.add(cachedObject.getPersistentObject());
            }
            return entities;
        }
        return Collections.emptyList();
    }

    public void addDeserializedObject(Object deserializedObject, byte[] serializedBytes, VariableInstanceEntity variableInstanceEntity) {
        this.deserializedObjects.add(new DeserializedObject(deserializedObject, serializedBytes, variableInstanceEntity));
    }

    @Override
    public void flush() {
        this.removeUnnecessaryOperations();
        this.flushDeserializedObjects();
        List<PersistentObject> updatedObjects = this.getUpdatedObjects();
        if (log.isLoggable(Level.FINE)) {
            log.fine("flush summary:");
            for (PersistentObject insertedObject : this.insertedObjects) {
                log.fine("  insert " + this.toString(insertedObject));
            }
            for (PersistentObject updatedObject : updatedObjects) {
                log.fine("  update " + this.toString(updatedObject));
            }
            for (DeleteOperation deleteOperation : this.deletedObjects) {
                log.fine("  " + deleteOperation);
            }
            log.fine("now executing flush...");
        }
        this.flushInserts();
        this.flushUpdates(updatedObjects);
        this.flushDeletes();
    }

    protected void removeUnnecessaryOperations() {
        ArrayList<DeleteOperation> deletedObjectsCopy = new ArrayList<DeleteOperation>(this.deletedObjects);
        for (DeleteOperation deleteOperation : deletedObjectsCopy) {
            if (!(deleteOperation instanceof DeleteById)) continue;
            DeleteById deleteById = (DeleteById)deleteOperation;
            PersistentObject insertedObject = this.findInsertedObject(deleteById.persistenceObjectClass, deleteById.persistentObjectId);
            if (insertedObject != null) {
                this.insertedObjects.remove(insertedObject);
                this.deletedObjects.remove(deleteOperation);
            }
            this.cacheRemove(deleteById.persistenceObjectClass, deleteById.persistentObjectId);
        }
        for (PersistentObject insertedObject : this.insertedObjects) {
            this.cacheRemove(insertedObject.getClass(), insertedObject.getId());
        }
    }

    protected PersistentObject findInsertedObject(Class<?> persistenceObjectClass, String persistentObjectId) {
        for (PersistentObject insertedObject : this.insertedObjects) {
            if (!insertedObject.getClass().equals(persistenceObjectClass) || !insertedObject.getId().equals(persistentObjectId)) continue;
            return insertedObject;
        }
        return null;
    }

    protected void flushDeserializedObjects() {
        for (DeserializedObject deserializedObject : this.deserializedObjects) {
            deserializedObject.flush();
        }
    }

    public List<PersistentObject> getUpdatedObjects() {
        ArrayList<PersistentObject> updatedObjects = new ArrayList<PersistentObject>();
        for (Class<?> clazz : this.cachedObjects.keySet()) {
            Map<String, CachedObject> classCache = this.cachedObjects.get(clazz);
            for (CachedObject cachedObject : classCache.values()) {
                PersistentObject persistentObject = cachedObject.getPersistentObject();
                if (this.deletedObjects.contains(persistentObject)) continue;
                Object originalState = cachedObject.getPersistentObjectState();
                if (!originalState.equals(persistentObject.getPersistentState())) {
                    updatedObjects.add(persistentObject);
                    continue;
                }
                log.finest("loaded object '" + persistentObject + "' was not updated");
            }
        }
        return updatedObjects;
    }

    public <T extends PersistentObject> List<T> pruneDeletedEntities(List<T> listToPrune) {
        ArrayList<T> prunedList = new ArrayList<T>(listToPrune);
        for (PersistentObject potentiallyDeleted : listToPrune) {
            for (DeleteOperation deleteOperation : this.deletedObjects) {
                if (!(deleteOperation instanceof DeleteById)) continue;
                DeleteById deleteById = (DeleteById)deleteOperation;
                if (!potentiallyDeleted.getClass().equals(deleteById.persistenceObjectClass) || !potentiallyDeleted.getId().equals(deleteById.persistentObjectId)) continue;
                prunedList.remove(potentiallyDeleted);
            }
        }
        return prunedList;
    }

    protected void flushInserts() {
        for (PersistentObject insertedObject : this.insertedObjects) {
            String insertStatement = this.dbSqlSessionFactory.getInsertStatement(insertedObject);
            if ((insertStatement = this.dbSqlSessionFactory.mapStatement(insertStatement)) == null) {
                throw new ActivitiException("no insert statement for " + insertedObject.getClass() + " in the ibatis mapping files");
            }
            log.fine("inserting: " + this.toString(insertedObject));
            this.sqlSession.insert(insertStatement, (Object)insertedObject);
        }
        this.insertedObjects.clear();
    }

    protected void flushUpdates(List<PersistentObject> updatedObjects) {
        for (PersistentObject updatedObject : updatedObjects) {
            String updateStatement = this.dbSqlSessionFactory.getUpdateStatement(updatedObject);
            if ((updateStatement = this.dbSqlSessionFactory.mapStatement(updateStatement)) == null) {
                throw new ActivitiException("no update statement for " + updatedObject.getClass() + " in the ibatis mapping files");
            }
            log.fine("updating: " + this.toString(updatedObject) + "]");
            int updatedRecords = this.sqlSession.update(updateStatement, (Object)updatedObject);
            if (updatedRecords == 1) continue;
            throw new ActivitiOptimisticLockingException(this.toString(updatedObject) + " was updated by another transaction concurrently");
        }
        updatedObjects.clear();
    }

    protected void flushDeletes() {
        for (DeleteOperation delete : this.deletedObjects) {
            log.fine("executing: " + delete);
            delete.execute();
        }
        this.deletedObjects.clear();
    }

    @Override
    public void close() {
        this.sqlSession.close();
    }

    public void commit() {
        this.sqlSession.commit();
    }

    public void rollback() {
        this.sqlSession.rollback();
    }

    protected String toString(PersistentObject persistentObject) {
        if (persistentObject == null) {
            return "null";
        }
        return ClassNameUtil.getClassNameWithoutPackage(persistentObject) + "[" + persistentObject.getId() + "]";
    }

    public void dbSchemaCheckVersion() {
        try {
            String dbVersion = this.getDbVersion();
            if (!"5.9".equals(dbVersion)) {
                throw new ActivitiWrongDbException("5.9", dbVersion);
            }
            String errorMessage = null;
            if (!this.isEngineTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "engine");
            }
            if (this.dbSqlSessionFactory.isDbHistoryUsed() && !this.isHistoryTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "history");
            }
            if (this.dbSqlSessionFactory.isDbIdentityUsed() && !this.isIdentityTablePresent()) {
                errorMessage = this.addMissingComponent(errorMessage, "identity");
            }
            Integer configuredHistoryLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
            PropertyEntity historyLevelProperty = this.selectById(PropertyEntity.class, "historyLevel");
            if (historyLevelProperty == null) {
                if (errorMessage == null) {
                    errorMessage = "";
                }
                errorMessage = errorMessage + "no historyLevel property specified";
            } else {
                Integer databaseHistoryLevel = new Integer(historyLevelProperty.getValue());
                if (!configuredHistoryLevel.equals(databaseHistoryLevel)) {
                    if (errorMessage == null) {
                        errorMessage = "";
                    }
                    errorMessage = errorMessage + "historyLevel mismatch: configuration says " + configuredHistoryLevel + " and database says " + databaseHistoryLevel;
                }
            }
            if (errorMessage != null) {
                throw new ActivitiException("Activiti database problem: " + errorMessage);
            }
        }
        catch (Exception e) {
            if (this.isMissingTablesException(e)) {
                throw new ActivitiException("no activiti tables in db.  set <property name=\"databaseSchemaUpdate\" to value=\"true\" or value=\"create-drop\" (use create-drop for testing only!) in bean processEngineConfiguration in activiti.cfg.xml for automatic schema creation", e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ActivitiException("couldn't get db schema version", e);
        }
        log.fine("activiti db schema check successful");
    }

    protected String addMissingComponent(String missingComponents, String component) {
        if (missingComponents == null) {
            return "Tables missing for component(s) " + component;
        }
        return missingComponents + ", " + component;
    }

    protected String getDbVersion() {
        String selectSchemaVersionStatement = this.dbSqlSessionFactory.mapStatement("selectDbSchemaVersion");
        return (String)this.sqlSession.selectOne(selectSchemaVersionStatement);
    }

    public void dbSchemaCreate() {
        ProcessEngineConfigurationImpl processEngineConfiguration = Context.getProcessEngineConfiguration();
        int configuredHistoryLevel = processEngineConfiguration.getHistoryLevel();
        if (!processEngineConfiguration.isDbHistoryUsed() && configuredHistoryLevel > 0) {
            throw new ActivitiException("historyLevel config is higher then 'none' and dbHistoryUsed is set to false");
        }
        if (this.isEngineTablePresent()) {
            String dbVersion = this.getDbVersion();
            if (!"5.9".equals(dbVersion)) {
                throw new ActivitiWrongDbException("5.9", dbVersion);
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (processEngineConfiguration.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (processEngineConfiguration.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
    }

    protected void dbSchemaCreateIdentity() {
        this.executeMandatorySchemaResource("create", "identity");
    }

    protected void dbSchemaCreateHistory() {
        this.executeMandatorySchemaResource("create", "history");
    }

    protected void dbSchemaCreateEngine() {
        this.executeMandatorySchemaResource("create", "engine");
        int configuredHistoryLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        PropertyEntity property = new PropertyEntity("historyLevel", Integer.toString(configuredHistoryLevel));
        this.insert(property);
    }

    public void dbSchemaDrop() {
        this.executeMandatorySchemaResource("drop", "engine");
        if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
        if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.executeMandatorySchemaResource("drop", "identity");
        }
    }

    public void dbSchemaPrune() {
        if (this.isHistoryTablePresent() && !this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.executeMandatorySchemaResource("drop", "history");
        }
        if (this.isIdentityTablePresent() && this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.executeMandatorySchemaResource("drop", "identity");
        }
    }

    public void executeMandatorySchemaResource(String operation, String component) {
        this.executeSchemaResource(operation, component, this.getResourceForDbOperation(operation, operation, component), false);
    }

    public String dbSchemaUpdate() {
        String feedback = null;
        String dbVersion = null;
        boolean isUpgradeNeeded = false;
        if (this.isEngineTablePresent()) {
            PropertyEntity dbVersionProperty = this.selectById(PropertyEntity.class, "schema.version");
            dbVersion = dbVersionProperty.getValue();
            boolean bl = isUpgradeNeeded = !"5.9".equals(dbVersion);
            if (isUpgradeNeeded) {
                PropertyEntity dbHistoryProperty;
                dbVersionProperty.setValue("5.9");
                if ("5.0".equals(dbVersion)) {
                    dbHistoryProperty = new PropertyEntity("schema.history", "create(5.0)");
                    this.insert(dbHistoryProperty);
                } else {
                    dbHistoryProperty = this.selectById(PropertyEntity.class, "schema.history");
                }
                String dbHistoryValue = dbHistoryProperty.getValue() + " upgrade(" + dbVersion + "->" + "5.9" + ")";
                dbHistoryProperty.setValue(dbHistoryValue);
                this.dbSchemaUpgrade("engine", dbVersion);
                feedback = "upgraded Activiti from " + dbVersion + " to " + "5.9";
            }
        } else {
            this.dbSchemaCreateEngine();
        }
        if (this.isHistoryTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("history", dbVersion);
            }
        } else if (this.dbSqlSessionFactory.isDbHistoryUsed()) {
            this.dbSchemaCreateHistory();
        }
        if (this.isIdentityTablePresent()) {
            if (isUpgradeNeeded) {
                this.dbSchemaUpgrade("identity", dbVersion);
            }
        } else if (this.dbSqlSessionFactory.isDbIdentityUsed()) {
            this.dbSchemaCreateIdentity();
        }
        return feedback;
    }

    public boolean isEngineTablePresent() {
        return this.isTablePresent("ACT_RU_EXECUTION");
    }

    public boolean isHistoryTablePresent() {
        return this.isTablePresent("ACT_HI_PROCINST");
    }

    public boolean isIdentityTablePresent() {
        return this.isTablePresent("ACT_ID_USER");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTablePresent(String tableName) {
        boolean bl;
        Connection connection = null;
        connection = this.sqlSession.getConnection();
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        ResultSet tables = null;
        String schema = this.connectionMetadataDefaultSchema;
        String databaseType = this.dbSqlSessionFactory.getDatabaseType();
        if ("postgres".equals(databaseType)) {
            tableName = tableName.toLowerCase();
        }
        if ("oracle".equals(databaseType) && schema == null) {
            schema = databaseMetaData.getUserName();
            log.info("oracle database used and schema not set; assuming schema " + schema);
        }
        try {
            tables = databaseMetaData.getTables(this.connectionMetadataDefaultCatalog, schema, tableName, JDBC_METADATA_TABLE_TYPES);
            bl = tables.next();
        }
        catch (Throwable throwable) {
            try {
                tables.close();
                throw throwable;
            }
            catch (Exception e) {
                throw new ActivitiException("couldn't check if tables are already present using metadata: " + e.getMessage(), e);
            }
        }
        tables.close();
        return bl;
    }

    protected void dbSchemaUpgrade(String component, String dbVersion) {
        log.info("upgrading activiti " + component + " schema from " + dbVersion + " to " + "5.9");
        if (dbVersion.endsWith("-SNAPSHOT")) {
            dbVersion = dbVersion.substring(0, dbVersion.length() - "-SNAPSHOT".length());
        }
        int minorDbVersionNumber = Integer.parseInt(dbVersion.substring(2));
        String libraryVersion = "5.9";
        if ("5.9".endsWith("-SNAPSHOT")) {
            libraryVersion = "5.9".substring(0, "5.9".length() - "-SNAPSHOT".length());
        }
        int minorLibraryVersionNumber = Integer.parseInt(libraryVersion.substring(2));
        while (minorDbVersionNumber < minorLibraryVersionNumber) {
            this.executeSchemaResource("upgrade", component, this.getResourceForDbOperation("upgrade", "upgradestep.5" + minorDbVersionNumber + ".to.5" + (minorDbVersionNumber + 1), component), true);
            ++minorDbVersionNumber;
        }
    }

    public String getResourceForDbOperation(String directory, String operation, String component) {
        String databaseType = this.dbSqlSessionFactory.getDatabaseType();
        return "org/activiti/db/" + directory + "/activiti." + databaseType + "." + operation + "." + component + ".sql";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeSchemaResource(String operation, String component, String resourceName, boolean isOptional) {
        InputStream inputStream = null;
        try {
            inputStream = ReflectUtil.getResourceAsStream(resourceName);
            if (inputStream == null) {
                if (!isOptional) throw new ActivitiException("resource '" + resourceName + "' is not available");
                log.fine("no schema resource " + resourceName + " for " + operation);
                return;
            } else {
                this.executeSchemaResource(operation, component, resourceName, inputStream);
            }
            return;
        }
        finally {
            IoUtil.closeSilently(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSchemaResource(String operation, String component, String resourceName, InputStream inputStream) {
        log.info("performing " + operation + " on " + component + " with resource " + resourceName);
        String sqlStatement = null;
        String exceptionSqlStatement = null;
        try {
            Connection connection = this.sqlSession.getConnection();
            Exception exception = null;
            byte[] bytes = IoUtil.readInputStream(inputStream, resourceName);
            String ddlStatements = new String(bytes);
            BufferedReader reader = new BufferedReader(new StringReader(ddlStatements));
            String line = this.readNextTrimmedLine(reader);
            while (line != null) {
                if (line.startsWith("# ")) {
                    log.fine(line.substring(2));
                } else if (line.startsWith("-- ")) {
                    log.fine(line.substring(3));
                } else {
                    if (line.startsWith("execute java ")) {
                        String upgradestepClassName = line.substring(13).trim();
                        DbUpgradeStep dbUpgradeStep = null;
                        try {
                            dbUpgradeStep = (DbUpgradeStep)ReflectUtil.instantiate(upgradestepClassName);
                        }
                        catch (ActivitiException e) {
                            throw new ActivitiException("database update java class '" + upgradestepClassName + "' can't be instantiated: " + e.getMessage(), e);
                        }
                        try {
                            dbUpgradeStep.execute(this);
                        }
                        catch (Exception e) {
                            throw new ActivitiException("error while executing database update java class '" + upgradestepClassName + "': " + e.getMessage(), e);
                        }
                    }
                    if (line.length() > 0) {
                        if (line.endsWith(";")) {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line.substring(0, line.length() - 1));
                            Statement jdbcStatement = connection.createStatement();
                            try {
                                jdbcStatement.execute(sqlStatement);
                                jdbcStatement.close();
                            }
                            catch (Exception e) {
                                if (exception == null) {
                                    exception = e;
                                    exceptionSqlStatement = sqlStatement;
                                }
                                log.log(Level.SEVERE, "problem during schema " + operation + ", statement '" + sqlStatement, e);
                            }
                            finally {
                                sqlStatement = null;
                            }
                        } else {
                            sqlStatement = this.addSqlStatementPiece(sqlStatement, line);
                        }
                    }
                }
                line = this.readNextTrimmedLine(reader);
            }
            if (exception != null) {
                throw exception;
            }
            log.fine("activiti db schema " + operation + " for component " + component + " successful");
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't " + operation + " db schema: " + exceptionSqlStatement, e);
        }
    }

    protected String addSqlStatementPiece(String sqlStatement, String line) {
        if (sqlStatement == null) {
            return line;
        }
        return sqlStatement + " \n" + line;
    }

    protected String readNextTrimmedLine(BufferedReader reader) throws IOException {
        String line = reader.readLine();
        if (line != null) {
            line = line.trim();
        }
        return line;
    }

    protected boolean isMissingTablesException(Exception e) {
        String exceptionMessage = e.getMessage();
        if (e.getMessage() != null) {
            if (exceptionMessage.indexOf("Table") != -1 && exceptionMessage.indexOf("not found") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("Table") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("doesn't exist") != -1) {
                return true;
            }
            if ((exceptionMessage.indexOf("relation") != -1 || exceptionMessage.indexOf("table") != -1) && exceptionMessage.indexOf("does not exist") != -1) {
                return true;
            }
        }
        return false;
    }

    public void performSchemaOperationsProcessEngineBuild() {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("drop-create".equals(databaseSchemaUpdate)) {
            try {
                this.dbSchemaDrop();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        if ("create-drop".equals(databaseSchemaUpdate) || "drop-create".equals(databaseSchemaUpdate) || "create".equals(databaseSchemaUpdate)) {
            this.dbSchemaCreate();
        } else if ("false".equals(databaseSchemaUpdate)) {
            this.dbSchemaCheckVersion();
        } else if ("true".equals(databaseSchemaUpdate)) {
            this.dbSchemaUpdate();
        }
    }

    public void performSchemaOperationsProcessEngineClose() {
        String databaseSchemaUpdate = Context.getProcessEngineConfiguration().getDatabaseSchemaUpdate();
        if ("create-drop".equals(databaseSchemaUpdate)) {
            this.dbSchemaDrop();
        }
    }

    public DeploymentQueryImpl createDeploymentQuery() {
        return new DeploymentQueryImpl();
    }

    public ProcessDefinitionQueryImpl createProcessDefinitionQuery() {
        return new ProcessDefinitionQueryImpl();
    }

    public ProcessInstanceQueryImpl createProcessInstanceQuery() {
        return new ProcessInstanceQueryImpl();
    }

    public ExecutionQueryImpl createExecutionQuery() {
        return new ExecutionQueryImpl();
    }

    public TaskQueryImpl createTaskQuery() {
        return new TaskQueryImpl();
    }

    public JobQueryImpl createJobQuery() {
        return new JobQueryImpl();
    }

    public HistoricProcessInstanceQueryImpl createHistoricProcessInstanceQuery() {
        return new HistoricProcessInstanceQueryImpl();
    }

    public HistoricActivityInstanceQueryImpl createHistoricActivityInstanceQuery() {
        return new HistoricActivityInstanceQueryImpl();
    }

    public HistoricTaskInstanceQueryImpl createHistoricTaskInstanceQuery() {
        return new HistoricTaskInstanceQueryImpl();
    }

    public HistoricDetailQueryImpl createHistoricDetailQuery() {
        return new HistoricDetailQueryImpl();
    }

    public UserQueryImpl createUserQuery() {
        return new UserQueryImpl();
    }

    public GroupQueryImpl createGroupQuery() {
        return new GroupQueryImpl();
    }

    public SqlSession getSqlSession() {
        return this.sqlSession;
    }

    public DbSqlSessionFactory getDbSqlSessionFactory() {
        return this.dbSqlSessionFactory;
    }

    public static class CachedObject {
        protected PersistentObject persistentObject;
        protected Object persistentObjectState;

        public CachedObject(PersistentObject persistentObject, boolean storeState) {
            this.persistentObject = persistentObject;
            if (storeState) {
                this.persistentObjectState = persistentObject.getPersistentState();
            }
        }

        public PersistentObject getPersistentObject() {
            return this.persistentObject;
        }

        public Object getPersistentObjectState() {
            return this.persistentObjectState;
        }
    }

    public class DeleteBulk
    implements DeleteOperation {
        String statement;
        Object parameter;

        public DeleteBulk(String statement, Object parameter) {
            this.statement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(statement);
            this.parameter = parameter;
        }

        public void execute() {
            DbSqlSession.this.sqlSession.delete(this.statement, this.parameter);
        }

        public String toString() {
            return "bulk delete: " + this.statement;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class DeleteById
    implements DeleteOperation {
        Class<?> persistenceObjectClass;
        String persistentObjectId;

        public DeleteById(Class<?> clazz, String id) {
            this.persistenceObjectClass = clazz;
            this.persistentObjectId = id;
        }

        @Override
        public void execute() {
            String deleteStatement = DbSqlSession.this.dbSqlSessionFactory.getDeleteStatement(this.persistenceObjectClass);
            if ((deleteStatement = DbSqlSession.this.dbSqlSessionFactory.mapStatement(deleteStatement)) == null) {
                throw new ActivitiException("no delete statement for " + this.persistenceObjectClass + " in the ibatis mapping files");
            }
            log.fine("deleting: " + ClassNameUtil.getClassNameWithoutPackage(this.persistenceObjectClass) + "[" + this.persistentObjectId + "]");
            DbSqlSession.this.sqlSession.delete(deleteStatement, (Object)this.persistentObjectId);
        }

        public String toString() {
            return "delete " + ClassNameUtil.getClassNameWithoutPackage(this.persistenceObjectClass) + "[" + this.persistentObjectId + "]";
        }
    }

    public static interface DeleteOperation {
        public void execute();
    }
}

