/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.SuspensionState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSetProcessInstanceStateCmd
implements Command<Void> {
    protected final String executionId;

    public AbstractSetProcessInstanceStateCmd(String executionId) {
        this.executionId = executionId;
    }

    @Override
    public Void execute(CommandContext commandContext) {
        if (this.executionId == null) {
            throw new ActivitiException("ProcessInstanceId cannot be null.");
        }
        ExecutionEntity executionEntity = commandContext.getExecutionManager().findExecutionById(this.executionId);
        if (executionEntity == null) {
            throw new ActivitiException("Cannot find processInstance for id '" + this.executionId + "'.");
        }
        if (!executionEntity.isProcessInstance()) {
            throw new ActivitiException("Cannot set suspension state for execution '" + this.executionId + "': not a process instance.");
        }
        SuspensionState.SuspensionStateUtil.setSuspensionState(executionEntity, this.getNewState());
        return null;
    }

    protected abstract SuspensionState getNewState();
}

