/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.diagram;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.util.IoUtil;
import org.activiti.engine.impl.util.ReflectUtil;

public class ProcessDiagramCanvas {
    protected static final Logger LOGGER = Logger.getLogger(ProcessDiagramCanvas.class.getName());
    protected static final int ARROW_WIDTH = 5;
    protected static final int CONDITIONAL_INDICATOR_WIDTH = 16;
    protected static final int MARKER_WIDTH = 12;
    protected static Color TASK_COLOR = new Color(255, 255, 204);
    protected static Color BOUNDARY_EVENT_COLOR = new Color(255, 255, 255);
    protected static Color CONDITIONAL_INDICATOR_COLOR = new Color(255, 255, 255);
    protected static Color HIGHLIGHT_COLOR = Color.RED;
    protected static Stroke THICK_TASK_BORDER_STROKE = new BasicStroke(3.0f);
    protected static Stroke GATEWAY_TYPE_STROKE = new BasicStroke(3.0f);
    protected static Stroke END_EVENT_STROKE = new BasicStroke(3.0f);
    protected static Stroke MULTI_INSTANCE_STROKE = new BasicStroke(1.3f);
    protected static int ICON_SIZE = 16;
    protected static Image USERTASK_IMAGE;
    protected static Image SCRIPTTASK_IMAGE;
    protected static Image SERVICETASK_IMAGE;
    protected static Image RECEIVETASK_IMAGE;
    protected static Image SENDTASK_IMAGE;
    protected static Image MANUALTASK_IMAGE;
    protected static Image TIMER_IMAGE;
    protected static Image ERROR_THROW_IMAGE;
    protected static Image ERROR_CATCH_IMAGE;
    protected int canvasWidth = -1;
    protected int canvasHeight = -1;
    protected int minX = -1;
    protected int minY = -1;
    protected BufferedImage processDiagram;
    protected Graphics2D g;
    protected FontMetrics fontMetrics;
    protected boolean closed;

    public ProcessDiagramCanvas(int width, int height) {
        this.canvasWidth = width;
        this.canvasHeight = height;
        this.processDiagram = new BufferedImage(width, height, 2);
        this.g = this.processDiagram.createGraphics();
        this.g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.g.setPaint(Color.black);
        Font font = new Font("Arial", 1, 11);
        this.g.setFont(font);
        this.fontMetrics = this.g.getFontMetrics();
    }

    public ProcessDiagramCanvas(int width, int height, int minX, int minY) {
        this(width, height);
        this.minX = minX;
        this.minY = minY;
    }

    public InputStream generateImage(String imageType) {
        if (this.closed) {
            throw new ActivitiException("ProcessDiagramGenerator already closed");
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.minX = this.minX <= 5 ? 5 : this.minX;
            this.minY = this.minY <= 5 ? 5 : this.minY;
            BufferedImage imageToSerialize = this.processDiagram;
            if (this.minX >= 0 && this.minY >= 0) {
                imageToSerialize = this.processDiagram.getSubimage(this.minX - 5, this.minY - 5, this.canvasWidth - this.minX + 5, this.canvasHeight - this.minY + 5);
            }
            ImageIO.write((RenderedImage)imageToSerialize, imageType, out);
        }
        catch (IOException e) {
            throw new ActivitiException("Error while generating process image", e);
        }
        finally {
            IoUtil.closeSilently(out);
        }
        return new ByteArrayInputStream(out.toByteArray());
    }

    public void close() {
        this.g.dispose();
        this.closed = true;
    }

    public void drawNoneStartEvent(int x, int y, int width, int height) {
        this.drawStartEvent(x, y, width, height, null);
    }

    public void drawTimerStartEvent(int x, int y, int width, int height) {
        this.drawStartEvent(x, y, width, height, TIMER_IMAGE);
    }

    public void drawStartEvent(int x, int y, int width, int height, Image image) {
        this.g.draw(new Ellipse2D.Double(x, y, width, height));
        if (image != null) {
            this.g.drawImage(image, x, y, width, height, null);
        }
    }

    public void drawNoneEndEvent(int x, int y, int width, int height) {
        Stroke originalStroke = this.g.getStroke();
        this.g.setStroke(END_EVENT_STROKE);
        this.g.draw(new Ellipse2D.Double(x, y, width, height));
        this.g.setStroke(originalStroke);
    }

    public void drawErrorEndEvent(int x, int y, int width, int height) {
        this.drawNoneEndEvent(x, y, width, height);
        this.g.drawImage(ERROR_THROW_IMAGE, x + 3, y + 3, width - 6, height - 6, null);
    }

    public void drawCatchingEvent(int x, int y, int width, int height, Image image) {
        Ellipse2D.Double outerCircle = new Ellipse2D.Double(x, y, width, height);
        int innerCircleX = x + 3;
        int innerCircleY = y + 3;
        int innerCircleWidth = width - 6;
        int innerCircleHeight = height - 6;
        Ellipse2D.Double innerCircle = new Ellipse2D.Double(innerCircleX, innerCircleY, innerCircleWidth, innerCircleHeight);
        Paint originalPaint = this.g.getPaint();
        this.g.setPaint(BOUNDARY_EVENT_COLOR);
        this.g.fill(outerCircle);
        this.g.setPaint(originalPaint);
        this.g.draw(outerCircle);
        this.g.draw(innerCircle);
        this.g.drawImage(image, innerCircleX, innerCircleY, innerCircleWidth, innerCircleHeight, null);
    }

    public void drawCatchingTimerEvent(int x, int y, int width, int height) {
        this.drawCatchingEvent(x, y, width, height, TIMER_IMAGE);
    }

    public void drawCatchingErroEvent(int x, int y, int width, int height) {
        this.drawCatchingEvent(x, y, width, height, ERROR_CATCH_IMAGE);
    }

    public void drawSequenceflow(int srcX, int srcY, int targetX, int targetY, boolean conditional) {
        Line2D.Double line = new Line2D.Double(srcX, srcY, targetX, targetY);
        this.g.draw(line);
        this.drawArrowHead(line);
        if (conditional) {
            this.drawConditionalSequenceFlowIndicator(line);
        }
    }

    public void drawSequenceflowWithoutArrow(int srcX, int srcY, int targetX, int targetY, boolean conditional) {
        Line2D.Double line = new Line2D.Double(srcX, srcY, targetX, targetY);
        this.g.draw(line);
        if (conditional) {
            this.drawConditionalSequenceFlowIndicator(line);
        }
    }

    public void drawArrowHead(Line2D.Double line) {
        int doubleArrowWidth = 10;
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(0, 0);
        arrowHead.addPoint(-5, -doubleArrowWidth);
        arrowHead.addPoint(5, -doubleArrowWidth);
        AffineTransform transformation = new AffineTransform();
        transformation.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        transformation.translate(line.x2, line.y2);
        transformation.rotate(angle - 1.5707963267948966);
        AffineTransform originalTransformation = this.g.getTransform();
        this.g.setTransform(transformation);
        this.g.fill(arrowHead);
        this.g.setTransform(originalTransformation);
    }

    public void drawConditionalSequenceFlowIndicator(Line2D.Double line) {
        int horizontal = 11;
        int halfOfHorizontal = horizontal / 2;
        int halfOfVertical = 8;
        Polygon conditionalIndicator = new Polygon();
        conditionalIndicator.addPoint(0, 0);
        conditionalIndicator.addPoint(-halfOfHorizontal, halfOfVertical);
        conditionalIndicator.addPoint(0, 16);
        conditionalIndicator.addPoint(halfOfHorizontal, halfOfVertical);
        AffineTransform transformation = new AffineTransform();
        transformation.setToIdentity();
        double angle = Math.atan2(line.y2 - line.y1, line.x2 - line.x1);
        transformation.translate(line.x1, line.y1);
        transformation.rotate(angle - 1.5707963267948966);
        AffineTransform originalTransformation = this.g.getTransform();
        this.g.setTransform(transformation);
        this.g.draw(conditionalIndicator);
        Paint originalPaint = this.g.getPaint();
        this.g.setPaint(CONDITIONAL_INDICATOR_COLOR);
        this.g.fill(conditionalIndicator);
        this.g.setPaint(originalPaint);
        this.g.setTransform(originalTransformation);
    }

    public void drawTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height, false);
    }

    protected void drawTask(String name, int x, int y, int width, int height, boolean thickBorder) {
        Paint originalPaint = this.g.getPaint();
        this.g.setPaint(TASK_COLOR);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
        this.g.fill(rect);
        this.g.setPaint(originalPaint);
        if (thickBorder) {
            Stroke originalStroke = this.g.getStroke();
            this.g.setStroke(THICK_TASK_BORDER_STROKE);
            this.g.draw(rect);
            this.g.setStroke(originalStroke);
        } else {
            this.g.draw(rect);
        }
        if (name != null) {
            String text = this.fitTextToWidth(name, width);
            int textX = x + (width - this.fontMetrics.stringWidth(text)) / 2;
            int textY = y + (height - this.fontMetrics.getHeight()) / 2 + this.fontMetrics.getHeight();
            this.g.drawString(text, textX, textY);
        }
    }

    protected String fitTextToWidth(String original, int width) {
        String text = original;
        int maxWidth = width - 10;
        while (this.fontMetrics.stringWidth(text + "...") > maxWidth && text.length() > 0) {
            text = text.substring(0, text.length() - 1);
        }
        if (!text.equals(original)) {
            text = text + "...";
        }
        return text;
    }

    public void drawUserTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(USERTASK_IMAGE, x + 7, y + 7, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawScriptTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(SCRIPTTASK_IMAGE, x + 7, y + 7, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawServiceTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(SERVICETASK_IMAGE, x + 7, y + 7, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawReceiveTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(RECEIVETASK_IMAGE, x + 7, y + 7, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawSendTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(SENDTASK_IMAGE, x + 7, y + 7, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawManualTask(String name, int x, int y, int width, int height) {
        this.drawTask(name, x, y, width, height);
        this.g.drawImage(MANUALTASK_IMAGE, x + 7, y + 7, ICON_SIZE, ICON_SIZE, null);
    }

    public void drawExpandedSubProcess(String name, int x, int y, int width, int height) {
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
        this.g.draw(rect);
        String text = this.fitTextToWidth(name, width);
        this.g.drawString(text, x + 10, y + 15);
    }

    public void drawCollapsedSubProcess(String name, int x, int y, int width, int height) {
        this.drawCollapsedTask(name, x, y, width, height, false);
    }

    public void drawCollapsedCallActivity(String name, int x, int y, int width, int height) {
        this.drawCollapsedTask(name, x, y, width, height, true);
    }

    protected void drawCollapsedTask(String name, int x, int y, int width, int height, boolean thickBorder) {
        this.drawTask(name, x, y, width, height, thickBorder);
    }

    public void drawCollapsedMarker(int x, int y, int width, int height) {
        int rectangleWidth = 12;
        int rectangleHeight = 12;
        Rectangle rect = new Rectangle(x + (width - rectangleWidth) / 2, y + height - rectangleHeight - 3, rectangleWidth, rectangleHeight);
        this.g.draw(rect);
        Line2D.Double line = new Line2D.Double(rect.getCenterX(), rect.getY() + 2.0, rect.getCenterX(), rect.getMaxY() - 2.0);
        this.g.draw(line);
        line = new Line2D.Double(rect.getMinX() + 2.0, rect.getCenterY(), rect.getMaxX() - 2.0, rect.getCenterY());
        this.g.draw(line);
    }

    public void drawActivityMarkers(int x, int y, int width, int height, boolean multiInstanceSequential, boolean multiInstanceParallel, boolean collapsed) {
        if (collapsed) {
            if (!multiInstanceSequential && !multiInstanceParallel) {
                this.drawCollapsedMarker(x, y, width, height);
            } else {
                this.drawCollapsedMarker(x - 6 - 2, y, width, height);
                if (multiInstanceSequential) {
                    this.drawMultiInstanceMarker(true, x + 6 + 2, y, width, height);
                } else if (multiInstanceParallel) {
                    this.drawMultiInstanceMarker(false, x + 6 + 2, y, width, height);
                }
            }
        } else if (multiInstanceSequential) {
            this.drawMultiInstanceMarker(false, x, y, width, height);
        } else if (multiInstanceParallel) {
            this.drawMultiInstanceMarker(true, x, y, width, height);
        }
    }

    public void drawGateway(int x, int y, int width, int height) {
        Polygon rhombus = new Polygon();
        rhombus.addPoint(x, y + height / 2);
        rhombus.addPoint(x + width / 2, y + height);
        rhombus.addPoint(x + width, y + height / 2);
        rhombus.addPoint(x + width / 2, y);
        this.g.draw(rhombus);
    }

    public void drawParallelGateway(int x, int y, int width, int height) {
        this.drawGateway(x, y, width, height);
        Stroke orginalStroke = this.g.getStroke();
        this.g.setStroke(GATEWAY_TYPE_STROKE);
        Line2D.Double line = new Line2D.Double(x + 10, y + height / 2, x + width - 10, y + height / 2);
        this.g.draw(line);
        line = new Line2D.Double(x + width / 2, y + height - 10, x + width / 2, y + 10);
        this.g.draw(line);
        this.g.setStroke(orginalStroke);
    }

    public void drawExclusiveGateway(int x, int y, int width, int height) {
        this.drawGateway(x, y, width, height);
        int quarterWidth = width / 4;
        int quarterHeight = height / 4;
        Stroke orginalStroke = this.g.getStroke();
        this.g.setStroke(GATEWAY_TYPE_STROKE);
        Line2D.Double line = new Line2D.Double(x + quarterWidth + 3, y + quarterHeight + 3, x + 3 * quarterWidth - 3, y + 3 * quarterHeight - 3);
        this.g.draw(line);
        line = new Line2D.Double(x + quarterWidth + 3, y + 3 * quarterHeight - 3, x + 3 * quarterWidth - 3, y + quarterHeight + 3);
        this.g.draw(line);
        this.g.setStroke(orginalStroke);
    }

    public void drawInclusiveGateway(int x, int y, int width, int height) {
        this.drawGateway(x, y, width, height);
        int diameter = width / 2;
        Stroke orginalStroke = this.g.getStroke();
        this.g.setStroke(GATEWAY_TYPE_STROKE);
        Ellipse2D.Double circle = new Ellipse2D.Double((width - diameter) / 2 + x, (height - diameter) / 2 + y, diameter, diameter);
        this.g.draw(circle);
        this.g.setStroke(orginalStroke);
    }

    public void drawMultiInstanceMarker(boolean sequential, int x, int y, int width, int height) {
        int rectangleWidth = 12;
        int rectangleHeight = 12;
        int lineX = x + (width - rectangleWidth) / 2;
        int lineY = y + height - rectangleHeight - 3;
        Stroke orginalStroke = this.g.getStroke();
        this.g.setStroke(MULTI_INSTANCE_STROKE);
        if (sequential) {
            this.g.draw(new Line2D.Double(lineX, lineY, lineX + rectangleWidth, lineY));
            this.g.draw(new Line2D.Double(lineX, lineY + rectangleHeight / 2, lineX + rectangleWidth, lineY + rectangleHeight / 2));
            this.g.draw(new Line2D.Double(lineX, lineY + rectangleHeight, lineX + rectangleWidth, lineY + rectangleHeight));
        } else {
            this.g.draw(new Line2D.Double(lineX, lineY, lineX, lineY + rectangleHeight));
            this.g.draw(new Line2D.Double(lineX + rectangleWidth / 2, lineY, lineX + rectangleWidth / 2, lineY + rectangleHeight));
            this.g.draw(new Line2D.Double(lineX + rectangleWidth, lineY, lineX + rectangleWidth, lineY + rectangleHeight));
        }
        this.g.setStroke(orginalStroke);
    }

    public void drawHighLight(int x, int y, int width, int height) {
        Paint originalPaint = this.g.getPaint();
        Stroke originalStroke = this.g.getStroke();
        this.g.setPaint(HIGHLIGHT_COLOR);
        this.g.setStroke(THICK_TASK_BORDER_STROKE);
        RoundRectangle2D.Double rect = new RoundRectangle2D.Double(x, y, width, height, 20.0, 20.0);
        this.g.draw(rect);
        this.g.setPaint(originalPaint);
        this.g.setStroke(originalStroke);
    }

    static {
        try {
            USERTASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/user.png"));
            SCRIPTTASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/script.png"));
            SERVICETASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/service.png"));
            RECEIVETASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/receive.png"));
            SENDTASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/send.png"));
            MANUALTASK_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/manual.png"));
            TIMER_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/timer.png"));
            ERROR_THROW_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/error_throw.png"));
            ERROR_CATCH_IMAGE = ImageIO.read(ReflectUtil.getResourceAsStream("org/activiti/engine/impl/bpmn/deployer/error_catch.png"));
        }
        catch (IOException e) {
            LOGGER.warning("Could not load image for process diagram creation: " + e.getMessage());
        }
    }
}

