/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.util.List;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.identity.User;
import org.activiti.engine.identity.UserQuery;
import org.activiti.engine.impl.AbstractQuery;
import org.activiti.engine.impl.Page;
import org.activiti.engine.impl.UserQueryProperty;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserQueryImpl
extends AbstractQuery<UserQuery, User>
implements UserQuery {
    private static final long serialVersionUID = 1L;
    protected String id;
    protected String firstName;
    protected String firstNameLike;
    protected String lastName;
    protected String lastNameLike;
    protected String email;
    protected String emailLike;
    protected String groupId;

    public UserQueryImpl() {
    }

    public UserQueryImpl(CommandContext commandContext) {
        super(commandContext);
    }

    public UserQueryImpl(CommandExecutor commandExecutor) {
        super(commandExecutor);
    }

    @Override
    public UserQuery userId(String id) {
        if (id == null) {
            throw new ActivitiException("Provided id is null");
        }
        this.id = id;
        return this;
    }

    @Override
    public UserQuery userFirstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @Override
    public UserQuery userFirstNameLike(String firstNameLike) {
        if (firstNameLike == null) {
            throw new ActivitiException("Provided firstNameLike is null");
        }
        this.firstNameLike = firstNameLike;
        return this;
    }

    @Override
    public UserQuery userLastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @Override
    public UserQuery userLastNameLike(String lastNameLike) {
        if (lastNameLike == null) {
            throw new ActivitiException("Provided lastNameLike is null");
        }
        this.lastNameLike = lastNameLike;
        return this;
    }

    @Override
    public UserQuery userEmail(String email) {
        this.email = email;
        return this;
    }

    @Override
    public UserQuery userEmailLike(String emailLike) {
        if (emailLike == null) {
            throw new ActivitiException("Provided emailLike is null");
        }
        this.emailLike = emailLike;
        return this;
    }

    @Override
    public UserQuery memberOfGroup(String groupId) {
        if (groupId == null) {
            throw new ActivitiException("Provided groupIds is null or empty");
        }
        this.groupId = groupId;
        return this;
    }

    @Override
    public UserQuery orderByUserId() {
        return (UserQuery)this.orderBy(UserQueryProperty.USER_ID);
    }

    @Override
    public UserQuery orderByUserEmail() {
        return (UserQuery)this.orderBy(UserQueryProperty.EMAIL);
    }

    @Override
    public UserQuery orderByUserFirstName() {
        return (UserQuery)this.orderBy(UserQueryProperty.FIRST_NAME);
    }

    @Override
    public UserQuery orderByUserLastName() {
        return (UserQuery)this.orderBy(UserQueryProperty.LAST_NAME);
    }

    @Override
    public long executeCount(CommandContext commandContext) {
        this.checkQueryOk();
        return commandContext.getUserManager().findUserCountByQueryCriteria(this);
    }

    @Override
    public List<User> executeList(CommandContext commandContext, Page page) {
        this.checkQueryOk();
        return commandContext.getUserManager().findUserByQueryCriteria(this, page);
    }

    public String getId() {
        return this.id;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getFirstNameLike() {
        return this.firstNameLike;
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLastNameLike() {
        return this.lastNameLike;
    }

    public String getEmail() {
        return this.email;
    }

    public String getEmailLike() {
        return this.emailLike;
    }

    public String getGroupId() {
        return this.groupId;
    }
}

