/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.util;

import com.evolveum.midpoint.repo.sql.data.common.RContainer;
import com.evolveum.midpoint.repo.sql.data.common.RContainerType;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;

public final class ClassMapper {
    private static final Map<ObjectTypes, RContainerType> types = new HashMap<ObjectTypes, RContainerType>();

    static {
        types.put(ObjectTypes.ACCOUNT, RContainerType.ACCOUNT);
        types.put(ObjectTypes.CONNECTOR, RContainerType.CONNECTOR);
        types.put(ObjectTypes.CONNECTOR_HOST, RContainerType.CONNECTOR_HOST);
        types.put(ObjectTypes.GENERIC_OBJECT, RContainerType.GENERIC_OBJECT);
        types.put(ObjectTypes.OBJECT, RContainerType.OBJECT);
        types.put(ObjectTypes.PASSWORD_POLICY, RContainerType.PASSWORD_POLICY);
        types.put(ObjectTypes.RESOURCE, RContainerType.RESOURCE);
        types.put(ObjectTypes.RESOURCE_OBJECT_SHADOW, RContainerType.RESOURCE_OBJECT_SHADOW);
        types.put(ObjectTypes.ROLE, RContainerType.ROLE);
        types.put(ObjectTypes.SYSTEM_CONFIGURATION, RContainerType.SYSTEM_CONFIGURATION);
        types.put(ObjectTypes.TASK, RContainerType.TASK);
        types.put(ObjectTypes.USER, RContainerType.USER);
        types.put(ObjectTypes.USER_TEMPLATE, RContainerType.USER_TEMPLATE);
        types.put(ObjectTypes.NODE, RContainerType.NODE);
        ObjectTypes[] objectTypesArray = ObjectTypes.values();
        int n = objectTypesArray.length;
        int n2 = 0;
        while (n2 < n) {
            ObjectTypes type = objectTypesArray[n2];
            if (!types.containsKey(type)) {
                throw new IllegalStateException("Not all object types are mapped by sql repo impl. Found '" + type + "' unmapped.");
            }
            ++n2;
        }
    }

    private ClassMapper() {
    }

    public static Class<? extends RObject> getHQLTypeClass(Class<? extends ObjectType> clazz) {
        Validate.notNull(clazz, (String)"Class must not be null.");
        ObjectTypes type = ObjectTypes.getObjectType(clazz);
        Class<? extends RContainer> hqlType = types.get(type).getClazz();
        if (hqlType == null) {
            throw new IllegalStateException("Couldn't find DB type for '" + clazz + "'.");
        }
        return hqlType;
    }

    public static String getHQLType(Class<? extends ObjectType> clazz) {
        Class<? extends RObject> hqlType = ClassMapper.getHQLTypeClass(clazz);
        return hqlType.getSimpleName();
    }

    public static RContainerType getHQLTypeForQName(QName qname) {
        if (qname == null) {
            return null;
        }
        for (Map.Entry<ObjectTypes, RContainerType> entry : types.entrySet()) {
            if (!entry.getKey().getTypeQName().equals(qname)) continue;
            return entry.getValue();
        }
        throw new IllegalArgumentException("Couldn't find hql type for qname " + qname);
    }

    public static ObjectTypes getObjectTypeForHQLType(RContainerType type) {
        if (type == null) {
            return null;
        }
        for (Map.Entry<ObjectTypes, RContainerType> entry : types.entrySet()) {
            if (!entry.getValue().equals((Object)type)) continue;
            return entry.getKey();
        }
        throw new IllegalArgumentException("Couldn't find qname for hql type " + (Object)((Object)type));
    }

    public static QName getQNameForHQLType(RContainerType type) {
        ObjectTypes types = ClassMapper.getObjectTypeForHQLType(type);
        return types == null ? null : types.getTypeQName();
    }

    public static Collection<RContainerType> getKnownTypes() {
        return types.values();
    }
}

