/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.query;

import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.PropertyPathSegment;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.repo.sql.query.LogicalOp;
import com.evolveum.midpoint.repo.sql.query.Op;
import com.evolveum.midpoint.repo.sql.query.QueryException;
import com.evolveum.midpoint.repo.sql.query.SimpleOp;
import com.evolveum.midpoint.repo.sql.util.ClassMapper;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QueryInterpreter {
    private static final Trace LOGGER = TraceManager.getTrace(QueryInterpreter.class);
    private PrismContext prismContext;
    private Class<? extends ObjectType> type;
    private Map<PropertyPath, Criteria> criterions = new HashMap<PropertyPath, Criteria>();
    private Map<PropertyPath, String> aliases = new HashMap<PropertyPath, String>();

    public QueryInterpreter(Session session, Class<? extends ObjectType> type, PrismContext prismContext) {
        this.prismContext = prismContext;
        this.type = type;
        String alias = this.createAlias(ObjectTypes.getObjectType(type).getQName());
        Criteria criteria = session.createCriteria(ClassMapper.getHQLTypeClass(type), alias);
        this.setCriteria(null, criteria);
        this.setAlias(null, alias);
    }

    public Criteria interpret(Element filter) throws QueryException {
        Validate.notNull((Object)filter, (String)"Element filter must not be null.");
        LOGGER.debug("Interpreting query '{}', query on trace level.", new Object[]{DOMUtil.getQNameWithoutPrefix((Node)filter)});
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Query filter:\n{}", new Object[]{DOMUtil.printDom((Node)filter).toString()});
        }
        try {
            Criterion criterion = this.interpret(filter, false);
            Criteria criteria = this.getCriteria(null);
            criteria.add(criterion);
            return criteria;
        }
        catch (QueryException ex) {
            LOGGER.trace(ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        catch (Exception ex) {
            LOGGER.trace(ex.getMessage(), (Throwable)ex);
            throw new QueryException(ex.getMessage(), ex);
        }
    }

    public Criterion interpret(Element filter, boolean pushNot) throws QueryException {
        Op operation = new LogicalOp(this);
        if (operation.canHandle(filter)) {
            return operation.interpret(filter, pushNot);
        }
        operation = new SimpleOp(this);
        if (operation.canHandle(filter)) {
            return operation.interpret(filter, pushNot);
        }
        throw new QueryException("Unsupported query filter '" + DOMUtil.getQNameWithoutPrefix((Node)filter) + "'.");
    }

    public Class<? extends ObjectType> getType() {
        return this.type;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public ItemDefinition findDefinition(Element path, QName name) {
        LOGGER.trace("Looking for '{}' definition on path '{}'", new Object[]{name, path != null ? DOMUtil.serializeDOMToString((Node)path) : null});
        SchemaRegistry registry = this.prismContext.getSchemaRegistry();
        PrismObjectDefinition objectDef = registry.findObjectDefinitionByCompileTimeClass(this.type);
        PropertyPath propertyPath = this.createPropertyPath(path);
        if (propertyPath == null) {
            propertyPath = new PropertyPath();
        }
        List segments = propertyPath.getSegments();
        segments.add(new PropertyPathSegment(name));
        propertyPath = new PropertyPath(segments);
        LOGGER.trace("Checking item definition on path {}", new Object[]{propertyPath});
        ItemDefinition def = objectDef.findItemDefinition(propertyPath);
        if (def != null) {
            return def;
        }
        LOGGER.trace("Definition not found, checking global definitions.");
        return registry.findItemDefinitionByElementName(name);
    }

    public PropertyPath createPropertyPath(Element path) {
        PropertyPath propertyPath = null;
        if (path != null && StringUtils.isNotEmpty((String)path.getTextContent())) {
            propertyPath = new XPathHolder(path).toPropertyPath();
        }
        return propertyPath;
    }

    public String createAlias(QName qname) {
        String prefix = Character.toString(qname.getLocalPart().charAt(0)).toLowerCase();
        int index = 1;
        String alias = prefix;
        while (this.hasAlias(alias)) {
            alias = String.valueOf(prefix) + Integer.toString(index);
            if (++index <= 20) continue;
            throw new IllegalStateException("Alias index for segment '" + qname + "' is more than 20? Should not happen.");
        }
        return alias;
    }

    public Criteria getCriteria(PropertyPath path) {
        return this.criterions.get(path);
    }

    public void setCriteria(PropertyPath path, Criteria criteria) {
        Validate.notNull((Object)criteria, (String)"Criteria must not be null.");
        if (this.criterions.containsKey(path)) {
            throw new IllegalArgumentException("Already has criteria with this path '" + path + "'");
        }
        this.criterions.put(path, criteria);
    }

    public String getAlias(PropertyPath path) {
        return this.aliases.get(path);
    }

    public void setAlias(PropertyPath path, String alias) {
        Validate.notNull((Object)alias, (String)"Alias must not be null.");
        if (this.aliases.containsValue(alias)) {
            throw new IllegalArgumentException("Already has alias '" + alias + "' with this path '" + path + "'.");
        }
        this.aliases.put(path, alias);
    }

    public boolean hasAlias(String alias) {
        return this.aliases.containsValue(alias);
    }
}

