/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismReference;
import com.evolveum.midpoint.prism.PrismReferenceValue;
import com.evolveum.midpoint.prism.PrismValue;
import org.apache.commons.lang.Validate;

public enum RValueType {
    PROPERTY(PrismProperty.class, PrismPropertyValue.class),
    CONTAINER(PrismContainer.class, PrismContainerValue.class),
    OBJECT(PrismObject.class, PrismContainerValue.class),
    REFERENCE(PrismReference.class, PrismReferenceValue.class);

    private Class<? extends Item> itemClass;
    private Class<? extends PrismValue> valueClass;

    private RValueType(Class<? extends Item> itemClass, Class<? extends PrismValue> valueClass) {
        this.itemClass = itemClass;
        this.valueClass = valueClass;
    }

    public Class<? extends PrismValue> getValueClass() {
        return this.valueClass;
    }

    public Class<? extends Item> getItemClass() {
        return this.itemClass;
    }

    public static RValueType getTypeFromItemClass(Class<? extends Item> clazz) {
        Validate.notNull(clazz, (String)"Class must not be null.");
        RValueType[] rValueTypeArray = RValueType.values();
        int n = rValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RValueType value = rValueTypeArray[n2];
            if (value.getItemClass().isAssignableFrom(clazz)) {
                return value;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown enum value type for '" + clazz.getName() + "'.");
    }

    public static RValueType getTypeFromValueClass(Class<? extends PrismValue> clazz) {
        Validate.notNull(clazz, (String)"Class must not be null.");
        RValueType[] rValueTypeArray = RValueType.values();
        int n = rValueTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            RValueType value = rValueTypeArray[n2];
            if (value.getValueClass().isAssignableFrom(clazz)) {
                return value;
            }
            ++n2;
        }
        throw new IllegalArgumentException("Unknown enum value type for '" + clazz.getName() + "'.");
    }
}

