/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.Containerable;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.dom.PrismDomProcessor;
import com.evolveum.midpoint.prism.schema.SchemaRegistry;
import com.evolveum.midpoint.prism.xml.PrismJaxbProcessor;
import com.evolveum.midpoint.repo.sql.data.common.RContainer;
import com.evolveum.midpoint.repo.sql.data.common.REmbeddedReference;
import com.evolveum.midpoint.repo.sql.data.common.RObjectReference;
import com.evolveum.midpoint.repo.sql.data.common.RPolyString;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.prism.xml.ns._public.types_2.PolyStringType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class RUtil {
    public static final String NS_SQL_REPO = "http://midpoint.evolveum.com/xml/ns/fake/sqlRepository-1.xsd";
    static final QName CUSTOM_OBJECT = new QName("http://midpoint.evolveum.com/xml/ns/fake/sqlRepository-1.xsd", "sqlRepoObject");

    private RUtil() {
    }

    public static <T extends Objectable> void revive(Objectable object, PrismContext prismContext) throws DtoTranslationException {
        try {
            prismContext.adopt(object);
        }
        catch (SchemaException ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
    }

    public static <T> T toJAXB(String value, Class<T> clazz, PrismContext prismContext) throws SchemaException, JAXBException {
        return RUtil.toJAXB(null, null, value, clazz, prismContext);
    }

    public static <T> T toJAXB(Class<?> parentClass, PropertyPath path, String value, Class<T> clazz, PrismContext prismContext) throws SchemaException, JAXBException {
        if (StringUtils.isEmpty((String)value)) {
            return null;
        }
        Document document = DOMUtil.parseDocument((String)value);
        Element root = document.getDocumentElement();
        PrismDomProcessor domProcessor = prismContext.getPrismDomProcessor();
        if (Objectable.class.isAssignableFrom(clazz)) {
            if (root == null) {
                return null;
            }
            PrismObject object = domProcessor.parseObject(root);
            return (T)object.asObjectable();
        }
        if (Containerable.class.isAssignableFrom(clazz)) {
            Element firstChild = RUtil.getFirstSubElement(root);
            if (firstChild == null) {
                return null;
            }
            SchemaRegistry registry = prismContext.getSchemaRegistry();
            PrismObjectDefinition parentDefinition = registry.determineDefinitionFromClass(parentClass);
            PrismContainerDefinition definition = parentDefinition.findContainerDefinition(path);
            PrismContainer container = domProcessor.parsePrismContainer(firstChild, definition);
            return (T)container.getValue().asContainerable(clazz);
        }
        PrismJaxbProcessor jaxbProcessor = prismContext.getPrismJaxbProcessor();
        JAXBElement element = jaxbProcessor.unmarshalElement((Node)root, clazz);
        return (T)element.getValue();
    }

    private static Element getFirstSubElement(Element parent) {
        if (parent == null) {
            return null;
        }
        NodeList list = parent.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                return (Element)list.item(i);
            }
            ++i;
        }
        return null;
    }

    public static <T> String toRepo(T value, PrismContext prismContext) throws SchemaException, JAXBException {
        if (value == null) {
            return null;
        }
        PrismDomProcessor domProcessor = prismContext.getPrismDomProcessor();
        if (value instanceof Objectable) {
            return domProcessor.serializeObjectToString(((Objectable)value).asPrismObject());
        }
        if (value instanceof Containerable) {
            return domProcessor.serializeObjectToString(((Containerable)value).asPrismContainerValue(), RUtil.createFakeParentElement());
        }
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>();
        properties.put("jaxb.formatted.output", false);
        return prismContext.getPrismJaxbProcessor().marshalElementToString(new JAXBElement(CUSTOM_OBJECT, Object.class, value), properties);
    }

    private static Element createFakeParentElement() {
        return DOMUtil.createElement((Document)DOMUtil.getDocument(), (QName)CUSTOM_OBJECT);
    }

    public static <T> Set<T> listToSet(List<T> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return new HashSet<T>(list);
    }

    public static Set<RPolyString> listPolyToSet(List<PolyStringType> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashSet<RPolyString> set = new HashSet<RPolyString>();
        for (PolyStringType str : list) {
            set.add(RPolyString.copyFromJAXB(str));
        }
        return set;
    }

    public static List<PolyStringType> safeSetPolyToList(Set<RPolyString> set) {
        if (set == null || set.isEmpty()) {
            return new ArrayList<PolyStringType>();
        }
        ArrayList<PolyStringType> list = new ArrayList<PolyStringType>();
        for (RPolyString str : set) {
            list.add(RPolyString.copyToJAXB(str));
        }
        return list;
    }

    public static <T> List<T> safeSetToList(Set<T> set) {
        if (set == null || set.isEmpty()) {
            return new ArrayList();
        }
        ArrayList<T> list = new ArrayList<T>();
        list.addAll(set);
        return list;
    }

    public static RObjectReference jaxbRefToRepo(ObjectReferenceType ref, RContainer owner, PrismContext prismContext) {
        if (ref == null) {
            return null;
        }
        Validate.notNull((Object)owner, (String)"Owner of reference must not be null.");
        RObjectReference repoRef = new RObjectReference();
        repoRef.setOwner(owner);
        RObjectReference.copyFromJAXB(ref, repoRef, prismContext);
        return repoRef;
    }

    public static REmbeddedReference jaxbRefToEmbeddedRepoRef(ObjectReferenceType jaxb, PrismContext prismContext) {
        if (jaxb == null) {
            return null;
        }
        REmbeddedReference ref = new REmbeddedReference();
        REmbeddedReference.copyFromJAXB(jaxb, ref, prismContext);
        return ref;
    }

    public static Long getLongWrappedFromString(String text) {
        return StringUtils.isNotEmpty((String)text) && text.matches("[0-9]*") ? Long.valueOf(Long.parseLong(text)) : null;
    }

    public static long getLongFromString(String text) {
        Long value = RUtil.getLongWrappedFromString(text);
        return value != null ? value : 0L;
    }

    public static String getStringFromLong(Long id) {
        if (id == null) {
            return null;
        }
        return id.toString();
    }
}

